/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.areatools;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.kwpugh.gobber2.Gobber2;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1743;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2465;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_3614;
import net.minecraft.class_3959;
import net.minecraft.class_3965;

public class ModTreeAxe
extends class_1743 {
    public static final Set<class_2248> EFFECTIVE_ON = Sets.newHashSet((Object[])new class_2248[]{class_2246.field_10161, class_2246.field_9975, class_2246.field_10148, class_2246.field_10334, class_2246.field_10218, class_2246.field_10075, class_2246.field_10504, class_2246.field_10126, class_2246.field_10155, class_2246.field_10307, class_2246.field_10303, class_2246.field_9999, class_2246.field_10178, class_2246.field_10431, class_2246.field_10037, class_2246.field_10511, class_2246.field_10306, class_2246.field_10533, class_2246.field_10010, class_2246.field_10034, class_2246.field_10261, class_2246.field_10147, class_2246.field_10009, class_2246.field_10545, class_2246.field_9983, class_2246.field_16492, class_2246.field_10057, class_2246.field_10066, class_2246.field_10417, class_2246.field_10553, class_2246.field_10493, class_2246.field_10278, class_2246.field_10484, class_2246.field_10332, class_2246.field_10592, class_2246.field_10026, class_2246.field_10470, class_2246.field_10397, class_2246.field_22111, class_2246.field_22118, class_2246.field_10541, class_2246.field_22115});
    public static final Set<class_3614> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)class_3614.field_15932, (Object)class_3614.field_15954, (Object)class_3614.field_15925);
    public static final Random random = new Random();
    static List<class_2338> breakList = new ArrayList<class_2338>();
    class_2338 breakPos;
    static int delayTick = Gobber2.CONFIG.GENERAL.treeAxeDelayTick;

    public ModTreeAxe(class_1832 material, float attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(material, attackDamage, attackSpeed, settings);
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (!world.field_9236 && entity instanceof class_1657 && !breakList.isEmpty() && ((class_1657)entity).field_6012 % delayTick == 0) {
            this.breakPos = breakList.get(0);
            world.method_22352(this.breakPos, true);
            breakList.remove(0);
        }
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 mainHand = player.method_5998(hand);
        if (!world.field_9236) {
            for (int x = -5; x <= 5; ++x) {
                for (int y = -2; y <= 40; ++y) {
                    for (int z = -5; z <= 5; ++z) {
                        class_2338 pos = player.method_24515().method_10069(x, y, z);
                        class_2248 block = world.method_8320(pos).method_26204();
                        if (block != class_2246.field_10541 && block != class_2246.field_22115 && block != class_2246.field_22122) continue;
                        breakList.add(pos);
                    }
                }
            }
        }
        return class_1271.method_22427((Object)mainHand);
    }

    public class_1269 method_7884(class_1838 context) {
        class_2338 blockPos;
        class_1937 world = context.method_8045();
        class_2680 blockState = world.method_8320(blockPos = context.method_8037());
        class_2248 block = (class_2248)field_7898.get(blockState.method_26204());
        if (block != null) {
            class_1657 playerEntity = context.method_8036();
            world.method_8396(playerEntity, blockPos, class_3417.field_14675, class_3419.field_15245, 1.0f, 1.0f);
            if (!world.field_9236) {
                world.method_8652(blockPos, (class_2680)block.method_9564().method_11657((class_2769)class_2465.field_11459, (Comparable)((class_2350.class_2351)blockState.method_11654((class_2769)class_2465.field_11459))), 11);
                if (playerEntity != null) {
                    context.method_8041().method_7956(3, (class_1309)playerEntity, p -> ((class_1309)p).method_20236(context.method_20287()));
                }
            }
            return class_1269.method_29236((boolean)world.field_9236);
        }
        return class_1269.field_5811;
    }

    public boolean method_7879(class_1799 stack, class_1937 world, class_2680 state, class_2338 pos, class_1309 entity) {
        class_1657 player;
        if (!world.field_9236 && state.method_26214((class_1922)world, pos) != 0.0f && entity instanceof class_1657 && !this.attemptFellTree(world, pos, player = (class_1657)entity)) {
            ModTreeAxe.attemptBreakNeighbors(world, pos, player, EFFECTIVE_ON, EFFECTIVE_MATERIALS, false);
        }
        return super.method_7879(stack, world, state, pos, entity);
    }

    private boolean attemptFellTree(class_1937 world, class_2338 pos, class_1657 player) {
        if (!world.field_9236) {
            int i;
            ArrayList<class_2338> logs = new ArrayList<class_2338>();
            ArrayList<class_2338> candidates = new ArrayList<class_2338>();
            candidates.add(pos);
            int leaves = 0;
            for (i = 0; i < candidates.size(); ++i) {
                if (logs.size() > 200) {
                    player.method_7353((class_2561)new class_2588("Tree too big!"), true);
                    return false;
                }
                class_2338 candidate = (class_2338)candidates.get(i);
                class_2248 block = world.method_8320(candidate).method_26204();
                if (class_3481.field_15503.method_15141((Object)block) || block == class_2246.field_10541 || block == class_2246.field_22115) {
                    ++leaves;
                    continue;
                }
                if (logs.size() != 0 && !class_3481.field_15475.method_15141((Object)block)) continue;
                logs.add(candidate);
                for (int x = -1; x <= 1; ++x) {
                    for (int y = 0; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            class_2338 neighbor = candidate.method_10069(x, y, z);
                            if (candidates.contains(neighbor)) continue;
                            candidates.add(neighbor);
                        }
                    }
                }
            }
            if (logs.size() == 0) {
                return false;
            }
            if ((double)leaves >= (double)logs.size() / 6.0) {
                for (i = 0; i < logs.size(); ++i) {
                    class_2338 log = (class_2338)logs.get(i);
                    ModTreeAxe.attemptBreak(world, log, player, EFFECTIVE_ON, EFFECTIVE_MATERIALS);
                }
                return true;
            }
        }
        return false;
    }

    public static void attemptBreakNeighbors(class_1937 world, class_2338 pos, class_1657 player, Set<class_2248> effectiveOn, Set<class_3614> effectiveMaterials, boolean checkHarvestLevel) {
        if (world.field_9236) {
            return;
        }
        world.method_8501(pos, class_2246.field_10033.method_9564());
        class_3965 blockHitResult = ModTreeAxe.calcRay(world, player, class_3959.class_242.field_1347);
        world.method_8501(pos, class_2246.field_10124.method_9564());
        if (blockHitResult.method_17783() == class_239.class_240.field_1332) {
            class_3965 blockTrace = blockHitResult;
            class_2350 face = blockTrace.method_17780();
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    class_2338 target = null;
                    if (face == class_2350.field_11036 || face == class_2350.field_11033) {
                        target = pos.method_10069(a, 0, b);
                    }
                    if (face == class_2350.field_11043 || face == class_2350.field_11035) {
                        target = pos.method_10069(a, b, 0);
                    }
                    if (face == class_2350.field_11034 || face == class_2350.field_11039) {
                        target = pos.method_10069(0, a, b);
                    }
                    ModTreeAxe.attemptBreak(world, target, player, effectiveOn, effectiveMaterials);
                }
            }
        }
    }

    public static class_3965 calcRay(class_1937 worldIn, class_1657 player, class_3959.class_242 fluidMode) {
        float f = player.field_5965;
        float f1 = player.field_6031;
        class_243 vec3d = player.method_5836(1.0f);
        float f2 = class_3532.method_15362((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = class_3532.method_15374((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -class_3532.method_15362((float)(-f * ((float)Math.PI / 180)));
        float f5 = class_3532.method_15374((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = 3.0;
        class_243 vec3d1 = vec3d.method_1031((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.method_17742(new class_3959(vec3d, vec3d1, class_3959.class_3960.field_17559, fluidMode, (class_1297)player));
    }

    public static void attemptBreak(class_1937 world, class_2338 pos, class_1657 player, Set<class_2248> effectiveOn, Set<class_3614> effectiveMaterials) {
        boolean isEffective;
        class_2680 state = world.method_8320(pos);
        boolean bl = isEffective = effectiveOn.contains(state.method_26204()) || effectiveMaterials.contains(state.method_26207());
        if (player.method_7305(state) && isEffective) {
            breakList.add(pos);
        }
    }

    public void method_7851(class_1799 itemStack, class_1937 world, List<class_2561> tooltip, class_1836 tooltipContext) {
        tooltip.add((class_2561)new class_2588("item.gobber2.gobber2_tree_axe.tip1").method_27692(class_124.field_1060));
    }
}

