/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomArmorEnd
extends ArmorItem {
    boolean enablePerks = (Boolean)GobberConfigBuilder.ENABLE_GOBBER_END_ARMOR_HEALTH_PERKS.get();
    int hunger = (Integer)GobberConfigBuilder.GOBBER_END_ARMOR_HUNGER.get();
    double saturation = (Double)GobberConfigBuilder.GOBBER_END_ARMOR_SATURATION.get();

    public ItemCustomArmorEnd(IArmorMaterial materialIn, EquipmentSlotType slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        boolean isWearingFullEndArmor;
        if (!this.enablePerks) {
            return;
        }
        ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = player.func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
        this.setDamage(head, 0);
        this.setDamage(chest, 0);
        this.setDamage(legs, 0);
        this.setDamage(feet, 0);
        boolean bl = isWearingFullEndArmor = head != null && head.func_77973_b() == ItemInit.GOBBER2_HELMET_END.get() && chest != null && chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE_END.get() && legs != null && legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS_END.get() && feet != null && feet.func_77973_b() == ItemInit.GOBBER2_BOOTS_END.get();
        if (isWearingFullEndArmor) {
            if (player.func_70660_b(Effects.field_76440_q) != null) {
                player.func_195063_d(Effects.field_76440_q);
            }
            if (player.func_70660_b(Effects.field_76421_d) != null) {
                player.func_195063_d(Effects.field_76421_d);
            }
            if (player.func_70660_b(Effects.field_76419_f) != null) {
                player.func_195063_d(Effects.field_76419_f);
            }
            if (player.func_70660_b(Effects.field_76433_i) != null) {
                player.func_195063_d(Effects.field_76433_i);
            }
            if (player.func_70660_b(Effects.field_76431_k) != null) {
                player.func_195063_d(Effects.field_76431_k);
            }
            if (player.func_70660_b(Effects.field_76438_s) != null) {
                player.func_195063_d(Effects.field_76438_s);
            }
            if (player.func_70660_b(Effects.field_76436_u) != null) {
                player.func_195063_d(Effects.field_76436_u);
            }
            if (player.func_70660_b(Effects.field_82731_v) != null) {
                player.func_195063_d(Effects.field_82731_v);
            }
            if (player.func_70660_b(Effects.field_189112_A) != null) {
                player.func_195063_d(Effects.field_189112_A);
            }
            if (player.func_70660_b(Effects.field_76437_t) != null) {
                player.func_195063_d(Effects.field_76437_t);
            }
        }
        if (head.func_77973_b() == ItemInit.GOBBER2_HELMET_END.get()) {
            PlayerSpecialAbilities.giveYellowHearts(world, (LivingEntity)player, stack, 10, 0.33f);
            PlayerSpecialAbilities.giveRegenEffect(world, player, stack, this.hunger, (float)this.saturation);
        } else {
            PlayerSpecialAbilities.giveNoExtraHearts(world, player, stack);
        }
        if (chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE_END.get()) {
            // empty if block
        }
        if (legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS_END.get()) {
            // empty if block
        }
        if (feet.func_77973_b() == ItemInit.GOBBER2_BOOTS_END.get()) {
            // empty if block
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        stack.func_196082_o().func_74757_a("Unbreakable", true);
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ItemInit.GOBBER2_ARMOR_REPAIR.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (this.enablePerks) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor_end.line1").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor_end.line2").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor_end.line3").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor_end.line4").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor_end.line5").func_240699_a_(TextFormatting.GOLD));
        }
    }
}

