/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.armor;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.init.ItemInit;
import com.kwpugh.gobber2.util.PlayerSpecialAbilities;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomArmorGobber
extends ArmorItem {
    boolean enablePerks = (Boolean)GobberConfigBuilder.ENABLE_GOBBER_ARMOR_HEALTH_PERKS.get();
    int hunger = (Integer)GobberConfigBuilder.GOBBER_ARMOR_HUNGER.get();
    double saturation = (Double)GobberConfigBuilder.GOBBER_ARMOR_SATURATION.get();

    public ItemCustomArmorGobber(IArmorMaterial materialIn, EquipmentSlotType slots, Item.Properties builder) {
        super(materialIn, slots, builder);
    }

    public void onArmorTick(ItemStack stack, World world, PlayerEntity player) {
        if (!this.enablePerks) {
            return;
        }
        if (player instanceof PlayerEntity) {
            ItemStack head = player.func_184582_a(EquipmentSlotType.HEAD);
            ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
            ItemStack legs = player.func_184582_a(EquipmentSlotType.LEGS);
            ItemStack feet = player.func_184582_a(EquipmentSlotType.FEET);
            if (head.func_77973_b() == ItemInit.GOBBER2_HELMET.get() && chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE.get() && legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS.get() && feet.func_77973_b() == ItemInit.GOBBER2_BOOTS.get()) {
                if (player.func_70660_b(Effects.field_76436_u) != null) {
                    player.func_195063_d(Effects.field_76436_u);
                }
                if (player.func_70660_b(Effects.field_82731_v) != null) {
                    player.func_195063_d(Effects.field_82731_v);
                }
            }
            if (head.func_77973_b() == ItemInit.GOBBER2_HELMET.get()) {
                PlayerSpecialAbilities.giveRegenEffect(world, player, stack, this.hunger, (float)this.saturation);
            }
            if (chest.func_77973_b() == ItemInit.GOBBER2_CHESTPLATE.get()) {
                // empty if block
            }
            if (legs.func_77973_b() == ItemInit.GOBBER2_LEGGINGS.get()) {
                // empty if block
            }
            if (feet.func_77973_b() == ItemInit.GOBBER2_BOOTS.get()) {
                // empty if block
            }
        }
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return repair.func_77973_b() == ItemInit.GOBBER2_ARMOR_REPAIR.get();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor.line1").func_240699_a_(TextFormatting.AQUA));
        if (this.enablePerks) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor.line2").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor.line3").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor.line4").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor.line5").func_240699_a_(TextFormatting.LIGHT_PURPLE));
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_armor.line6").func_240699_a_(TextFormatting.GOLD));
        }
    }
}

