/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.medallions;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.util.ExpUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomMedallionExp
extends Item {
    public static final int MAX_STORAGE = 200000;
    private final Random random = new Random();

    public ItemCustomMedallionExp() {
        super(new Item.Properties().func_200918_c(200000).func_200916_a(Gobber2.gobber2));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_() && this.getXPStored(stack) != 200000) {
            int playerXP = ExpUtils.getPlayerXP(player);
            if (playerXP == 0) {
                return new ActionResult(ActionResultType.PASS, (Object)stack);
            }
            int actuallyStored = this.addXP(stack, playerXP);
            ExpUtils.addPlayerXP(player, -actuallyStored);
            if (!world.field_72995_K) {
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.1f, (this.random.nextFloat() - this.random.nextFloat()) * 0.35f + 0.9f);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        if (!player.func_225608_bj_() && this.getXPStored(stack) != 0) {
            if (this.getXPStored(stack) > 1401) {
                ExpUtils.addPlayerXP(player, 1401);
                this.setStoredXP(stack, this.getXPStored(stack) - 1401);
            } else {
                ExpUtils.addPlayerXP(player, this.getXPStored(stack));
                this.setStoredXP(stack, 0);
            }
            if (!world.field_72995_K) {
                float pitchMultiplier = player.field_71068_ca > 30 ? 1.0f : (float)player.field_71068_ca / 30.0f;
                world.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187802_ec, SoundCategory.PLAYERS, pitchMultiplier * 0.75f, 1.0f);
            }
            return new ActionResult(ActionResultType.SUCCESS, (Object)stack);
        }
        return new ActionResult(ActionResultType.PASS, (Object)stack);
    }

    public void func_77622_d(ItemStack stack, World worldIn, PlayerEntity playerIn) {
        stack.func_196085_b(200000);
    }

    public boolean func_77636_d(ItemStack stack) {
        return this.getXPStored(stack) > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public int addXP(ItemStack stack, int amount) {
        int stored = this.getXPStored(stack);
        if (stored + amount > 200000) {
            this.setStoredXP(stack, 200000);
            return 200000 - stored;
        }
        this.setStoredXP(stack, stored + amount);
        return amount;
    }

    public void setStoredXP(ItemStack stack, int amount) {
        stack.func_196085_b(200000 - amount);
    }

    public int getXPStored(ItemStack stack) {
        return 200000 - stack.func_77952_i();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_medallion_exp.line1").func_240699_a_(TextFormatting.GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_medallion_exp.line3").func_240699_a_(TextFormatting.BLUE));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_medallion_exp.line2", new Object[]{this.getXPStored(stack)}).func_240699_a_(TextFormatting.LIGHT_PURPLE));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line3").func_240699_a_(TextFormatting.YELLOW));
    }
}

