/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.util.EnableUtil;
import com.kwpugh.gobber2.util.MagnetRangeUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingAttraction
extends Item {
    int ringAttractionBlocking = (Integer)GobberConfigBuilder.RING_ATTRACTION_BLOCK_DISTANCE.get();
    boolean ringAttractionMode = (Boolean)GobberConfigBuilder.RING_ATTRACTION_MODE.get();
    static int range;

    public ItemCustomRingAttraction(Item.Properties properties) {
        super(properties);
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (entity instanceof PlayerEntity && !world.field_72995_K && EnableUtil.isEnabled(stack)) {
            PlayerEntity player = (PlayerEntity)entity;
            boolean init = MagnetRangeUtil.getCurrentlySet(stack);
            range = !init ? 8 : MagnetRangeUtil.getCurrentRange(stack);
            double x = player.func_226277_ct_();
            double y = player.func_226278_cu_();
            double z = player.func_226281_cx_();
            BlockPos playerPos = new BlockPos(player.func_213303_ch());
            for (Object targetPos : BlockPos.func_218278_a((BlockPos)playerPos.func_177982_a(-range, -this.ringAttractionBlocking, -range), (BlockPos)playerPos.func_177982_a(range, this.ringAttractionBlocking, range))) {
                BlockState blockstate = world.func_180495_p((BlockPos)targetPos);
                if (blockstate.func_177230_c() != Blocks.field_150402_ci) continue;
                return;
            }
            List items = entity.field_70170_p.func_217357_a(ItemEntity.class, new AxisAlignedBB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ItemEntity e : items) {
                if (player.func_225608_bj_() || e.getPersistentData().func_74767_n("PreventRemoteMovement")) continue;
                if (this.ringAttractionMode) {
                    e.func_70100_b_(player);
                    continue;
                }
                double factor = 0.035;
                e.func_70024_g((x - e.func_226277_ct_()) * factor, (y - e.func_226278_cu_() + 1.25) * factor, (z - e.func_226281_cx_()) * factor);
            }
            List xp = entity.field_70170_p.func_217357_a(ExperienceOrbEntity.class, new AxisAlignedBB(x - (double)range, y - (double)range, z - (double)range, x + (double)range, y + (double)range, z + (double)range));
            for (ExperienceOrbEntity orb : xp) {
                if (player.func_225608_bj_()) continue;
                if (this.ringAttractionMode) {
                    orb.func_70100_b_(player);
                    continue;
                }
                double factor = 0.035;
                orb.func_70024_g((x - orb.func_226277_ct_()) * factor, (y - orb.func_226278_cu_() + 1.25) * factor, (z - orb.func_226281_cx_()) * factor);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!world.field_72995_K && !player.func_225608_bj_()) {
            EnableUtil.changeEnabled(player, hand);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line2", new Object[]{EnableUtil.isEnabled(stack)}).func_240699_a_(TextFormatting.GREEN), true);
            return new ActionResult(ActionResultType.SUCCESS, (Object)player.func_184586_b(hand));
        }
        if (!world.field_72995_K && player.func_225608_bj_()) {
            switch (range) {
                case 8: {
                    range = 10;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).func_240699_a_(TextFormatting.GREEN), true);
                    break;
                }
                case 10: {
                    range = 12;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).func_240699_a_(TextFormatting.GREEN), true);
                    break;
                }
                case 12: {
                    range = 14;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).func_240699_a_(TextFormatting.GREEN), true);
                    break;
                }
                case 14: {
                    range = 4;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).func_240699_a_(TextFormatting.GREEN), true);
                    break;
                }
                case 4: {
                    range = 8;
                    MagnetRangeUtil.setCurrentRange(stack, range);
                    player.func_146105_b((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).func_240699_a_(TextFormatting.GREEN), true);
                    break;
                }
            }
        }
        return super.func_77659_a(world, player, hand);
    }

    public boolean func_77636_d(ItemStack stack) {
        return EnableUtil.isEnabled(stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line1").func_240699_a_(TextFormatting.GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line2", new Object[]{EnableUtil.isEnabled(stack)}).func_240699_a_(TextFormatting.GREEN));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line3").func_240699_a_(TextFormatting.YELLOW));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line4").func_240699_a_(TextFormatting.RED));
        tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line6").func_240699_a_(TextFormatting.BLUE));
        if (EnableUtil.isEnabled(stack)) {
            tooltip.add((ITextComponent)new TranslationTextComponent("item.gobber2.gobber2_ring_attraction.line5", new Object[]{MagnetRangeUtil.getCurrentRange(stack)}).func_240699_a_(TextFormatting.LIGHT_PURPLE));
        }
    }
}

