/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.util.handlers;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import com.kwpugh.gobber2.util.PlayerEquipsUtil;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingExperienceDropEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LootingLevelEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="gobber2", bus=Mod.EventBusSubscriber.Bus.FORGE)
public final class ForgeEventSubscriber {
    static int extraXPOrbs = (Integer)GobberConfigBuilder.MEDALLION_EXP_ORBS.get();
    static int extraLoot = (Integer)GobberConfigBuilder.MEDALLION_EXP_LOOT.get();
    static boolean enableVoidProtection = (Boolean)GobberConfigBuilder.ENABLE_DRAGON_ARMOR_VOID_PROTECTION.get();

    @SubscribeEvent(receiveCanceled=true, priority=EventPriority.HIGHEST)
    public static void onLivingHurtEvent(LivingAttackEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (enableVoidProtection && event.getSource() == DamageSource.field_76380_i && PlayerEquipsUtil.isPlayerGotVoidProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.field_76379_h && PlayerEquipsUtil.isPlayerGotFallProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if ((event.getSource() == DamageSource.field_76372_a || event.getSource() == DamageSource.field_76370_b || event.getSource() == DamageSource.field_76371_c) && PlayerEquipsUtil.isPlayerGotFireProtection(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
            if (event.getSource() == DamageSource.field_76369_e && PlayerEquipsUtil.isPlayerGotWaterBreathing(player) && event.isCancelable()) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSetAttackTarget(LivingSetAttackTargetEvent event) {
        if (event.getTarget() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity) {
            PlayerEntity player = (PlayerEntity)event.getTarget();
            MobEntity attacker = (MobEntity)event.getEntityLiving();
            if (PlayerEquipsUtil.isPlayerGotStealth(player)) {
                attacker.func_70624_b(null);
            }
        }
    }

    @SubscribeEvent
    public static void onKillingLootEvent(LootingLevelEvent event) {
        PlayerEntity player;
        if (event.getDamageSource() != null && event.getDamageSource().func_76346_g() != null && event.getEntity() instanceof MobEntity && event.getDamageSource().func_76346_g() instanceof PlayerEntity && PlayerEquipsUtil.isPlayerGotExpToken(player = (PlayerEntity)event.getDamageSource().func_76346_g())) {
            event.setLootingLevel(extraLoot);
        }
    }

    @SubscribeEvent
    public static void onKillingExpDropEvent(LivingExperienceDropEvent event) {
        PlayerEntity player;
        if (event.getAttackingPlayer() instanceof PlayerEntity && event.getEntityLiving() instanceof MobEntity && PlayerEquipsUtil.isPlayerGotExpToken(player = event.getAttackingPlayer())) {
            int orgExp = event.getOriginalExperience();
            int newExp = orgExp * extraXPOrbs;
            event.setDroppedExperience(newExp);
        }
    }

    @SubscribeEvent
    public static void onMiningExpDropEvent(BlockEvent.BreakEvent event) {
        PlayerEntity player;
        Block block = event.getState().func_177230_c();
        if ((block == Blocks.field_150450_ax || block == Blocks.field_150365_q || block == Blocks.field_150369_x || block == Blocks.field_150482_ag || block == Blocks.field_150412_bA || block == Blocks.field_196766_fg) && event.getPlayer() instanceof PlayerEntity && PlayerEquipsUtil.isPlayerGotExpToken(player = event.getPlayer()) && EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185306_r, (ItemStack)player.func_184614_ca()) == 0) {
            event.setExpToDrop(extraXPOrbs);
        }
    }
}

