/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.medallions;

import com.kwpugh.gobber2.Gobber2;
import com.kwpugh.gobber2.util.ExpUtils;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomMedallionExp
extends Item {
    public static final int MAX_STORAGE = 200000;
    private final Random random = new Random();

    public ItemCustomMedallionExp() {
        super(new Item.Properties().m_41503_(200000).m_41491_(Gobber2.gobber2));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (player.m_6144_() && this.getXPStored(stack) != 200000) {
            int playerXP = ExpUtils.getPlayerXP(player);
            if (playerXP == 0) {
                return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
            }
            int actuallyStored = this.addXP(stack, playerXP);
            ExpUtils.addPlayerXP(player, -actuallyStored);
            if (!world.f_46443_) {
                world.m_5594_(null, player.m_142538_(), SoundEvents.f_11871_, SoundSource.PLAYERS, 0.1f, (this.random.nextFloat() - this.random.nextFloat()) * 0.35f + 0.9f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        if (!player.m_6144_() && this.getXPStored(stack) != 0) {
            if (this.getXPStored(stack) > 1401) {
                ExpUtils.addPlayerXP(player, 1401);
                this.setStoredXP(stack, this.getXPStored(stack) - 1401);
            } else {
                ExpUtils.addPlayerXP(player, this.getXPStored(stack));
                this.setStoredXP(stack, 0);
            }
            if (!world.f_46443_) {
                float pitchMultiplier = player.f_36078_ > 30 ? 1.0f : (float)player.f_36078_ / 30.0f;
                world.m_5594_(null, player.m_142538_(), SoundEvents.f_12275_, SoundSource.PLAYERS, pitchMultiplier * 0.75f, 1.0f);
            }
            return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)stack);
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        stack.m_41721_(200000);
    }

    public boolean m_5812_(ItemStack stack) {
        return this.getXPStored(stack) > 0;
    }

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return false;
    }

    public boolean m_8120_(ItemStack stack) {
        return false;
    }

    public boolean m_6832_(ItemStack toRepair, ItemStack repair) {
        return false;
    }

    public boolean isRepairable(ItemStack stack) {
        return false;
    }

    public int addXP(ItemStack stack, int amount) {
        int stored = this.getXPStored(stack);
        if (stored + amount > 200000) {
            this.setStoredXP(stack, 200000);
            return 200000 - stored;
        }
        this.setStoredXP(stack, stored + amount);
        return amount;
    }

    public void setStoredXP(ItemStack stack, int amount) {
        stack.m_41721_(200000 - amount);
    }

    public int getXPStored(ItemStack stack) {
        return 200000 - stack.m_41773_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_medallion_exp.line1").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_medallion_exp.line3").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_medallion_exp.line2", new Object[]{this.getXPStored(stack)}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_attraction.line3").m_130940_(ChatFormatting.YELLOW));
    }
}

