/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import com.kwpugh.gobber2.config.GobberConfigBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.Tag;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.GravelBlock;
import net.minecraft.world.level.block.SandBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemCustomRingMiner
extends Item {
    public static final int BREAK_DELAY = 1;
    int ringMinerCooldown = (Integer)GobberConfigBuilder.RING_MINER_COOLDOWN.get();
    boolean reverseRingMiner = (Boolean)GobberConfigBuilder.REVERSE_RING_MINER.get();
    boolean delayedBreakMode = (Boolean)GobberConfigBuilder.DELAY_BREAK_MODE.get();
    boolean shiftKeyPressed = false;

    public ItemCustomRingMiner(Item.Properties properties) {
        super(properties);
    }

    public InteractionResultHolder<ItemStack> m_7203_(final Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        ItemStack equippedMain = player.m_21205_();
        if (equippedMain == stack) {
            this.shiftKeyPressed = player.m_6144_();
            player.m_36335_().m_41524_((Item)this, this.ringMinerCooldown);
            if (!world.f_46443_) {
                Block block;
                final ArrayList<BlockPos> poslist = new ArrayList<BlockPos>();
                for (int x = 5; x >= -5; --x) {
                    for (int y = 4; y >= 0; --y) {
                        for (int z = 5; z >= -5; --z) {
                            BlockPos pos = player.m_142538_().m_142082_(x, y, z);
                            BlockState state = world.m_8055_(pos);
                            block = state.m_60734_();
                            String blockForgeTags = block.getTags().toString();
                            if (block != Blocks.f_50069_ && !state.m_60620_((Tag)BlockTags.f_13061_) && !state.m_60620_((Tag)BlockTags.f_13062_) && !blockForgeTags.contains("forge:stone") && !blockForgeTags.contains("forge:sandstone") && !blockForgeTags.contains("forge:sand") && !blockForgeTags.contains("forge:dirt") && !blockForgeTags.contains("forge:gravel") && !(block instanceof GravelBlock) && !(block instanceof SandBlock) && block != Blocks.f_50493_ && block != Blocks.f_152481_ && block != Blocks.f_49992_ && block != Blocks.f_49993_ && block != Blocks.f_50062_ && block != Blocks.f_50394_ && block != Blocks.f_49994_ && block != Blocks.f_50440_ && block != Blocks.f_50546_ && block != Blocks.f_50599_ && block != Blocks.f_50195_ && block != Blocks.f_50122_ && block != Blocks.f_50334_ && block != Blocks.f_50228_ && block != Blocks.f_50135_ && block != Blocks.f_50136_ && block != Blocks.f_50079_ && block != Blocks.f_50647_ && block != Blocks.f_50633_ && block != Blocks.f_50223_ && block != Blocks.f_50631_ && block != Blocks.f_50645_ && block != Blocks.f_50222_ && block != Blocks.f_50194_ && block != Blocks.f_50411_ && block != Blocks.f_50224_ && block != Blocks.f_50178_ && block != Blocks.f_50179_ && block != Blocks.f_50227_ && block != Blocks.f_50177_ && block != Blocks.f_50259_ && block != Blocks.f_50137_ && block != Blocks.f_50730_ && block != Blocks.f_50450_ && block != Blocks.f_50451_ && block != Blocks.f_50692_ && block != Blocks.f_50134_) continue;
                            poslist.add(player.m_142538_().m_142082_(x, y, z));
                        }
                    }
                }
                if (this.delayedBreakMode) {
                    if (!poslist.isEmpty()) {
                        MinecraftForge.EVENT_BUS.register(new Object(){
                            int delay = 1;
                            int i = 0;

                            @SubscribeEvent
                            public void onTick(TickEvent.WorldTickEvent event) {
                                if (this.delay-- > 0) {
                                    return;
                                }
                                this.delay = 1;
                                if (this.i < poslist.size()) {
                                    BlockPos breakPos = (BlockPos)poslist.get(this.i);
                                    if (ItemCustomRingMiner.this.shiftKeyPressed) {
                                        world.m_46961_(breakPos, !ItemCustomRingMiner.this.reverseRingMiner);
                                    } else {
                                        world.m_46961_(breakPos, ItemCustomRingMiner.this.reverseRingMiner);
                                    }
                                    ++this.i;
                                } else {
                                    MinecraftForge.EVENT_BUS.unregister((Object)this);
                                }
                            }
                        });
                    }
                } else if (!poslist.isEmpty()) {
                    for (int i = 0; i <= poslist.size() - 1; ++i) {
                        BlockPos targetpos = (BlockPos)poslist.get(i);
                        block = world.m_8055_(targetpos).m_60734_();
                        if (player.m_6144_()) {
                            world.m_46961_(targetpos, !this.reverseRingMiner);
                            continue;
                        }
                        world.m_46961_(targetpos, this.reverseRingMiner);
                    }
                }
            }
        }
        return new InteractionResultHolder(InteractionResult.SUCCESS, (Object)stack);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_miner.line1").m_130940_(ChatFormatting.GREEN));
        if (this.reverseRingMiner) {
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_miner.line4").m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_miner.line5").m_130940_(ChatFormatting.YELLOW));
        } else {
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_miner.line2").m_130940_(ChatFormatting.YELLOW));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_miner.line3").m_130940_(ChatFormatting.YELLOW));
        }
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_miner.line6").m_130940_(ChatFormatting.LIGHT_PURPLE));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring.cooldown", new Object[]{this.ringMinerCooldown}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        if (this.delayedBreakMode) {
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_miner.mode.line2").m_130940_(ChatFormatting.LIGHT_PURPLE));
        } else {
            tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_ring_miner.mode.line1").m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }
}

