/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.rings;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ItemCustomRingTeleport
extends Item {
    public ItemCustomRingTeleport(Item.Properties properties) {
        super(properties);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        Direction direction = context.m_43719_();
        ItemStack stackRing = context.m_43723_().m_21205_();
        if (ItemCustomRingTeleport.getPosition(stackRing) == null && player.m_6047_()) {
            ItemCustomRingTeleport.setPosition(stackRing, world, pos.m_142300_(direction), player);
            player.m_6352_((Component)new TranslatableComponent("item.gobber2.ring_teleport.line1").m_130940_(ChatFormatting.YELLOW), null);
            return InteractionResult.SUCCESS;
        }
        if (ItemCustomRingTeleport.getPosition(stackRing) != null) {
            player.m_6352_((Component)new TranslatableComponent("item.gobber2.ring_teleport.line2").m_130940_(ChatFormatting.YELLOW), null);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        if (ItemCustomRingTeleport.getPosition(stack) != null && !player.m_6047_()) {
            this.teleport(player, world, stack);
            world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11757_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
        if (ItemCustomRingTeleport.getPosition(stack) != null && player.m_6047_()) {
            ItemCustomRingTeleport.setPosition(stack, world, null, player);
            player.m_6352_((Component)new TranslatableComponent("item.gobber2.ring_teleport.line3").m_130940_(ChatFormatting.YELLOW), null);
        }
        return new InteractionResultHolder(InteractionResult.PASS, (Object)player.m_21120_(hand));
    }

    public static BlockPos getPosition(ItemStack stack) {
        if (!stack.m_41782_()) {
            return null;
        }
        CompoundTag tags = stack.m_41783_();
        if (tags.m_128441_("pos")) {
            return NbtUtils.m_129239_((CompoundTag)((CompoundTag)tags.m_128423_("pos")));
        }
        return null;
    }

    public static int getDimension(ItemStack stack) {
        if (!stack.m_41782_()) {
            return Integer.MAX_VALUE;
        }
        CompoundTag tags = stack.m_41783_();
        if (tags.m_128441_("dim")) {
            return tags.m_128451_("dim");
        }
        return Integer.MAX_VALUE;
    }

    public static void setPosition(ItemStack stack, Level world, BlockPos pos, Player player) {
        if (world.f_46443_) {
            return;
        }
        CompoundTag tags = !stack.m_41782_() ? new CompoundTag() : stack.m_41783_();
        if (pos == null) {
            tags.m_128473_("pos");
            tags.m_128473_("dim");
        } else {
            tags.m_128365_("pos", (Tag)NbtUtils.m_129224_((BlockPos)pos));
            if (world.m_46472_().equals((Object)Level.f_46428_)) {
                tags.m_128405_("dim", 0);
            }
            if (world.m_46472_().equals((Object)Level.f_46429_)) {
                tags.m_128405_("dim", -1);
            }
            if (world.m_46472_().equals((Object)Level.f_46430_)) {
                tags.m_128405_("dim", 1);
            }
        }
        stack.m_41751_(tags);
    }

    public void teleport(Player player, Level world, ItemStack stack) {
        if (world.f_46443_) {
            return;
        }
        BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
        int dim = ItemCustomRingTeleport.getDimension(stack);
        if (world.m_46472_().equals((Object)Level.f_46428_) && dim == 0) {
            player.m_6021_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f));
        } else if (world.m_46472_().equals((Object)Level.f_46429_) && dim == -1) {
            player.m_6021_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f));
        } else if (world.m_46472_().equals((Object)Level.f_46430_) && dim == 1) {
            player.m_6021_((double)((float)pos.m_123341_() + 0.5f), (double)pos.m_123342_(), (double)((float)pos.m_123343_() + 0.5f));
        } else {
            player.m_6352_((Component)new TranslatableComponent("item.gobber2.ring_teleport.line8").m_130940_(ChatFormatting.YELLOW), null);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag flag) {
        String dimName = switch (ItemCustomRingTeleport.getDimension(stack)) {
            case 1 -> "End";
            case 0 -> "OverWorld";
            case -1 -> "Nether";
            default -> "Unknown";
        };
        super.m_7373_(stack, world, tooltip, flag);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line9").m_130940_(ChatFormatting.GREEN));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line10").m_130940_(ChatFormatting.AQUA));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line11").m_130940_(ChatFormatting.BLUE));
        tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line12").m_130940_(ChatFormatting.RED));
        if (ItemCustomRingTeleport.getPosition(stack) != null) {
            BlockPos pos = ItemCustomRingTeleport.getPosition(stack);
            tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line13").m_130940_(ChatFormatting.GREEN));
            tooltip.add((Component)new TranslatableComponent("item.gobber2.ring_teleport.line14", new Object[]{dimName, pos.m_123341_(), pos.m_123342_(), pos.m_123343_()}).m_130940_(ChatFormatting.LIGHT_PURPLE));
        }
    }
}

