/*
 * Decompiled with CFR 0.152.
 */
package com.kwpugh.gobber2.items.tools.axe;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ItemCustomTreeAxeEnd
extends AxeItem {
    public static final Set<Block> EFFECTIVE_ON = Sets.newHashSet((Object[])new Block[]{Blocks.f_50705_, Blocks.f_50741_, Blocks.f_50742_, Blocks.f_50743_, Blocks.f_50744_, Blocks.f_50745_, Blocks.f_50078_, Blocks.f_50011_, Blocks.f_50012_, Blocks.f_50013_, Blocks.f_50014_, Blocks.f_50015_, Blocks.f_50043_, Blocks.f_49999_, Blocks.f_50000_, Blocks.f_50001_, Blocks.f_50002_, Blocks.f_50003_, Blocks.f_50004_, Blocks.f_50087_, Blocks.f_50133_, Blocks.f_50143_, Blocks.f_50144_, Blocks.f_50186_, Blocks.f_50155_, Blocks.f_50616_, Blocks.f_50251_, Blocks.f_50252_, Blocks.f_50253_, Blocks.f_50254_, Blocks.f_50309_, Blocks.f_50308_, Blocks.f_50167_, Blocks.f_50168_, Blocks.f_50169_, Blocks.f_50170_, Blocks.f_50172_, Blocks.f_50171_});
    public static final Set<Material> EFFECTIVE_MATERIALS = ImmutableSet.of((Object)Material.f_76320_, (Object)Material.f_76285_, (Object)Material.f_76277_);
    public static final int LOG_BREAK_DELAY = 1;
    public static final Random random = new Random();

    public ItemCustomTreeAxeEnd(Tier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
    }

    public void m_7836_(ItemStack stack, Level worldIn, Player playerIn) {
        stack.m_41784_().m_128379_("Unbreakable", true);
    }

    public boolean m_6813_(ItemStack stack, Level world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!world.f_46443_ && state.m_60800_((BlockGetter)world, pos) != 0.0f) {
            Player player;
            stack.m_41629_(0, random, null);
            if (entityLiving instanceof Player && !this.attemptFellTree(world, pos, player = (Player)entityLiving)) {
                ItemCustomTreeAxeEnd.attemptBreakNeighbors(world, pos, player, EFFECTIVE_ON, EFFECTIVE_MATERIALS, false);
            }
            stack.m_41629_(0, random, null);
        }
        return true;
    }

    private boolean attemptFellTree(final Level world, BlockPos pos, final Player player) {
        final ArrayList<BlockPos> logs = new ArrayList<BlockPos>();
        ArrayList<BlockPos> candidates = new ArrayList<BlockPos>();
        candidates.add(pos);
        int leaves = 0;
        for (int i = 0; i < candidates.size(); ++i) {
            if (logs.size() > 200) {
                return false;
            }
            BlockPos candidate = (BlockPos)candidates.get(i);
            Block block = world.m_8055_(candidate).m_60734_();
            if (BlockTags.f_13035_.m_8110_((Object)block)) {
                ++leaves;
                continue;
            }
            if (logs.size() != 0 && !BlockTags.f_13106_.m_8110_((Object)block)) continue;
            logs.add(candidate);
            for (int x = -1; x <= 1; ++x) {
                for (int y = 0; y <= 1; ++y) {
                    for (int z = -1; z <= 1; ++z) {
                        BlockPos neighbor = candidate.m_142082_(x, y, z);
                        if (candidates.contains(neighbor)) continue;
                        candidates.add(neighbor);
                    }
                }
            }
        }
        if (logs.size() == 0) {
            return false;
        }
        if ((double)leaves >= (double)logs.size() / 6.0) {
            MinecraftForge.EVENT_BUS.register(new Object(){
                int fortuneLevel;
                int silkLevel;
                int delay;
                int i;
                {
                    this.fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_());
                    this.silkLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
                    this.delay = 1;
                    this.i = 0;
                }

                @SubscribeEvent
                public void onTick(TickEvent.WorldTickEvent event) {
                    if (this.delay-- > 0) {
                        return;
                    }
                    this.delay = 1;
                    if (this.i < logs.size()) {
                        BlockPos log = (BlockPos)logs.get(this.i);
                        ItemCustomTreeAxeEnd.attemptBreak(world, log, player, EFFECTIVE_ON, EFFECTIVE_MATERIALS, this.fortuneLevel, this.silkLevel, false);
                        ++this.i;
                    } else {
                        MinecraftForge.EVENT_BUS.unregister((Object)this);
                    }
                }
            });
            return true;
        }
        return false;
    }

    public static void attemptBreakNeighbors(Level world, BlockPos pos, Player player, Set<Block> effectiveOn, Set<Material> effectiveMaterials, boolean checkHarvestLevel) {
        world.m_46597_(pos, Blocks.f_50058_.m_49966_());
        HitResult trace = ItemCustomTreeAxeEnd.calcRayTrace(world, player, ClipContext.Fluid.ANY);
        world.m_46597_(pos, Blocks.f_50016_.m_49966_());
        if (trace.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockTrace = (BlockHitResult)trace;
            Direction face = blockTrace.m_82434_();
            int fortuneLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)player.m_21205_());
            int silkLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)player.m_21205_());
            for (int a = -1; a <= 1; ++a) {
                for (int b = -1; b <= 1; ++b) {
                    if (a == 0 && b == 0) continue;
                    BlockPos target = null;
                    if (face == Direction.UP || face == Direction.DOWN) {
                        target = pos.m_142082_(a, 0, b);
                    }
                    if (face == Direction.NORTH || face == Direction.SOUTH) {
                        target = pos.m_142082_(a, b, 0);
                    }
                    if (face == Direction.EAST || face == Direction.WEST) {
                        target = pos.m_142082_(0, a, b);
                    }
                    ItemCustomTreeAxeEnd.attemptBreak(world, target, player, effectiveOn, effectiveMaterials, fortuneLevel, silkLevel, checkHarvestLevel);
                }
            }
        }
    }

    public static void attemptBreak(Level world, BlockPos pos, Player player, Set<Block> effectiveOn, Set<Material> effectiveMaterials, int fortuneLevel, int silkLevel, boolean checkHarvestLevel) {
        BlockState state = world.m_8055_(pos);
        boolean validHarvest = !checkHarvestLevel || player.m_21205_().m_41735_(state);
        boolean isEffective = effectiveOn.contains(state.m_60734_()) || effectiveMaterials.contains(state.m_60767_());
        boolean witherImmune = BlockTags.f_13070_.m_8110_((Object)state.m_60734_());
        if (validHarvest && isEffective && !witherImmune) {
            world.m_46961_(pos, false);
            Block.m_49881_((BlockState)state, (Level)world, (BlockPos)pos, null, (Entity)player, (ItemStack)player.m_21205_());
            int exp = state.getExpDrop((LevelReader)world, pos, fortuneLevel, silkLevel);
            if (exp > 0) {
                state.m_60734_().m_49805_((ServerLevel)world, pos, exp);
            }
        }
    }

    public static HitResult calcRayTrace(Level worldIn, Player player, ClipContext.Fluid fluidMode) {
        float f = player.f_19860_;
        float f1 = player.f_19859_;
        Vec3 vec3d = player.m_20299_(1.0f);
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        double d0 = player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_();
        Vec3 vec3d1 = vec3d.m_82520_((double)f6 * d0, (double)f5 * d0, (double)f7 * d0);
        return worldIn.m_45547_(new ClipContext(vec3d, vec3d1, ClipContext.Block.OUTLINE, fluidMode, (Entity)player));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TranslatableComponent("item.gobber2.gobber2_tree_axe.line1").m_130940_(ChatFormatting.GREEN));
    }
}

