/*
 * Decompiled with CFR 0.152.
 */
package tallestegg.guardvillagers;

import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.AbstractIllager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Spider;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.raid.Raider;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import tallestegg.guardvillagers.GuardEntityType;
import tallestegg.guardvillagers.configuration.GuardConfig;
import tallestegg.guardvillagers.entities.Guard;
import tallestegg.guardvillagers.entities.ai.goals.AttackEntityDaytimeGoal;
import tallestegg.guardvillagers.entities.ai.goals.HealGolemGoal;
import tallestegg.guardvillagers.entities.ai.goals.HealGuardAndPlayerGoal;

@Mod.EventBusSubscriber(modid="guardvillagers")
public class HandlerEvents {
    @SubscribeEvent
    public static void onEntityTarget(LivingSetAttackTargetEvent event) {
        boolean isVillager;
        LivingEntity entity = (LivingEntity)event.getEntity();
        LivingEntity target = event.getTarget();
        if (target == null || entity.m_6095_() == GuardEntityType.GUARD.get()) {
            return;
        }
        boolean bl = isVillager = target.m_6095_() == EntityType.f_20492_ || target.m_6095_() == GuardEntityType.GUARD.get();
        if (isVillager) {
            List list = entity.f_19853_.m_45976_(Mob.class, entity.m_142469_().m_82377_(GuardConfig.GuardVillagerHelpRange, 5.0, GuardConfig.GuardVillagerHelpRange));
            for (Mob mob : list) {
                if (mob.m_6095_() != GuardEntityType.GUARD.get() && mob.m_6095_() != EntityType.f_20460_ || mob.m_5448_() != null) continue;
                mob.m_6710_(entity);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityHurt(LivingHurtEvent event) {
        boolean isGolem;
        LivingEntity entity = (LivingEntity)event.getEntity();
        Entity trueSource = event.getSource().m_7639_();
        if (entity == null || trueSource == null) {
            return;
        }
        boolean isVillager = entity.m_6095_() == EntityType.f_20492_ || entity.m_6095_() == GuardEntityType.GUARD.get();
        boolean bl = isGolem = isVillager || entity.m_6095_() == EntityType.f_20460_;
        if (isGolem && trueSource.m_6095_() == GuardEntityType.GUARD.get() && !GuardConfig.guardArrowsHurtVillagers) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if (isVillager && event.getSource().m_7639_() instanceof Mob) {
            List list = trueSource.f_19853_.m_45976_(Mob.class, trueSource.m_142469_().m_82377_(GuardConfig.GuardVillagerHelpRange, 5.0, GuardConfig.GuardVillagerHelpRange));
            for (Mob mob : list) {
                boolean trueSourceGolem;
                boolean type = mob.m_6095_() == GuardEntityType.GUARD.get() || mob.m_6095_() == EntityType.f_20460_;
                boolean bl2 = trueSourceGolem = trueSource.m_6095_() == GuardEntityType.GUARD.get() || trueSource.m_6095_() == EntityType.f_20460_;
                if (!type || mob.m_5448_() != null || trueSourceGolem) continue;
                mob.m_6710_((LivingEntity)((Mob)event.getSource().m_7639_()));
            }
        }
    }

    @SubscribeEvent
    public static void onLivingSpawned(EntityJoinWorldEvent event) {
        AbstractVillager villager;
        if (GuardConfig.RaidAnimals && event.getEntity() instanceof Raider && ((Raider)event.getEntity()).m_37886_()) {
            ((Raider)event.getEntity()).f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)((Raider)event.getEntity()), Animal.class, false));
        }
        if (GuardConfig.AttackAllMobs) {
            if (event.getEntity() instanceof Enemy && !GuardConfig.MobBlackList.contains(event.getEntity().m_20078_()) && !(event.getEntity() instanceof Spider)) {
                Mob mob = (Mob)event.getEntity();
                mob.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal(mob, Guard.class, false));
            }
            if (event.getEntity() instanceof Enemy && !GuardConfig.MobBlackList.contains(event.getEntity().m_20078_()) && event.getEntity() instanceof Spider) {
                Spider spider = (Spider)event.getEntity();
                spider.f_21346_.m_25352_(3, new AttackEntityDaytimeGoal<Guard>(spider, Guard.class));
            }
        }
        if (event.getEntity() instanceof AbstractIllager) {
            AbstractIllager illager = (AbstractIllager)event.getEntity();
            illager.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)illager, Guard.class, false));
        }
        if (event.getEntity() instanceof Guard) {
            Guard guard = (Guard)event.getEntity();
            guard.m_21553_(false);
        }
        if (event.getEntity() instanceof AbstractVillager) {
            villager = (AbstractVillager)event.getEntity();
            if (GuardConfig.WitchesVillager) {
                villager.f_21345_.m_25352_(2, (Goal)new AvoidEntityGoal((PathfinderMob)villager, Witch.class, 6.0f, 1.0, 1.2));
            }
        }
        if (event.getEntity() instanceof Villager) {
            villager = (Villager)event.getEntity();
            if (GuardConfig.BlackSmithHealing) {
                villager.f_21345_.m_25352_(1, (Goal)new HealGolemGoal((Mob)villager));
            }
            if (GuardConfig.ClericHealing) {
                villager.f_21345_.m_25352_(1, (Goal)new HealGuardAndPlayerGoal((Mob)villager, 1.0, 100, 0, 10.0f));
            }
        }
        if (event.getEntity() instanceof IronGolem) {
            IronGolem golem = (IronGolem)event.getEntity();
            HurtByTargetGoal tolerateFriendlyFire = new HurtByTargetGoal((PathfinderMob)golem, new Class[]{Guard.class}).m_26044_(new Class[0]);
            golem.f_21346_.f_25345_.stream().map(it -> it.f_25994_).filter(it -> it instanceof HurtByTargetGoal).findFirst().ifPresent(angerGoal -> {
                golem.f_21346_.m_25363_(angerGoal);
                golem.f_21346_.m_25352_(2, (Goal)tolerateFriendlyFire);
            });
        }
        if (event.getEntity() instanceof Zombie) {
            Zombie zombie = (Zombie)event.getEntity();
            zombie.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)zombie, Guard.class, false));
        }
        if (event.getEntity() instanceof Ravager) {
            Ravager ravager = (Ravager)event.getEntity();
            ravager.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)ravager, Guard.class, false));
        }
        if (event.getEntity() instanceof Witch) {
            Witch witch = (Witch)event.getEntity();
            if (GuardConfig.WitchesVillager) {
                witch.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)witch, AbstractVillager.class, true));
                witch.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)witch, IronGolem.class, true));
                witch.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)witch, Guard.class, false));
            }
        }
        if (event.getEntity() instanceof Cat) {
            Cat cat = (Cat)event.getEntity();
            cat.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)cat, AbstractIllager.class, 12.0f, 1.0, 1.2));
        }
    }
}

