/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.client.horse_colors;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.entity.genetics.Genome;
import sekelsta.horse_colors.entity.genetics.IGeneticEntity;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="horse_colors", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class HorseDebug {
    public static boolean showDebug(PlayerEntity player) {
        if (!((Boolean)HorseConfig.Common.horseDebugInfo.get()).booleanValue()) {
            return false;
        }
        return HorseDebug.showBasicDebug(player) || HorseDebug.showGeneDebug(player);
    }

    public static boolean showBasicDebug(PlayerEntity player) {
        ItemStack itemStack = player.func_184592_cb();
        if (itemStack != null && itemStack.func_77973_b() == Items.field_151055_y) {
            return true;
        }
        ItemStack inHand = player.func_184614_ca();
        return inHand != null && inHand.func_77973_b() == Items.field_151055_y;
    }

    public static boolean showGeneDebug(PlayerEntity player) {
        ItemStack itemStack = player.func_184592_cb();
        if (itemStack != null && itemStack.func_77973_b() == Items.field_196180_eI) {
            return true;
        }
        ItemStack inHand = player.func_184614_ca();
        return inHand != null && inHand.func_77973_b() == Items.field_196180_eI;
    }

    public static ArrayList<String> debugGenes(Genome genome) {
        ArrayList<String> list = new ArrayList<String>();
        for (Enum gene : genome.listGenes()) {
            String s = gene.toString() + ": ";
            s = s + genome.getAllele(gene, 0) + ", ";
            s = s + genome.getAllele(gene, 1);
            list.add(s);
        }
        return list;
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void renderOverlayEvent(RenderGameOverlayEvent.Text event) {
        ClientPlayerEntity player = Minecraft.func_71410_x().field_71439_g;
        if (!HorseDebug.showDebug((PlayerEntity)player)) {
            return;
        }
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver != null && mouseOver instanceof EntityRayTraceResult && ((EntityRayTraceResult)mouseOver).func_216348_a() != null && ((EntityRayTraceResult)mouseOver).func_216348_a() instanceof IGeneticEntity) {
            IGeneticEntity entity = (IGeneticEntity)((EntityRayTraceResult)mouseOver).func_216348_a();
            if (HorseDebug.showBasicDebug((PlayerEntity)player) && entity instanceof AgeableEntity) {
                event.getLeft().add("Growing age: " + ((AgeableEntity)entity).func_70874_b());
            }
            if (HorseDebug.showBasicDebug((PlayerEntity)player) && entity instanceof AbstractHorseGenetic) {
                event.getLeft().add("Display age: " + ((AbstractHorseGenetic)entity).getDisplayAge());
                event.getLeft().add("Pregnant since: " + ((AbstractHorseGenetic)entity).getPregnancyStart());
            }
            if (HorseDebug.showBasicDebug((PlayerEntity)player)) {
                event.getLeft().add(entity.getGenome().getTexture());
                event.getLeft().add("Layers:");
                for (String s : entity.getGenome().getTexturePaths().getDebugStrings()) {
                    event.getLeft().add(s);
                }
            }
            if (HorseDebug.showGeneDebug((PlayerEntity)player)) {
                int i;
                ArrayList<String> strings = HorseDebug.debugGenes(entity.getGenome());
                for (i = 0; i < strings.size() / 2; ++i) {
                    event.getRight().add(strings.get(i));
                }
                for (i = strings.size() / 2; i < strings.size(); ++i) {
                    event.getLeft().add(strings.get(i));
                }
            }
        }
    }
}

