/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.breed;

import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import net.minecraft.util.ResourceLocation;
import sekelsta.horse_colors.breed.BreedManager;

public class Breed<T extends Enum<T>> {
    public String name;
    public int population;
    public Map<T, List<Float>> genes;
    public Breed<T> parent = null;
    public static final List<Float> DEFAULT_FREQUENCIES = ImmutableList.of((Object)Float.valueOf(1.0f));

    public Breed() {
    }

    public Breed(Class<T> keyType) {
        this.genes = new EnumMap<T, List<Float>>(keyType);
    }

    public Breed(Breed<T> copy) {
        this.genes = new EnumMap<T, List<Float>>(copy.genes);
        this.parent = copy.parent;
    }

    public boolean contains(T gene) {
        return this.genes.containsKey(gene) || this.parent != null && this.parent.contains(gene);
    }

    public List<Float> get(T gene) {
        if (!this.genes.containsKey(gene)) {
            if (this.parent != null && this.parent.contains(gene)) {
                this.genes.put(gene, this.parent.get(gene));
            } else {
                return DEFAULT_FREQUENCIES;
            }
        }
        return this.genes.get(gene);
    }

    public static Breed load(String name) {
        return BreedManager.getBreed(new ResourceLocation("horse_colors", name));
    }

    public String getMapString() {
        String p = "{";
        boolean first_gene = true;
        for (Enum gene : this.genes.keySet()) {
            if (!first_gene) {
                p = p + ", ";
            }
            first_gene = false;
            p = p + "'" + gene + "': [";
            boolean first_float = true;
            for (float f : this.genes.get(gene)) {
                if (!first_float) {
                    p = p + ", ";
                }
                first_float = false;
                p = p + f;
            }
            p = p + "]";
        }
        p = p + "}";
        return p;
    }

    public String toString() {
        String s = "Breed: " + this.name + "\nPopulation: " + this.population + "\nGenes:\n" + this.getMapString() + "\nParent: ";
        if (this.parent == null) {
            return s + "null\n";
        }
        String p = this.parent.toString();
        return s + "\n" + p.replace("\n", "\n    ");
    }
}

