/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.breed;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.resources.JsonReloadListener;
import net.minecraft.profiler.IProfiler;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.AddReloadListenerEvent;
import sekelsta.horse_colors.HorseColors;
import sekelsta.horse_colors.breed.Breed;
import sekelsta.horse_colors.entity.genetics.EquineGenome;

public class BreedManager
extends JsonReloadListener {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static Map<ResourceLocation, Breed<EquineGenome.Gene>> breeds;
    private static BreedManager instance;

    public BreedManager() {
        super(GSON, "breeds");
    }

    protected void apply(Map<ResourceLocation, JsonElement> mapIn, IResourceManager resourceManagerIn, IProfiler profilerIn) {
        breeds = new HashMap<ResourceLocation, Breed<EquineGenome.Gene>>();
        for (ResourceLocation key : mapIn.keySet()) {
            if (key.func_110623_a().startsWith("_")) continue;
            try {
                JsonObject json = mapIn.get(key).getAsJsonObject();
                Breed<EquineGenome.Gene> b = BreedManager.deserializeBreed(json);
                if (b != null) {
                    breeds.put(key, b);
                }
            }
            catch (IllegalStateException e) {
                HorseColors.logger.error("Could not parse json: " + key);
            }
            catch (ClassCastException e) {
                HorseColors.logger.error("Unexpected data type in json: " + key);
            }
            HorseColors.logger.debug("Loaded " + breeds.size() + " breed data files");
        }
    }

    public static void addReloadListener(AddReloadListenerEvent event) {
        event.addListener((IFutureReloadListener)instance);
    }

    private static Breed<EquineGenome.Gene> deserializeBreed(JsonObject json) throws ClassCastException, IllegalStateException {
        Breed<EquineGenome.Gene> breed = new Breed<EquineGenome.Gene>(EquineGenome.Gene.class);
        if (json.has("genes")) {
            JsonObject genesJson = (JsonObject)json.get("genes");
            for (Map.Entry entry : genesJson.entrySet()) {
                JsonArray jarray = ((JsonElement)entry.getValue()).getAsJsonArray();
                ArrayList<Float> frequencies = new ArrayList<Float>();
                for (int i = 0; i < jarray.size(); ++i) {
                    frequencies.add(Float.valueOf(jarray.get(i).getAsFloat()));
                }
                breed.genes.put(EquineGenome.Gene.valueOf((String)entry.getKey()), (List<Float>)frequencies);
            }
        }
        return breed;
    }

    public static Breed<EquineGenome.Gene> getBreed(ResourceLocation name) {
        return breeds.get(name);
    }

    static {
        instance = new BreedManager();
    }
}

