/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.client;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.HorseInventoryScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.HorseInventoryContainer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import sekelsta.horse_colors.ContainerEventHandler;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;

@OnlyIn(value=Dist.CLIENT)
public class HorseGui
extends HorseInventoryScreen {
    private static final ResourceLocation TEXTURE_LOCATION = new ResourceLocation("horse_colors", "textures/gui/horse.png");
    private final AbstractHorseGenetic horseGenetic;

    public HorseGui(HorseInventoryContainer container, PlayerInventory playerInventory, AbstractHorseGenetic horse) {
        super(container, playerInventory, (AbstractHorseEntity)horse);
        this.horseGenetic = horse;
    }

    protected void func_230450_a_(MatrixStack matrixStack, float partialTicks, int mouseX, int mouseY) {
        AbstractHorseGenetic abstractchestedhorseentity;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_230706_i_.func_110434_K().func_110577_a(TEXTURE_LOCATION);
        int i = (this.field_230708_k_ - this.field_146999_f) / 2;
        int j = (this.field_230709_l_ - this.field_147000_g) / 2;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.horseGenetic instanceof AbstractChestedHorseEntity && (abstractchestedhorseentity = this.horseGenetic).func_190695_dh()) {
            this.func_238474_b_(matrixStack, i + 79, j + 17, 0, this.field_147000_g, abstractchestedhorseentity.func_190696_dl() * 18, 54);
        }
        if (this.horseGenetic.func_230264_L__()) {
            this.func_238474_b_(matrixStack, i + 7, j + 35 - 18, 18, this.field_147000_g + 54, 18, 18);
        }
        if (this.horseGenetic.func_230276_fq_()) {
            this.func_238474_b_(matrixStack, i + 7, j + 35, 0, this.field_147000_g + 54, 18, 18);
        }
        if (HorseConfig.isGenderEnabled()) {
            int iconWidth = 10;
            int iconHeight = 11;
            int textureX = 176;
            int renderX = i + 157;
            int renderY = j + 4;
            if (this.horseGenetic.isMale()) {
                textureX += iconWidth;
            }
            int textureY = 0;
            boolean grayIcons = (Boolean)HorseConfig.Common.useGeneticAnimalsIcons.get();
            if (grayIcons) {
                textureX += 2 * iconWidth;
            }
            if (this.horseGenetic.isPregnant() && !grayIcons) {
                int pregRenderX = (renderX -= 2) + iconWidth + 1;
                this.func_238474_b_(matrixStack, pregRenderX, renderY + 1, 181, 23, 2, 10);
                int pregnantAmount = (int)(11.0f * this.horseGenetic.getPregnancyProgress());
                this.func_238474_b_(matrixStack, pregRenderX, renderY + 11 - pregnantAmount, 177, 33 - pregnantAmount, 2, pregnantAmount);
            }
            this.func_238474_b_(matrixStack, renderX, renderY, textureX, textureY, iconWidth, iconHeight);
            if (this.horseGenetic.isPregnant() && grayIcons) {
                int pregnantAmount = (int)(10.0f * this.horseGenetic.getPregnancyProgress()) + 1;
                this.func_238474_b_(matrixStack, renderX, renderY + 11 - pregnantAmount, textureX, textureY + iconHeight + 11 - pregnantAmount, iconWidth, pregnantAmount);
            }
        }
        InventoryScreen.func_228187_a_((int)(i + 51), (int)(j + 60), (int)17, (float)((float)(i + 51) - (float)mouseX), (float)((float)(j + 75 - 50) - (float)mouseY), (LivingEntity)this.horseGenetic);
    }

    protected void func_230451_b_(MatrixStack matrixStack, int x, int y) {
        super.func_230451_b_(matrixStack, x, y);
        if (!((Boolean)HorseConfig.Common.enableSizes.get()).booleanValue() || this.horseGenetic.func_70631_g_()) {
            return;
        }
        float height = this.horseGenetic.getGenome().getGeneticHeightCm();
        int cm = Math.round(height);
        int inches = Math.round(height / 2.54f);
        int hands = inches / 4;
        int point = inches % 4;
        String translationKey = "horse_colors.gui.height";
        TranslationTextComponent heightText = new TranslationTextComponent(translationKey, new Object[]{hands, point, cm});
        String heightString = heightText.func_212636_a(1000);
        int yy = 20;
        for (String line : heightString.split("\n")) {
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new StringTextComponent(line), 82.0f, (float)yy, 0x404040);
            yy += 9;
        }
        if (this.horseGenetic.getGenome().isMiniature()) {
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("horse_colors.gui.miniature"), 82.0f, (float)yy, 0x404040);
        } else if (this.horseGenetic.getGenome().isLarge()) {
            this.field_230712_o_.func_243248_b(matrixStack, (ITextComponent)new TranslationTextComponent("horse_colors.gui.large"), 82.0f, (float)yy, 0x404040);
        }
    }

    public static void replaceGui(GuiOpenEvent event) {
        if (event.getGui() instanceof HorseInventoryScreen) {
            HorseInventoryScreen screen = (HorseInventoryScreen)event.getGui();
            AbstractHorseEntity horse = null;
            try {
                horse = (AbstractHorseEntity)ObfuscationReflectionHelper.getPrivateValue(HorseInventoryScreen.class, (Object)screen, (String)"field_147034_x");
            }
            catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
                System.err.println("Unable to access private value horseGenetic while replacing the horse GUI.");
                System.err.println((Object)e);
            }
            if (horse instanceof AbstractHorseGenetic) {
                AbstractHorseGenetic horseGenetic = (AbstractHorseGenetic)horse;
                PlayerInventory inventory = null;
                try {
                    inventory = (PlayerInventory)ObfuscationReflectionHelper.getPrivateValue(ContainerScreen.class, (Object)screen, (String)"field_213127_e");
                }
                catch (ObfuscationReflectionHelper.UnableToAccessFieldException e) {
                    System.err.println("Unable to access private value playerInventory while replacing the horse GUI.");
                    System.err.println((Object)e);
                }
                ContainerEventHandler.replaceSaddleSlot(horseGenetic, screen.func_212873_a_());
                event.setGui((Screen)new HorseGui((HorseInventoryContainer)screen.func_212873_a_(), inventory, horseGenetic));
            }
        }
    }
}

