/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.client.renderer;

import java.io.IOException;
import java.util.Locale;
import net.minecraft.client.renderer.texture.NativeImage;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.MinecraftForgeClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import sekelsta.horse_colors.util.Color;

public class TextureLayer {
    protected static final Logger LOGGER = LogManager.getLogger();
    public String name = null;
    public String description = null;
    public Type type = Type.NORMAL;
    public Color color = new Color();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public NativeImage getLayer(IResourceManager manager) {
        if (this.name == null) {
            LOGGER.error("Attempting to load unspecified texture (name is null): " + this.toString());
            return null;
        }
        try (IResource iresource = manager.func_199002_a(new ResourceLocation(this.name));){
            NativeImage image;
            NativeImage nativeImage = image = MinecraftForgeClient.getImageLayer((ResourceLocation)new ResourceLocation(this.name), (IResourceManager)manager);
            return nativeImage;
        }
        catch (IOException ioexception) {
            LOGGER.error("Couldn't load layered image", (Throwable)ioexception);
            LOGGER.error("Skipping layer " + this.toString());
            return null;
        }
    }

    public void combineLayers(NativeImage base, NativeImage image) {
        switch (this.type) {
            case NORMAL: {
                this.blendLayer(base, image);
                break;
            }
            case NO_ALPHA: {
                this.blendLayerKeepAlpha(base, image);
                break;
            }
            case MASK: {
                this.maskLayer(base, image);
                break;
            }
            case SHADE: {
                this.shadeLayer(base, image);
                break;
            }
            case HIGHLIGHT: {
                this.highlightLayer(base, image);
                break;
            }
            case POWER: {
                this.powerLayer(base, image);
                break;
            }
            case ROOT: {
                this.rootLayer(base, image);
            }
        }
    }

    public void blendLayer(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                this.blendPixel(base, j, i, this.multiply(image.func_195709_a(j, i)));
            }
        }
    }

    public void blendLayerKeepAlpha(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int cb = base.func_195709_a(j, i);
                int ci = this.multiply(image.func_195709_a(j, i));
                float a = (float)NativeImage.func_227786_a_((int)ci) / 255.0f;
                float r = NativeImage.func_227791_b_((int)ci);
                float g = NativeImage.func_227793_c_((int)ci);
                float b = NativeImage.func_227795_d_((int)ci);
                float br = NativeImage.func_227791_b_((int)cb);
                float bg = NativeImage.func_227793_c_((int)cb);
                float bb = NativeImage.func_227795_d_((int)cb);
                int fa = NativeImage.func_227786_a_((int)cb);
                int fr = (int)(r * a + br * (1.0f - a));
                int fg = (int)(g * a + bg * (1.0f - a));
                int fb = (int)(b * a + bb * (1.0f - a));
                base.func_195700_a(j, i, NativeImage.func_227787_a_((int)fa, (int)fb, (int)fg, (int)fr));
            }
        }
    }

    public void shadeLayer(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int shading = this.multiply(image.func_195709_a(j, i));
                base.func_195700_a(j, i, this.shade(color, shading));
            }
        }
    }

    public void highlightLayer(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int highlight = this.multiply(image.func_195709_a(j, i));
                base.func_195700_a(j, i, this.highlight(color, highlight));
            }
        }
    }

    public void maskLayer(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int mask = image.func_195709_a(j, i);
                int maskedColor = this.mask(color, mask);
                base.func_195700_a(j, i, maskedColor);
            }
        }
    }

    public void powerLayer(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int exp = image.func_195709_a(j, i);
                exp = this.multiply(exp);
                this.blendPixel(base, j, i, this.power(color, exp));
            }
        }
    }

    public void rootLayer(NativeImage base, NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = base.func_195709_a(j, i);
                int exp = image.func_195709_a(j, i);
                exp = this.multiply(exp);
                this.blendPixel(base, j, i, this.root(color, exp));
            }
        }
    }

    public void colorLayer(NativeImage image) {
        for (int i = 0; i < image.func_195714_b(); ++i) {
            for (int j = 0; j < image.func_195702_a(); ++j) {
                int color = image.func_195709_a(j, i);
                image.func_195700_a(j, i, this.multiply(color));
            }
        }
    }

    public int multiply(int color) {
        int a = NativeImage.func_227786_a_((int)color);
        a = (int)((float)a * this.color.a);
        int r = NativeImage.func_227791_b_((int)color);
        r = (int)((float)r * this.color.r);
        int g = NativeImage.func_227793_c_((int)color);
        g = (int)((float)g * this.color.g);
        int b = NativeImage.func_227795_d_((int)color);
        b = (int)((float)b * this.color.b);
        return NativeImage.func_227787_a_((int)a, (int)b, (int)g, (int)r);
    }

    public int shade(int color, int shading) {
        float cr = NativeImage.func_227791_b_((int)color);
        float cg = NativeImage.func_227793_c_((int)color);
        float cb = NativeImage.func_227795_d_((int)color);
        float sr = NativeImage.func_227791_b_((int)shading);
        float sg = NativeImage.func_227793_c_((int)shading);
        float sb = NativeImage.func_227795_d_((int)shading);
        float a = (float)NativeImage.func_227786_a_((int)shading) / 255.0f;
        float avg = (cr + cg + cb) / 255.0f / 3.0f;
        float na = 1.0f - (a *= 0.5f + 0.5f * (1.0f - avg) * (1.0f - avg));
        float r = Math.max(0.0f, Math.min(255.0f, sr * a + cr * na));
        float g = Math.max(0.0f, Math.min(255.0f, sg * a + cg * na));
        float b = Math.max(0.0f, Math.min(255.0f, sb * a + cb * na));
        int ca = NativeImage.func_227786_a_((int)color);
        return NativeImage.func_227787_a_((int)ca, (int)((int)b), (int)((int)g), (int)((int)r));
    }

    public int highlight(int color, int light) {
        float r0 = NativeImage.func_227791_b_((int)color);
        float g0 = NativeImage.func_227793_c_((int)color);
        float b0 = NativeImage.func_227795_d_((int)color);
        float r1 = NativeImage.func_227791_b_((int)light);
        float g1 = NativeImage.func_227793_c_((int)light);
        float b1 = NativeImage.func_227795_d_((int)light);
        float a = (float)NativeImage.func_227786_a_((int)light) / 255.0f;
        float avg = (r0 + g0 + b0) / 255.0f / 3.0f;
        float na = 1.0f - (a *= 0.5f + 0.5f * avg * avg);
        float r = Math.max(0.0f, Math.min(255.0f, r1 * a + r0 * na));
        float g = Math.max(0.0f, Math.min(255.0f, g1 * a + g0 * na));
        float b = Math.max(0.0f, Math.min(255.0f, b1 * a + b0 * na));
        int ca = NativeImage.func_227786_a_((int)color);
        return NativeImage.func_227787_a_((int)ca, (int)((int)b), (int)((int)g), (int)((int)r));
    }

    public int power(int color, int exp) {
        float r0 = (float)NativeImage.func_227791_b_((int)color) / 255.0f;
        float g0 = (float)NativeImage.func_227793_c_((int)color) / 255.0f;
        float b0 = (float)NativeImage.func_227795_d_((int)color) / 255.0f;
        float r1 = Math.max(0.002f, (float)NativeImage.func_227791_b_((int)exp) / 255.0f);
        float g1 = Math.max(0.002f, (float)NativeImage.func_227793_c_((int)exp) / 255.0f);
        float b1 = Math.max(0.002f, (float)NativeImage.func_227795_d_((int)exp) / 255.0f);
        int r = this.clamp((int)(255.0 * Math.pow(r0, 1.0f / r1)));
        int g = this.clamp((int)(255.0 * Math.pow(g0, 1.0f / g1)));
        int b = this.clamp((int)(255.0 * Math.pow(b0, 1.0f / b1)));
        int a = NativeImage.func_227786_a_((int)exp);
        return NativeImage.func_227787_a_((int)a, (int)b, (int)g, (int)r);
    }

    public int root(int color, int exp) {
        float r0 = (float)NativeImage.func_227791_b_((int)color) / 255.0f;
        float g0 = (float)NativeImage.func_227793_c_((int)color) / 255.0f;
        float b0 = (float)NativeImage.func_227795_d_((int)color) / 255.0f;
        float r1 = (float)NativeImage.func_227791_b_((int)exp) / 255.0f;
        float g1 = (float)NativeImage.func_227793_c_((int)exp) / 255.0f;
        float b1 = (float)NativeImage.func_227795_d_((int)exp) / 255.0f;
        int r = this.clamp((int)(255.0 * Math.pow(r0, r1)));
        int g = this.clamp((int)(255.0 * Math.pow(g0, g1)));
        int b = this.clamp((int)(255.0 * Math.pow(b0, b1)));
        int a = NativeImage.func_227786_a_((int)exp);
        return NativeImage.func_227787_a_((int)a, (int)b, (int)g, (int)r);
    }

    public int mask(int color, int mask) {
        float a = NativeImage.func_227786_a_((int)color) * NativeImage.func_227786_a_((int)mask);
        a /= 255.0f;
        float weight = this.color.a;
        a = a * weight + (float)NativeImage.func_227786_a_((int)color) * (1.0f - weight);
        int r = NativeImage.func_227791_b_((int)color);
        int g = NativeImage.func_227793_c_((int)color);
        int b = NativeImage.func_227795_d_((int)color);
        return NativeImage.func_227787_a_((int)((int)a), (int)b, (int)g, (int)r);
    }

    private int clamp(int x) {
        return Math.max(0, Math.min(x, 255));
    }

    static String getAbv(String s) {
        int i = s.lastIndexOf("/");
        if (i > -1) {
            s = s.substring(i + 1);
        }
        if (s.endsWith(".png")) {
            s = s.substring(0, s.length() - 4);
        }
        return s;
    }

    public String toString() {
        String s = "";
        if (this.name != null) {
            s = s + TextureLayer.getAbv(this.name);
        }
        s = s + "-" + this.type.toString();
        s = s + "-" + this.color.toHexString();
        return s;
    }

    public String getUniqueName() {
        if (this.name == null) {
            return "";
        }
        String s = TextureLayer.getAbv(this.name);
        if (this.type != Type.NORMAL) {
            s = s + "-" + this.type.toString();
        }
        if (this.color.getIntRed() != 255 || this.color.getIntGreen() != 255 || this.color.getIntBlue() != 255 || this.color.getIntAlpha() != 255) {
            s = s + "-" + this.color.toHexString();
        }
        s = s + "_";
        return s.toLowerCase(Locale.ENGLISH);
    }

    public void blendPixel(NativeImage image, int x, int y, int color) {
        int baseColor = image.func_195709_a(x, y);
        float a = (float)NativeImage.func_227786_a_((int)color) / 255.0f;
        float blue = NativeImage.func_227795_d_((int)color);
        float green = NativeImage.func_227793_c_((int)color);
        float red = NativeImage.func_227791_b_((int)color);
        float baseAlpha = (float)NativeImage.func_227786_a_((int)baseColor) / 255.0f;
        float baseBlue = NativeImage.func_227795_d_((int)baseColor);
        float baseGreen = NativeImage.func_227793_c_((int)baseColor);
        float baseRed = NativeImage.func_227791_b_((int)baseColor);
        float alph = a * a + baseAlpha * (1.0f - a);
        int finalAlpha = (int)(alph * 255.0f);
        int finalBlue = (int)(blue * a + baseBlue * (1.0f - a));
        int finalGreen = (int)(green * a + baseGreen * (1.0f - a));
        int finalRed = (int)(red * a + baseRed * (1.0f - a));
        if (finalAlpha > 255) {
            finalAlpha = 255;
        }
        if (finalBlue > 255) {
            finalBlue = 255;
        }
        if (finalGreen > 255) {
            finalGreen = 255;
        }
        if (finalRed > 255) {
            finalRed = 255;
        }
        image.func_195700_a(x, y, NativeImage.func_227787_a_((int)finalAlpha, (int)finalBlue, (int)finalGreen, (int)finalRed));
    }

    public static enum Type {
        NORMAL,
        NO_ALPHA,
        MASK,
        SHADE,
        HIGHLIGHT,
        POWER,
        ROOT;

    }
}

