/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.Blocks;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RunAroundLikeCrazyGoal;
import net.minecraft.entity.item.ExperienceOrbEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractChestedHorseEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.Inventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.GameRules;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.BabyEntitySpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import sekelsta.horse_colors.breed.BaseEquine;
import sekelsta.horse_colors.breed.Breed;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.entity.ModEntities;
import sekelsta.horse_colors.entity.MuleGeneticEntity;
import sekelsta.horse_colors.entity.ai.RandomWalkGroundTie;
import sekelsta.horse_colors.entity.ai.SpookGoal;
import sekelsta.horse_colors.entity.genetics.EquineGenome;
import sekelsta.horse_colors.entity.genetics.IGeneticEntity;
import sekelsta.horse_colors.entity.genetics.Species;
import sekelsta.horse_colors.item.ModItems;

public abstract class AbstractHorseGenetic
extends AbstractChestedHorseEntity
implements IGeneticEntity {
    protected EquineGenome genes = new EquineGenome(this.getSpecies(), this);
    protected static final DataParameter<String> GENES = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187194_d);
    protected static final DataParameter<Integer> HORSE_RANDOM = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> DISPLAY_AGE = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> GENDER = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> PREGNANT_SINCE = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Float> MOTHER_SIZE = EntityDataManager.func_187226_a(AbstractHorseGenetic.class, (IDataSerializer)DataSerializers.field_187193_c);
    protected int trueAge;
    protected static final UUID CSNB_SPEED_UUID = UUID.fromString("84ca527a-5c70-4336-a737-ae3f6d40ef45");
    protected static final UUID CSNB_JUMP_UUID = UUID.fromString("72323326-888b-4e46-bf52-f669600642f7");
    protected static final AttributeModifier CSNB_SPEED_MODIFIER = new AttributeModifier(CSNB_SPEED_UUID, "CSNB speed penalty", -0.6, AttributeModifier.Operation.MULTIPLY_TOTAL);
    protected static final AttributeModifier CSNB_JUMP_MODIFIER = new AttributeModifier(CSNB_JUMP_UUID, "CSNB jump penalty", -0.6, AttributeModifier.Operation.MULTIPLY_TOTAL);
    protected static final int HORSE_GENETICS_VERSION = 2;
    protected List<AbstractHorseGenetic> unbornChildren = new ArrayList<AbstractHorseGenetic>();
    private Field rearingAmountField = ObfuscationReflectionHelper.findField(AbstractHorseEntity.class, (String)"field_110282_bM");

    public AbstractHorseGenetic(EntityType<? extends AbstractHorseGenetic> entityType, World worldIn) {
        super(entityType, worldIn);
        this.setSeed(this.field_70146_Z.nextInt());
        this.setMale(this.field_70146_Z.nextBoolean());
        this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)-1);
        this.getPersistentData().func_74768_a("HorseGeneticsVersion", 2);
    }

    @Override
    public EquineGenome getGenome() {
        return this.genes;
    }

    public abstract boolean fluffyTail();

    public abstract boolean longEars();

    public abstract boolean thinMane();

    public abstract Species getSpecies();

    public boolean canEquipChest() {
        return true;
    }

    @Override
    public int getSeed() {
        return (Integer)this.field_70180_af.func_187225_a(HORSE_RANDOM);
    }

    @Override
    public void setSeed(int seed) {
        this.field_70180_af.func_187227_b(HORSE_RANDOM, (Object)seed);
    }

    @Override
    public Random getRand() {
        return super.func_70681_au();
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.2));
        this.field_70714_bg.func_75776_a(1, (Goal)new RunAroundLikeCrazyGoal((AbstractHorseEntity)this, 1.2));
        if (((Boolean)HorseConfig.Common.spookyHorses.get()).booleanValue()) {
            this.field_70714_bg.func_75776_a(1, new SpookGoal<MonsterEntity>((AbstractHorseEntity)this, MonsterEntity.class, 8.0f, 1.5, 1.5));
        }
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0, AbstractHorseEntity.class));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (Goal)new RandomWalkGroundTie((CreatureEntity)this, 0.7));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.func_205714_dM();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(GENES, (Object)"");
        this.field_70180_af.func_187214_a(HORSE_RANDOM, (Object)0);
        this.field_70180_af.func_187214_a(DISPLAY_AGE, (Object)0);
        this.field_70180_af.func_187214_a(GENDER, (Object)false);
        this.field_70180_af.func_187214_a(PREGNANT_SINCE, (Object)-1);
        this.field_70180_af.func_187214_a(MOTHER_SIZE, (Object)Float.valueOf(1.0f));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74778_a("Genes", this.getGeneData());
        compound.func_74768_a("Random", this.getSeed());
        compound.func_74768_a("true_age", this.trueAge);
        compound.func_74757_a("gender", this.isMale());
        compound.func_74768_a("pregnant_since", this.getPregnancyStart());
        if (this.unbornChildren != null) {
            ListNBT unbornChildrenTag = new ListNBT();
            for (AbstractHorseGenetic child : this.unbornChildren) {
                CompoundNBT childNBT = new CompoundNBT();
                childNBT.func_74778_a("species", child.getSpecies().toString());
                childNBT.func_74778_a("genes", child.getGenome().genesToString());
                unbornChildrenTag.add((Object)childNBT);
            }
            compound.func_218657_a("unborn_children", (INBT)unbornChildrenTag);
        }
        compound.func_74776_a("mother_size", this.getMotherSize());
        this.writeLegacyAdditional(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        int spawndata;
        INBT nbt;
        ItemStack itemstack;
        super.func_70037_a(compound);
        if (compound.func_74764_b("Genes")) {
            this.setGeneData(compound.func_74779_i("Genes"));
        } else if (compound.func_74764_b("Breed")) {
            this.randomize(this.getBreed(compound.func_74779_i("Breed")));
        } else {
            if (!(compound.func_74764_b("Variant") || compound.func_74764_b("Variant2") || compound.func_74764_b("Variant3") || compound.func_74764_b("Variant4"))) {
                this.randomize(this.getRandomBreed());
            }
            this.readLegacyAdditional(compound);
        }
        if (compound.func_150297_b("SaddleItem", 10) && this.isSaddle(itemstack = ItemStack.func_199557_a((CompoundNBT)compound.func_74775_l("SaddleItem")))) {
            this.field_110296_bG.func_70299_a(0, itemstack);
        }
        this.setSeed(compound.func_74762_e("Random"));
        this.trueAge = compound.func_74762_e("true_age");
        if (compound.func_74764_b("gender")) {
            this.setMale(compound.func_74767_n("gender"));
        } else {
            this.setMale(this.field_70146_Z.nextBoolean());
        }
        int pregnantSince = -1;
        if (compound.func_74764_b("pregnant_since")) {
            pregnantSince = compound.func_74762_e("pregnant_since");
        }
        this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)pregnantSince);
        if (compound.func_74764_b("unborn_children") && (nbt = compound.func_74781_a("unborn_children")) instanceof ListNBT) {
            ListNBT childListTag = (ListNBT)nbt;
            for (int i = 0; i < childListTag.size(); ++i) {
                INBT cnbt = childListTag.get(i);
                if (!(cnbt instanceof CompoundNBT)) continue;
                CompoundNBT childNBT = (CompoundNBT)cnbt;
                Species species = Species.valueOf(childNBT.func_74779_i("species"));
                AbstractHorseGenetic child = null;
                switch (species) {
                    case HORSE: {
                        child = (AbstractHorseGenetic)ModEntities.HORSE_GENETIC.func_200721_a(this.field_70170_p);
                        break;
                    }
                    case DONKEY: {
                        child = (AbstractHorseGenetic)ModEntities.DONKEY_GENETIC.func_200721_a(this.field_70170_p);
                        break;
                    }
                    case MULE: 
                    case HINNY: {
                        child = (AbstractHorseGenetic)ModEntities.MULE_GENETIC.func_200721_a(this.field_70170_p);
                        ((MuleGeneticEntity)child).setSpecies(species);
                    }
                }
                if (child == null) continue;
                EquineGenome genome = new EquineGenome(child.getSpecies(), child);
                genome.genesFromString(childNBT.func_74779_i("genes"));
                this.unbornChildren.add(child);
            }
        }
        float motherSize = 1.0f;
        if (compound.func_74764_b("mother_size")) {
            motherSize = compound.func_74760_g("mother_size");
        }
        this.setMotherSize(motherSize);
        if (this.trueAge < 0 != this.field_175504_a < 0) {
            this.trueAge = this.field_175504_a;
        }
        this.readExtraGenes(compound);
        this.useGeneticAttributes();
        this.func_230275_fc_();
        if (this instanceof HorseGeneticEntity && (spawndata = compound.func_74762_e("VillageSpawn")) != 0) {
            this.initFromVillageSpawn();
        }
        this.getPersistentData().func_74768_a("HorseGeneticsVersion", 2);
    }

    private void readExtraGenes(CompoundNBT compound) {
        for (Enum gene : this.getGenome().listGenes()) {
            if (!compound.func_74764_b(gene.toString())) continue;
            int[] alleles = compound.func_74759_k(gene.toString());
            this.getGenome().setAllele(gene, 0, alleles[0]);
            this.getGenome().setAllele(gene, 1, alleles[1]);
        }
    }

    public void readLegacyAdditional(CompoundNBT compound) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        if (compound.func_74764_b("Variant")) {
            map.put("0", compound.func_74762_e("Variant"));
        }
        if (compound.func_74764_b("Variant2")) {
            map.put("1", compound.func_74762_e("Variant2"));
        }
        if (compound.func_74764_b("Variant3")) {
            map.put("2", compound.func_74762_e("Variant3"));
        }
        if (compound.func_74764_b("Variant4")) {
            map.put("3", compound.func_74762_e("Variant4"));
        }
        if (compound.func_74764_b("Variant5")) {
            map.put("4", compound.func_74762_e("Variant5"));
        } else if (!this.getPersistentData().func_74764_b("HorseGeneticsVersion")) {
            this.getPersistentData().func_74768_a("HorseGeneticsVersion", 2);
            this.getGenome().datafixAddingFourthChromosome(map);
        }
        if (compound.func_74764_b("SpeedGenes")) {
            map.put("speed", compound.func_74762_e("SpeedGenes"));
        }
        if (compound.func_74764_b("JumpGenes")) {
            map.put("jump", compound.func_74762_e("JumpGenes"));
        }
        if (compound.func_74764_b("HealthGenes")) {
            map.put("health", compound.func_74762_e("HealthGenes"));
        }
        if (compound.func_74764_b("MHC1")) {
            map.put("mhc1", compound.func_74762_e("MHC1"));
            map.put("mhc2", compound.func_74762_e("MHC2"));
        }
        if (compound.func_74764_b("Immune")) {
            map.put("immune", compound.func_74762_e("Immune"));
        }
        this.genes.setLegacyGenes(map);
    }

    public void writeLegacyAdditional(CompoundNBT compound) {
        Map<String, Integer> map = this.getGenome().getLegacyGenes();
        compound.func_74768_a("Variant", map.get("0").intValue());
        compound.func_74768_a("Variant2", map.get("1").intValue());
        compound.func_74768_a("Variant3", map.get("2").intValue());
        compound.func_74768_a("Variant4", map.get("3").intValue());
        compound.func_74768_a("Variant5", map.get("4").intValue());
        compound.func_74768_a("SpeedGenes", map.get("speed").intValue());
        compound.func_74768_a("JumpGenes", map.get("jump").intValue());
        compound.func_74768_a("HealthGenes", map.get("health").intValue());
        compound.func_74768_a("MHC1", map.get("mhc1").intValue());
        compound.func_74768_a("MHC2", map.get("mhc2").intValue());
        compound.func_74768_a("Immune", map.get("immune").intValue());
    }

    public void copyAbstractHorse(AbstractHorseEntity horse) {
        CompoundNBT vanilla = horse.func_189511_e(new CompoundNBT());
        if (vanilla.func_74764_b("Variant")) {
            vanilla.func_82580_o("Variant");
        }
        this.func_70020_e(vanilla);
        this.useGeneticAttributes();
    }

    public int getDisplayAge() {
        return (Integer)this.field_70180_af.func_187225_a(DISPLAY_AGE);
    }

    public void setDisplayAge(int age) {
        this.field_70180_af.func_187227_b(DISPLAY_AGE, (Object)age);
    }

    @Override
    public int getTrueAge() {
        if (this.func_70631_g_() && this.getDisplayAge() >= 0) {
            return this.getBirthAge();
        }
        return this.getDisplayAge();
    }

    @Override
    public void setGeneData(String genes) {
        this.field_70180_af.func_187227_b(GENES, (Object)genes);
    }

    @Override
    public String getGeneData() {
        return (String)this.field_70180_af.func_187225_a(GENES);
    }

    @Override
    public void setMotherSize(float size) {
        this.field_70180_af.func_187227_b(MOTHER_SIZE, (Object)Float.valueOf(size));
    }

    @Override
    public float getMotherSize() {
        return ((Float)this.field_70180_af.func_187225_a(MOTHER_SIZE)).floatValue();
    }

    public void func_184206_a(DataParameter<?> key) {
        if (GENES.equals(key)) {
            this.getGenome().resetTexture();
            this.useGeneticAttributes();
            this.func_213323_x_();
        } else if (HORSE_RANDOM.equals(key) || GENDER.equals(key) || MOTHER_SIZE.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    @Override
    public boolean isMale() {
        return (Boolean)this.field_70180_af.func_187225_a(GENDER);
    }

    @Override
    public void setMale(boolean gender) {
        if (gender) {
            this.unbornChildren = new ArrayList<AbstractHorseGenetic>();
            this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)-1);
        }
        this.field_70180_af.func_187227_b(GENDER, (Object)gender);
    }

    public boolean isPregnant() {
        return this.getPregnancyStart() >= 0;
    }

    public int getPregnancyStart() {
        return (Integer)this.field_70180_af.func_187225_a(PREGNANT_SINCE);
    }

    public float getPregnancyProgress() {
        int passed = this.getDisplayAge() - this.getPregnancyStart();
        int total = HorseConfig.getHorsePregnancyLength();
        return (float)passed / (float)total;
    }

    @Override
    public int getRebreedTicks() {
        return HorseConfig.getHorseRebreedTicks(this.isMale());
    }

    @Override
    public int getBirthAge() {
        return HorseConfig.getHorseBirthAge();
    }

    public boolean func_110248_bS() {
        return this.getGenome().isMiniature() || super.func_110248_bS();
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        if (damageSourceIn != DamageSource.field_76368_d && damageSourceIn != DamageSource.field_76367_g) {
            super.func_184601_bQ(damageSourceIn);
        }
        return null;
    }

    public void func_82227_f(boolean isBaby) {
        this.func_70873_a(isBaby ? this.getBirthAge() : 0);
    }

    private double getRiderWeight(Entity rider) {
        double weight = rider.func_174813_aQ().func_216364_b() * rider.func_174813_aQ().func_216360_c() * rider.func_174813_aQ().func_216362_d();
        if (rider instanceof AnimalEntity) {
            weight *= 2.0;
        }
        if (rider instanceof AgeableEntity && ((AgeableEntity)rider).func_70631_g_()) {
            weight *= 2.0;
        }
        return weight;
    }

    protected boolean func_184219_q(Entity passenger) {
        if (!passenger.func_200600_R().func_220339_d().func_75599_d()) {
            return false;
        }
        if (!((Boolean)HorseConfig.Common.enableSizes.get()).booleanValue()) {
            return super.func_184219_q(passenger);
        }
        if (this.func_184188_bt().size() >= 2) {
            return false;
        }
        double riderweight = 0.0;
        for (Entity rider : this.func_184188_bt()) {
            riderweight += this.getRiderWeight(rider);
        }
        double weight = this.getRiderWeight(passenger);
        return riderweight + weight < 0.648001 * (double)this.getGenome().getGeneticWeightKg() / 317.5;
    }

    public Inventory getHorseChest() {
        return this.field_110296_bG;
    }

    private boolean itemInteract(PlayerEntity player, ItemStack itemstack, Hand hand) {
        block20: {
            block21: {
                if (itemstack.func_77973_b() != Items.field_151122_aG) break block20;
                if (((Boolean)HorseConfig.Genetics.bookShowsGenes.get()).booleanValue()) break block21;
                if (!((Boolean)HorseConfig.Genetics.bookShowsTraits.get()).booleanValue()) break block20;
            }
            if (this.func_110248_bS() || player.field_71075_bZ.field_75098_d) {
                ItemStack book = new ItemStack((IItemProvider)ModItems.geneBookItem);
                if (book.func_77978_p() == null) {
                    book.func_77982_d(new CompoundNBT());
                }
                book.func_77978_p().func_74778_a("species", this.getSpecies().name());
                book.func_77978_p().func_74778_a("genes", this.getGenome().genesToString());
                book.func_77978_p().func_186854_a("EntityUUID", this.func_110124_au());
                if (this.func_145818_k_()) {
                    book.func_200302_a(this.func_200201_e());
                }
                if (!player.func_191521_c(book)) {
                    this.func_199701_a_(book);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                return true;
            }
        }
        if (!this.func_110248_bS()) {
            this.func_190687_dF();
            return true;
        }
        if (!this.func_190695_dh() && itemstack.func_77973_b() == Blocks.field_150486_ae.func_199767_j() && this.canEquipChest()) {
            this.func_110207_m(true);
            this.func_190697_dk();
            if (!player.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            this.func_110226_cD();
            return true;
        }
        if (!this.func_110257_ck() && this.isSaddle(itemstack) && this.func_230264_L__()) {
            if (((Boolean)HorseConfig.Common.autoEquipSaddle.get()).booleanValue()) {
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack saddle = itemstack.func_77979_a(1);
                    this.field_110296_bG.func_70299_a(0, saddle);
                }
            } else {
                this.func_110199_f(player);
            }
            return true;
        }
        if (this.func_190682_f(itemstack) && this.func_230276_fq_()) {
            if (((Boolean)HorseConfig.Common.autoEquipSaddle.get()).booleanValue() && this.field_110296_bG.func_70301_a(1).func_190926_b()) {
                if (!this.field_70170_p.field_72995_K) {
                    ItemStack armor = itemstack.func_77979_a(1);
                    this.field_110296_bG.func_70299_a(1, armor);
                }
            } else {
                this.func_110199_f(player);
            }
            return true;
        }
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (!this.func_70631_g_() && this.func_110248_bS() && player.func_226563_dT_()) {
            this.func_110199_f(player);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        if (!itemstack.func_190926_b() && !this.func_184207_aI()) {
            if (this.func_70877_b(itemstack)) {
                return this.func_241395_b_(player, itemstack);
            }
            ActionResultType actionresulttype = itemstack.func_111282_a_(player, (LivingEntity)this, hand);
            if (actionresulttype.func_226246_a_()) {
                return actionresulttype;
            }
            if (this.itemInteract(player, itemstack, hand)) {
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
            }
        }
        if (!this.func_70631_g_() && this.func_184219_q((Entity)player)) {
            this.func_110237_h(player);
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        return super.func_230254_b_(player, hand);
    }

    protected void useGeneticAttributes() {
        if (((Boolean)HorseConfig.Genetics.useGeneticStats.get()).booleanValue()) {
            EquineGenome genes = this.getGenome();
            float maxHealth = this.getGenome().getHealth();
            float athletics = (float)genes.sumGenes(EquineGenome.Gene.class, "athletics", 0, 4) / 2.0f + (float)genes.sumGenes(EquineGenome.Gene.class, "athletics", 4, 8) / 2.0f;
            float speedStat = (float)(genes.sumGenes(EquineGenome.Gene.class, "speed", 0, 4) + genes.sumGenes(EquineGenome.Gene.class, "speed", 4, 8) + genes.sumGenes(EquineGenome.Gene.class, "speed", 8, 12)) + athletics;
            double movementSpeed = 0.1125 + (double)speedStat * 0.00703125;
            float jumpStat = (float)(genes.sumGenes(EquineGenome.Gene.class, "jump", 0, 4) + genes.sumGenes(EquineGenome.Gene.class, "jump", 4, 8) + genes.sumGenes(EquineGenome.Gene.class, "jump", 8, 12)) + athletics;
            double jumpStrength = 0.4 + (double)jumpStat * 0.01875;
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)maxHealth);
            this.func_110148_a(Attributes.field_233821_d_).func_111128_a(movementSpeed);
            this.func_110148_a(Attributes.field_233830_m_).func_111128_a(jumpStrength);
        }
    }

    public void func_234177_a_(ServerWorld world, AnimalEntity mate) {
        if (!(mate instanceof IGeneticEntity)) {
            super.func_234177_a_(world, mate);
            return;
        }
        if (!this.func_70880_s() || !mate.func_70880_s()) {
            return;
        }
        IGeneticEntity geneticMate = (IGeneticEntity)mate;
        if (this.isMale() && !geneticMate.isMale()) {
            mate.func_234177_a_(world, (AnimalEntity)this);
            return;
        }
        ServerPlayerEntity serverplayerentity = this.func_191993_do();
        if (serverplayerentity == null && mate.func_191993_do() != null) {
            serverplayerentity = mate.func_191993_do();
        }
        int numFoals = this.getRandomLitterSize();
        ArrayList<Object> foals = new ArrayList<Object>();
        for (int i = 0; i < numFoals; ++i) {
            Object ageableentity = this.func_241840_a(world, (AgeableEntity)mate);
            if (ageableentity == null) continue;
            BabyEntitySpawnEvent babyEntitySpawnEvent = new BabyEntitySpawnEvent((MobEntity)this, (MobEntity)mate, (AgeableEntity)ageableentity);
            boolean cancelled = MinecraftForge.EVENT_BUS.post((Event)babyEntitySpawnEvent);
            ageableentity = babyEntitySpawnEvent.getChild();
            if (cancelled || ageableentity == null) continue;
            if (HorseConfig.isPregnancyEnabled()) {
                if (this.setPregnantWith((AgeableEntity)ageableentity, (AgeableEntity)mate)) {
                    ageableentity = null;
                }
            } else {
                this.spawnChild((AgeableEntity)ageableentity, world);
            }
            foals.add(ageableentity);
            if (serverplayerentity == null) continue;
            serverplayerentity.func_195066_a(Stats.field_151186_x);
            CriteriaTriggers.field_192134_n.func_192168_a(serverplayerentity, (AnimalEntity)this, mate, (AgeableEntity)ageableentity);
        }
        this.func_70873_a(this.getRebreedTicks());
        mate.func_70873_a(geneticMate.getRebreedTicks());
        this.func_70875_t();
        mate.func_70875_t();
        if (foals.size() <= 0) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            return;
        }
        float multiplier = (float)Math.pow(1.0 / (double)foals.size(), 0.3333333333333333);
        for (AgeableEntity ageableEntity : foals) {
            if (!(ageableEntity instanceof IGeneticEntity)) continue;
            IGeneticEntity gFoal = (IGeneticEntity)ageableEntity;
            gFoal.setMotherSize(gFoal.getMotherSize() * multiplier);
        }
        if (HorseConfig.isPregnancyEnabled()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
        if (world.func_82736_K().func_223586_b(GameRules.field_223602_e)) {
            int xp = this.func_70681_au().nextInt(7) + 1;
            world.func_217376_c((Entity)new ExperienceOrbEntity((World)world, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), xp));
        }
    }

    private void spawnChild(AgeableEntity child, ServerWorld world) {
        child.func_82227_f(true);
        child.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 0.0f, 0.0f);
        world.func_217376_c((Entity)child);
        world.func_72960_a((Entity)this, (byte)18);
    }

    abstract AbstractHorseEntity getChild(ServerWorld var1, AgeableEntity var2);

    protected int getRandomLitterSize() {
        double chance = 0.0;
        if (this.getGenome().countAlleles(EquineGenome.Gene.double_ovulation, 1) == 1) {
            chance = 0.0;
        } else if (this.getGenome().isHomozygous(EquineGenome.Gene.double_ovulation, 1)) {
            chance = 0.0;
        }
        int litterSize = 1;
        if (this.func_70681_au().nextDouble() < chance) {
            ++litterSize;
        }
        if (this.func_70681_au().nextDouble() < chance) {
            ++litterSize;
        }
        return litterSize;
    }

    public boolean isOppositeGender(AbstractHorseGenetic other) {
        if (!HorseConfig.isGenderEnabled()) {
            return true;
        }
        return this.isMale() != other.isMale();
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity ageable) {
        if (!(ageable instanceof AnimalEntity)) {
            return null;
        }
        AnimalEntity otherAnimal = (AnimalEntity)ageable;
        if (this.isMale() && ageable instanceof AbstractHorseGenetic && !((AbstractHorseGenetic)ageable).isMale()) {
            return ageable.func_241840_a(world, (AgeableEntity)this);
        }
        AbstractHorseEntity child = this.getChild(world, ageable);
        if (child != null) {
            this.func_190681_a(ageable, child);
        }
        if (child instanceof AbstractHorseGenetic) {
            AbstractHorseGenetic foal = (AbstractHorseGenetic)child;
            if (ageable instanceof AbstractHorseGenetic) {
                AbstractHorseGenetic other = (AbstractHorseGenetic)ageable;
                foal.getGenome().inheritGenes(this.getGenome(), other.getGenome());
            }
            if (foal.getGenome().isEmbryonicLethal()) {
                return null;
            }
            foal.setMotherSize(this.getGenome().getAdultScale());
            foal.setMale(this.field_70146_Z.nextBoolean());
            foal.useGeneticAttributes();
            foal.func_70873_a(HorseConfig.GROWTH.getMinAge());
        }
        return child;
    }

    @Override
    public boolean setPregnantWith(AgeableEntity child, AgeableEntity otherParent) {
        if (otherParent instanceof IGeneticEntity) {
            IGeneticEntity otherGenetic = (IGeneticEntity)otherParent;
            if (this.isMale() == otherGenetic.isMale()) {
                return false;
            }
            if (this.isMale() && !otherGenetic.isMale()) {
                return otherGenetic.setPregnantWith(child, (AgeableEntity)this);
            }
        }
        if (this.isMale()) {
            return false;
        }
        if (child instanceof AbstractHorseGenetic) {
            this.unbornChildren.add((AbstractHorseGenetic)child);
            if (!this.field_70170_p.field_72995_K) {
                this.trueAge = Math.max(0, this.trueAge);
                this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)this.trueAge);
            }
            return true;
        }
        return false;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (!this.field_70170_p.field_72995_K) {
            this.trueAge = this.field_175504_a < 0 ? this.field_175504_a : Math.max(0, this.trueAge + 1);
            int c = 400;
            if (this.trueAge / 400 != this.getDisplayAge() / 400 || this.trueAge < 0 != this.getDisplayAge() < 0) {
                this.setDisplayAge(this.trueAge);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.isPregnant()) {
            if (this.unbornChildren == null || this.unbornChildren.size() == 0) {
                this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)-1);
            }
            int totalLength = HorseConfig.getHorsePregnancyLength();
            int currentLength = this.trueAge - this.getPregnancyStart();
            if (currentLength >= totalLength) {
                for (AbstractHorseGenetic child : this.unbornChildren) {
                    if (!(this.field_70170_p instanceof ServerWorld)) continue;
                    this.spawnChild((AgeableEntity)child, (ServerWorld)this.field_70170_p);
                }
                this.unbornChildren = new ArrayList<AbstractHorseGenetic>();
                this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)-1);
            }
        }
        if (this.getGenome().isLethalWhite() && this.field_70173_aa > 80 && !this.func_70644_a(Effects.field_82731_v)) {
            this.func_195064_c(new EffectInstance(Effects.field_82731_v, 100, 3));
        }
    }

    public void func_70636_d() {
        if (this.unbornChildren != null && this.unbornChildren.size() > 0 && this.getPregnancyStart() < 0) {
            this.field_70180_af.func_187227_b(PREGNANT_SINCE, (Object)0);
        }
        if (this.getGenome().isHomozygous(EquineGenome.Gene.leopard, 1) && !this.field_70170_p.func_201670_d()) {
            ModifiableAttributeInstance speedAttribute = this.func_110148_a(Attributes.field_233821_d_);
            ModifiableAttributeInstance jumpAttribute = this.func_110148_a(Attributes.field_233830_m_);
            float brightness = this.func_70013_c();
            if (brightness > 0.5f) {
                if (speedAttribute.func_111127_a(CSNB_SPEED_UUID) != null) {
                    speedAttribute.func_111124_b(CSNB_SPEED_MODIFIER);
                }
                if (jumpAttribute.func_111127_a(CSNB_JUMP_UUID) != null) {
                    jumpAttribute.func_111124_b(CSNB_JUMP_MODIFIER);
                }
            } else {
                if (speedAttribute.func_111127_a(CSNB_SPEED_UUID) == null) {
                    speedAttribute.func_233767_b_(CSNB_SPEED_MODIFIER);
                }
                if (jumpAttribute.func_111127_a(CSNB_JUMP_UUID) == null) {
                    jumpAttribute.func_233767_b_(CSNB_JUMP_MODIFIER);
                }
            }
        }
        super.func_70636_d();
    }

    public double func_70042_X() {
        return (double)this.func_213302_cg() * 0.833 - 0.295;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity && !(this.func_184179_bs() instanceof AnimalEntity) && (this.func_184179_bs() instanceof PlayerEntity || !this.func_110167_bD());
    }

    public void func_184232_k(Entity passenger) {
        if (!this.func_184196_w(passenger)) {
            return;
        }
        float xzOffset = -0.1f;
        if (this.func_184188_bt().size() > 1) {
            int i = this.func_184188_bt().indexOf(passenger);
            xzOffset = i == 0 ? 0.1f : -0.5f;
        }
        xzOffset *= this.getGenome().getAdultScale();
        double yOffset = this.func_70042_X() + passenger.func_70033_W();
        if (passenger instanceof PlayerEntity && this.func_110257_ck()) {
            yOffset += 0.04 * (double)this.getGenome().getAdultScale();
        }
        float standAnim0 = 0.0f;
        try {
            standAnim0 = ((Float)this.rearingAmountField.get(this)).floatValue();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (standAnim0 > 0.0f) {
            float xLoc = this.func_213311_cf() + xzOffset;
            float facingX = MathHelper.func_76126_a((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float facingZ = MathHelper.func_76134_b((float)(this.field_70761_aq * ((float)Math.PI / 180)));
            float rearAngle = standAnim0 * (float)Math.PI / 4.0f;
            float rearXZ = -1.0f * (1.0f - MathHelper.func_76134_b((float)rearAngle)) * xLoc;
            float rearY = MathHelper.func_76126_a((float)rearAngle) * xLoc / 2.0f;
            xzOffset += rearXZ;
            yOffset += (double)rearY;
            if (passenger instanceof LivingEntity) {
                ((LivingEntity)passenger).field_70761_aq = this.field_70761_aq;
            }
        }
        Vector3d vector3d = new Vector3d((double)xzOffset, 0.0, 0.0);
        vector3d = vector3d.func_178785_b(-this.field_70761_aq * ((float)Math.PI / 180) - 1.5707964f);
        passenger.func_70107_b(this.func_226277_ct_() + vector3d.field_72450_a, this.func_226278_cu_() + yOffset, this.func_226281_cx_() + vector3d.field_72449_c);
        this.applyYaw(passenger);
        if (passenger instanceof AnimalEntity && this.func_184188_bt().size() > 1) {
            int degrees = passenger.func_145782_y() % 2 == 0 ? 90 : 270;
            passenger.func_181013_g(((AnimalEntity)passenger).field_70761_aq + (float)degrees);
            passenger.func_70034_d(passenger.func_70079_am() + (float)degrees);
        }
    }

    private void applyYaw(Entity entity) {
        if (!(entity instanceof PlayerEntity)) {
            entity.func_181013_g(this.field_70761_aq);
            entity.field_70177_z = this.field_70761_aq;
            entity.func_70034_d(this.field_70761_aq);
        }
    }

    protected ITextComponent func_225513_by_() {
        String species = this.getSpecies().toString().toLowerCase();
        String s = "entity.horse_colors." + species + ".";
        if (this.func_70631_g_()) {
            if (!((Boolean)HorseConfig.Breeding.enableGenders.get()).booleanValue()) {
                return new TranslationTextComponent(s + "foal");
            }
            if (this.isMale()) {
                return new TranslationTextComponent(s + "colt");
            }
            return new TranslationTextComponent(s + "filly");
        }
        if (!((Boolean)HorseConfig.Breeding.enableGenders.get()).booleanValue()) {
            return super.func_225513_by_();
        }
        if (this.isMale()) {
            return new TranslationTextComponent(s + "male");
        }
        return new TranslationTextComponent(s + "female");
    }

    public boolean isSaddle(ItemStack stack) {
        if (stack.func_77973_b() == Items.field_151141_av) {
            return true;
        }
        ResourceLocation registryName = stack.func_77973_b().getRegistryName();
        return registryName.func_110624_b().equals("eanimod") && registryName.func_110623_a().contains("saddle");
    }

    public boolean func_174820_d(int slot, ItemStack stack) {
        if (super.func_174820_d(slot, stack)) {
            return true;
        }
        int num = slot - 400;
        if (num == 0 && this.isSaddle(stack)) {
            this.field_110296_bG.func_70299_a(num, stack);
        }
        return false;
    }

    @Override
    public Breed getDefaultBreed() {
        return BaseEquine.breed;
    }

    protected void func_230273_eI_() {
        if (!((Boolean)HorseConfig.Genetics.useGeneticStats.get()).booleanValue()) {
            float maxHealth = this.func_110267_cL() + this.getGenome().getBaseHealth();
            this.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)maxHealth);
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Breed breed;
        if (!(spawnDataIn instanceof GeneticData)) {
            breed = this.getRandomBreed();
            spawnDataIn = new GeneticData(breed);
        }
        breed = ((GeneticData)((Object)spawnDataIn)).breed;
        this.randomize(breed);
        ILivingEntityData data = super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.useGeneticAttributes();
        return data;
    }

    private void randomize(Breed breed) {
        this.getGenome().randomize(breed);
        this.trueAge = this.field_70146_Z.nextInt(HorseConfig.GROWTH.getMaxAge());
        if (this.field_70146_Z.nextInt(5) == 0) {
            this.trueAge = this.getBirthAge() + this.field_70146_Z.nextInt(-this.getBirthAge() / 2);
        }
        this.setMale(this.field_70146_Z.nextBoolean());
        this.func_70873_a(Math.min(0, this.trueAge));
        this.useGeneticAttributes();
        this.setMotherSize(this.getGenome().getGeneticScale());
        this.setMotherSize(this.getGenome().getGeneticScale());
    }

    public void initFromVillageSpawn() {
        this.randomize(this.getRandomBreed());
        this.func_110198_t(this.func_190676_dC() / 2);
        if (!this.func_70631_g_() && this.field_70146_Z.nextInt(16) == 0) {
            this.func_110234_j(true);
            ItemStack saddle = new ItemStack((IItemProvider)Items.field_151141_av);
            this.field_110296_bG.func_70299_a(0, saddle);
        }
    }

    public float getProportionalAgeScale() {
        return this.getGenome().getCurrentScale() / this.getGangliness();
    }

    public float getGangliness() {
        return 0.5f + 0.5f * this.getFractionGrown() * this.getFractionGrown();
    }

    public float func_213355_cm() {
        float base = this.func_70631_g_() ? 0.6f : 1.0f;
        return this.getGenome().getAdultScale() * base;
    }

    public boolean func_230264_L__() {
        return ((Boolean)HorseConfig.Common.enableSizes.get() == false || !this.getGenome().isMiniature()) && super.func_230264_L__();
    }

    public boolean func_70104_M() {
        return !this.func_184207_aI() || !(this.func_184179_bs() instanceof PlayerEntity);
    }

    public static class GeneticData
    extends AgeableEntity.AgeableData {
        public final Breed breed;

        public GeneticData(Breed breed) {
            super(true);
            this.breed = breed;
        }
    }
}

