/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity;

import com.google.common.collect.ImmutableList;
import java.util.List;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.passive.horse.DonkeyEntity;
import net.minecraft.entity.passive.horse.HorseEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import sekelsta.horse_colors.breed.Breed;
import sekelsta.horse_colors.breed.donkey.DefaultDonkey;
import sekelsta.horse_colors.breed.donkey.MammothDonkey;
import sekelsta.horse_colors.breed.donkey.MiniatureDonkey;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.AbstractHorseGenetic;
import sekelsta.horse_colors.entity.HorseGeneticEntity;
import sekelsta.horse_colors.entity.ModEntities;
import sekelsta.horse_colors.entity.MuleGeneticEntity;
import sekelsta.horse_colors.entity.genetics.Species;
import sekelsta.horse_colors.util.Util;

public class DonkeyGeneticEntity
extends AbstractHorseGenetic {
    public static List<Breed> breeds = ImmutableList.of((Object)MiniatureDonkey.breed, (Object)MammothDonkey.breed);
    private static final ResourceLocation LOOT_TABLE = new ResourceLocation("minecraft", "entities/donkey");

    public DonkeyGeneticEntity(EntityType<? extends DonkeyGeneticEntity> entityType, World world) {
        super(entityType, world);
    }

    public ResourceLocation func_184647_J() {
        return LOOT_TABLE;
    }

    protected SoundEvent func_184639_G() {
        super.func_184639_G();
        return SoundEvents.field_187580_av;
    }

    protected SoundEvent func_184615_bR() {
        super.func_184615_bR();
        return SoundEvents.field_187586_ay;
    }

    @Override
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        super.func_184601_bQ(damageSourceIn);
        return SoundEvents.field_187588_az;
    }

    @Override
    public boolean fluffyTail() {
        return false;
    }

    @Override
    public boolean longEars() {
        return true;
    }

    @Override
    public boolean thinMane() {
        return true;
    }

    @Override
    public Species getSpecies() {
        return Species.DONKEY;
    }

    public boolean func_70878_b(AnimalEntity otherAnimal) {
        if (otherAnimal == this) {
            return false;
        }
        if (otherAnimal instanceof AbstractHorseGenetic && !this.isOppositeGender((AbstractHorseGenetic)otherAnimal)) {
            return false;
        }
        if (otherAnimal instanceof DonkeyGeneticEntity || otherAnimal instanceof HorseGeneticEntity || otherAnimal instanceof DonkeyEntity || otherAnimal instanceof HorseEntity) {
            return this.func_110200_cJ() && Util.horseCanMate((AbstractHorseEntity)otherAnimal);
        }
        return false;
    }

    @Override
    public AbstractHorseEntity getChild(ServerWorld world, AgeableEntity ageable) {
        if (ageable instanceof AbstractHorseGenetic) {
            AbstractHorseGenetic child = null;
            AbstractHorseGenetic other = (AbstractHorseGenetic)ageable;
            if (ageable instanceof HorseGeneticEntity) {
                child = (AbstractHorseGenetic)ModEntities.MULE_GENETIC.func_200721_a(this.field_70170_p);
                if (((Boolean)HorseConfig.Breeding.enableGenders.get()).booleanValue() && !this.isMale() && ((HorseGeneticEntity)ageable).isMale()) {
                    ((MuleGeneticEntity)child).setSpecies(Species.HINNY);
                }
            } else if (ageable instanceof DonkeyGeneticEntity) {
                child = (AbstractHorseGenetic)ModEntities.DONKEY_GENETIC.func_200721_a(this.field_70170_p);
            }
            return child;
        }
        if (ageable instanceof HorseEntity) {
            return (AbstractHorseEntity)EntityType.field_200779_S.func_200721_a(this.field_70170_p);
        }
        if (ageable instanceof DonkeyEntity) {
            return (AbstractHorseEntity)EntityType.field_200798_l.func_200721_a(this.field_70170_p);
        }
        return null;
    }

    @Override
    public Breed getDefaultBreed() {
        return DefaultDonkey.breed;
    }

    @Override
    public int getPopulation() {
        return 40000000;
    }
}

