/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity.genetics;

import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import sekelsta.horse_colors.client.renderer.TextureLayer;
import sekelsta.horse_colors.client.renderer.TextureLayerGroup;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.genetics.EquineGenome;
import sekelsta.horse_colors.entity.genetics.HorsePatternCalculator;
import sekelsta.horse_colors.entity.genetics.Species;
import sekelsta.horse_colors.util.Color;
import sekelsta.horse_colors.util.Pigment;

public class HorseColorCalculator {
    private static final int GRAY_BODY_STAGES = 19;
    private static final int GRAY_MANE_STAGES = 20;
    private static final Color EUMELANIN = new Color(192, 154, 95);
    private static final Color PHEOMELANIN = new Color(228, 192, 119);
    private static final Color MUSHROOM = new Color(222, 207, 188);
    private static final Color SHELL_HOOF = new Color(255, 229, 184);
    private static final Color PINK_SKIN = new Color(255, 214, 182);
    private static final Color BLUE_EYES = new Color(193, 218, 248);

    public static String fixPath(String inStr) {
        if (inStr == null || inStr.contains(".png")) {
            return inStr;
        }
        if (inStr == "") {
            return null;
        }
        return "horse_colors:textures/entity/horse/" + inStr + ".png";
    }

    private static Pigment redFurPigment(EquineGenome horse) {
        float concentration = 5.0f * HorseColorCalculator.getRandomShadeModifier(horse);
        float white = 0.08f;
        if (horse.isAlbino()) {
            return new Pigment(Color.WHITE, 0.0f, 0.0f);
        }
        if (horse.isDoubleCream() || horse.isHomozygous(EquineGenome.Gene.ivory, 1)) {
            concentration *= 0.05f;
            white += 0.4f;
        } else if (horse.isCreamPearl()) {
            concentration *= 0.1f;
        } else if (horse.hasCream()) {
            concentration *= 0.6f;
            white += 0.15f;
            if (horse.hasAllele(EquineGenome.Gene.cream, 4)) {
                concentration *= 0.6f;
                white = (float)((double)white + 0.04);
            }
        } else if (horse.isPearl()) {
            concentration *= 0.6f;
            white += 0.15f;
            if (horse.hasAllele(EquineGenome.Gene.cream, 4)) {
                concentration *= 0.9f;
                white += 0.04f;
            }
        } else if (horse.isHomozygous(EquineGenome.Gene.cream, 4)) {
            concentration *= 0.9f;
            white += 0.04f;
        }
        if (horse.isHomozygous(EquineGenome.Gene.champagne, 1)) {
            concentration *= 0.15f;
            white = (float)((double)white + 0.2);
        } else if (horse.hasAllele(EquineGenome.Gene.champagne, 1)) {
            concentration *= 0.5f;
            white = (float)((double)white + 0.1);
        }
        if (horse.hasAllele(EquineGenome.Gene.cameo, 1)) {
            concentration *= 0.3f;
            white += 0.25f;
        }
        if (horse.hasAllele(EquineGenome.Gene.rufous, 1)) {
            concentration *= 1.1f;
        }
        if (horse.isHomozygous(EquineGenome.Gene.dark_red, 1)) {
            concentration *= 1.2f;
        }
        if (horse.isHomozygous(EquineGenome.Gene.dense, 1)) {
            concentration *= 1.1f;
            white -= 0.03f;
        }
        white = Math.max(white, 0.0f);
        Color color = horse.isMushroom() ? MUSHROOM : PHEOMELANIN;
        return new Pigment(color, concentration, white);
    }

    private static Color redBodyColor(EquineGenome horse) {
        Color color = HorseColorCalculator.redFurPigment(horse).toColor();
        int liv = horse.countAlleles(EquineGenome.Gene.liver, 0);
        if (liv > 0) {
            Color dark = HorseColorCalculator.blackBodyColor(horse);
            dark.addWhite(0.02f);
            float a = 0.4f;
            int r = horse.getRandom("liver_darkness") >>> 1;
            float r1 = (float)(r % 64) / 64.0f;
            float r2 = (float)(r / 64 % 64) / 64.0f;
            if (horse.hasAllele(EquineGenome.Gene.liver_boost, 1)) {
                r1 = (float)Math.pow(r1, 0.5);
            }
            if (liv == 1) {
                r1 *= 0.5f;
                r2 = 0.0f;
            }
            color.average(dark, a *= (0.2f + r1) * (1.0f + r2));
        }
        return color;
    }

    private static TextureLayer getRedBody(EquineGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("base");
        layer.color = HorseColorCalculator.redBodyColor(horse);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    private static Pigment blackBasePigment(EquineGenome horse) {
        float concentration = 15.0f * HorseColorCalculator.getRandomShadeModifier(horse);
        float white = 0.0f;
        if (horse.isAlbino()) {
            return new Pigment(Color.WHITE, 0.0f, 0.0f);
        }
        if (horse.isDoubleCream() || horse.isHomozygous(EquineGenome.Gene.ivory, 1)) {
            concentration *= 0.03f;
        } else if (horse.isCreamPearl()) {
            concentration *= 0.04f;
        } else if (horse.hasCream()) {
            concentration *= 0.7f;
        } else if (horse.isPearl()) {
            concentration *= 0.33f;
            white += 0.09f;
        }
        if (horse.isHomozygous(EquineGenome.Gene.champagne, 1)) {
            concentration *= 0.125f;
            white = (float)((double)white + 0.15);
        } else if (horse.hasAllele(EquineGenome.Gene.champagne, 1)) {
            concentration *= 0.2f;
            white = (float)((double)white + 0.1);
        }
        if (horse.hasAllele(EquineGenome.Gene.cameo, 1)) {
            concentration *= 0.27f;
            white += 0.1f;
        }
        if (horse.hasAllele(EquineGenome.Gene.silver, 1)) {
            concentration *= 0.7f;
        }
        if (horse.isHomozygous(EquineGenome.Gene.dense, 1)) {
            concentration *= 1.1f;
            white -= 0.01f;
        }
        white = Math.max(white, 0.0f);
        return new Pigment(EUMELANIN, concentration, white);
    }

    private static Pigment blackFurPigment(EquineGenome horse) {
        Pigment pigment = HorseColorCalculator.blackBasePigment(horse);
        pigment.white *= 2.0f;
        pigment.white += 0.02f;
        if (horse.hasAllele(EquineGenome.Gene.silver, 1)) {
            pigment.concentration *= 0.75f;
        }
        if (horse.isPearl()) {
            // empty if block
        }
        return pigment;
    }

    private static Color blackBodyColor(EquineGenome horse) {
        return HorseColorCalculator.blackFurPigment(horse).toColor();
    }

    private static void addBlackBody(EquineGenome horse, TextureLayerGroup layers) {
        if (horse.isChestnut()) {
            return;
        }
        TextureLayer layer = new TextureLayer();
        layer.description = "black body";
        if (horse.getMaxAllele(EquineGenome.Gene.agouti) == 0) {
            layer.name = HorseColorCalculator.fixPath("base");
        } else if (!(horse.getMaxAllele(EquineGenome.Gene.agouti) != 1 && horse.getMaxAllele(EquineGenome.Gene.agouti) != 2 || horse.hasAllele(EquineGenome.Gene.reduced_points, 1))) {
            layer.name = HorseColorCalculator.fixPath("brown");
        } else {
            layers.add(HorseColorCalculator.getSooty(horse));
            if (horse.species == Species.DONKEY) {
                layer.name = HorseColorCalculator.fixPath("donkey_bay");
            } else {
                return;
            }
        }
        layer.color = HorseColorCalculator.blackBodyColor(horse);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        layers.add(layer);
    }

    private static float getRandomShadeModifier(EquineGenome horse) {
        int r = horse.getRandom("shade") >>> 1;
        int x = r % 8 + r / 8 % 8 - 8;
        return 1.0f + (float)x / 100.0f;
    }

    private static void addRedManeTail(EquineGenome horse, List<TextureLayer> layers) {
        float PALOMINO_POWER = 0.2f;
        if (!horse.isChestnut()) {
            return;
        }
        if (horse.hasAllele(EquineGenome.Gene.cream, 3) || horse.hasAllele(EquineGenome.Gene.champagne, 1)) {
            TextureLayer palomino_mane = new TextureLayer();
            palomino_mane.description = "palomino mane";
            palomino_mane.name = HorseColorCalculator.fixPath("manetail");
            palomino_mane.color = HorseColorCalculator.redBodyColor(horse);
            palomino_mane.color.power(0.2f);
            HorseColorCalculator.setGrayConcentration(horse, palomino_mane);
            layers.add(palomino_mane);
        }
        if (!(horse.isHomozygous(EquineGenome.Gene.flaxen1, 0) || horse.isHomozygous(EquineGenome.Gene.flaxen2, 0) || horse.isMushroom())) {
            return;
        }
        TextureLayer flaxen = new TextureLayer();
        flaxen.name = HorseColorCalculator.fixPath("flaxen");
        flaxen.description = "flaxen";
        flaxen.color = HorseColorCalculator.redBodyColor(horse);
        float power = 1.0f;
        if (horse.hasAllele(EquineGenome.Gene.cream, 3)) {
            power *= 0.2f;
        }
        if (horse.hasAllele(EquineGenome.Gene.champagne, 1)) {
            power *= 0.2f;
        }
        float white = 0.0f;
        if (horse.isHomozygous(EquineGenome.Gene.flaxen1, 0)) {
            power *= 0.5f;
            white += 0.2f;
        }
        if (horse.isHomozygous(EquineGenome.Gene.flaxen2, 0)) {
            power *= 0.8f;
            white += 0.1f;
        }
        if (horse.hasAllele(EquineGenome.Gene.flaxen_boost, 1)) {
            Math.pow(power, 1.5);
            white = (float)((double)white * 1.5);
        }
        if (horse.isMushroom()) {
            power *= 0.5f;
            white += 0.02f;
        }
        flaxen.color.power(power);
        HorseColorCalculator.setGrayConcentration(horse, flaxen);
        flaxen.color.addWhite(white);
        layers.add(flaxen);
    }

    private static TextureLayer getBlackManeTail(EquineGenome horse) {
        if (horse.isChestnut()) {
            return null;
        }
        if (!horse.hasAllele(EquineGenome.Gene.silver, 1)) {
            return null;
        }
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("flaxen");
        layer.description = "silver dapple mane";
        Pigment black = HorseColorCalculator.blackFurPigment(horse);
        black.concentration *= 0.020000001f;
        layer.color = black.toColor();
        HorseColorCalculator.setGrayConcentration(horse, layer);
        return layer;
    }

    private static void colorSkin(EquineGenome horse, TextureLayer layer) {
        Pigment pigment = HorseColorCalculator.blackBasePigment(horse);
        pigment.concentration *= 1.2f;
        layer.color = pigment.toColor();
        layer.color.multiply(PINK_SKIN);
    }

    private static float blueEyeShade(EquineGenome horse) {
        int shade = 0;
        shade += 3 * horse.countAlleles(EquineGenome.Gene.blue_eye_shade1, 1);
        shade += 2 * (2 - horse.countAlleles(EquineGenome.Gene.blue_eye_shade2, 1));
        return 0.34f + 0.21333332f * (float)(shade += 1 * (2 - horse.countAlleles(EquineGenome.Gene.blue_eye_shade3, 1)));
    }

    private static void colorGray(EquineGenome horse, TextureLayer layer) {
        HorseColorCalculator.colorSkin(horse, layer);
        layer.color.addWhite(0.99f);
    }

    private static void addNose(EquineGenome horse, TextureLayerGroup layerGroup) {
        TextureLayer noseBase = new TextureLayer();
        noseBase.name = HorseColorCalculator.fixPath("nose");
        if (horse.hasAllele(EquineGenome.Gene.champagne, 1)) {
            Pigment frecklePigment = HorseColorCalculator.blackBasePigment(horse);
            TextureLayer freckles = new TextureLayer();
            freckles.name = HorseColorCalculator.fixPath("freckles");
            freckles.type = TextureLayer.Type.NO_ALPHA;
            frecklePigment.concentration *= 3.0f;
            freckles.color = frecklePigment.toColor();
            freckles.color.multiply(PINK_SKIN);
            Pigment black = HorseColorCalculator.blackBasePigment(horse);
            black.concentration *= 0.2f;
            black.white *= 0.1f;
            noseBase.color = black.toColor();
            noseBase.color.multiply(PINK_SKIN);
            TextureLayerGroup group = new TextureLayerGroup();
            group.add(noseBase);
            group.add(freckles);
            layerGroup.add(group);
        } else {
            HorseColorCalculator.colorSkin(horse, noseBase);
            layerGroup.add(noseBase);
        }
    }

    private static TextureLayer getHooves(EquineGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("hooves");
        HorseColorCalculator.colorSkin(horse, layer);
        layer.color.addWhite(0.4f);
        layer.color.multiply(SHELL_HOOF);
        return layer;
    }

    private static TextureLayer getEyes(EquineGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("iris");
        Pigment blue = new Pigment(BLUE_EYES, HorseColorCalculator.blueEyeShade(horse), 0.0f);
        if (horse.isHomozygous(EquineGenome.Gene.MITF, 0)) {
            layer.color = blue.toColor();
        } else {
            Pigment pigment = HorseColorCalculator.blackBasePigment(horse);
            if (horse.hasAllele(EquineGenome.Gene.champagne, 1)) {
                pigment.concentration *= 1.5f;
            }
            if (horse.hasAllele(EquineGenome.Gene.cream, 2)) {
                pigment.concentration *= 2.0f;
            }
            if (horse.isHomozygous(EquineGenome.Gene.tiger_eye, 1)) {
                pigment.concentration *= 0.25f;
                if (horse.hasAllele(EquineGenome.Gene.cream, 3)) {
                    pigment.concentration *= 0.2f;
                } else {
                    blue.concentration *= 0.25f;
                }
            }
            if (horse.isHomozygous(EquineGenome.Gene.brown_eye_shade1, 1)) {
                pigment.concentration *= 0.8f;
            }
            for (int i = 0; i < horse.countAlleles(EquineGenome.Gene.brown_eye_shade2, 1); ++i) {
                pigment.concentration *= 0.9f;
            }
            if (horse.isHomozygous(EquineGenome.Gene.brown_eye_shade3, 1)) {
                pigment.concentration *= 1.1f;
            }
            pigment.concentration *= 0.5f;
            pigment.white *= 0.2f;
            blue.concentration = Math.max(0.0f, blue.concentration - 0.5f * pigment.concentration);
            layer.color = pigment.toColor();
            layer.color.multiply(blue.toColor());
        }
        return layer;
    }

    private static void addDun(EquineGenome horse, List<TextureLayer> layers) {
        if (!horse.hasStripe()) {
            return;
        }
        TextureLayer white = new TextureLayer();
        white.name = HorseColorCalculator.fixPath("dun/dun_dilute");
        white.color.a = 0.1f;
        if (!horse.isDun()) {
            white.color.a *= 0.1f;
        }
        if (horse.isHomozygous(EquineGenome.Gene.light_dun, 1)) {
            white.color.a *= 2.0f;
        }
        white.type = TextureLayer.Type.SHADE;
        layers.add(white);
        TextureLayer layer = new TextureLayer();
        layer.name = HorseColorCalculator.fixPath("dun/dun_dilute");
        layer.type = TextureLayer.Type.ROOT;
        float dunpower = 0.6f;
        if (!horse.isDun()) {
            dunpower = 0.9f;
        }
        layer.color = new Color(dunpower, dunpower, dunpower);
        layers.add(layer);
    }

    private static TextureLayer getSooty(EquineGenome horse) {
        TextureLayer layer = new TextureLayer();
        layer.color = HorseColorCalculator.blackBodyColor(horse);
        HorseColorCalculator.setGrayConcentration(horse, layer);
        int sooty_level = horse.getSootyLevel();
        switch (sooty_level) {
            case 0: {
                return null;
            }
            case 1: {
                layer.color.a = 0.2f;
                break;
            }
            case 2: {
                layer.color.a = 0.5f;
                break;
            }
            case 3: {
                layer.color.a = 0.8f;
                break;
            }
            case 4: {
                layer.color.a = 1.0f;
                break;
            }
            default: {
                layer.color.a = 1.0f;
            }
        }
        layer.name = HorseColorCalculator.fixPath("sooty_countershade");
        if (horse.isDappleInclined()) {
            layer.name = HorseColorCalculator.fixPath("sooty_dapple");
        } else if (horse.isChestnut()) {
            layer.name = HorseColorCalculator.fixPath("base");
            layer.color.a *= 0.5f;
        }
        return layer;
    }

    private static void addMealy(EquineGenome horse, List<TextureLayer> textureLayers) {
        if (!horse.isMealy()) {
            return;
        }
        TextureLayer light_belly = new TextureLayer();
        int spread = 1;
        int color = 0;
        if (horse.hasAllele(EquineGenome.Gene.mealy1, 1)) {
            spread += 2;
        }
        if (horse.hasAllele(EquineGenome.Gene.mealy2, 1)) {
            ++color;
        }
        if (horse.isHomozygous(EquineGenome.Gene.flaxen2, 0)) {
            ++spread;
        }
        String prefix = "";
        TextureLayer other = null;
        if (horse.isHomozygous(EquineGenome.Gene.light_legs, 1)) {
            prefix = "l";
        } else if (horse.hasAllele(EquineGenome.Gene.less_light_legs, 0)) {
            prefix = "l";
            if (spread > 1) {
                --spread;
                other = new TextureLayer();
                other.name = HorseColorCalculator.fixPath("mealy/mealy1");
                other.color = HorseColorCalculator.redBodyColor(horse);
                other.color.power(0.04f * (float)(2 - color));
            }
        }
        light_belly.name = HorseColorCalculator.fixPath("mealy/" + prefix + "mealy" + spread);
        light_belly.color = HorseColorCalculator.redBodyColor(horse);
        light_belly.color.power(0.04f * (float)(2 - color));
        textureLayers.add(light_belly);
        if (other != null) {
            textureLayers.add(other);
        }
    }

    private static void addPoints(EquineGenome horse, List<TextureLayer> layers) {
        TextureLayerGroup points = new TextureLayerGroup();
        if (horse.hasStripe()) {
            TextureLayer stripe = new TextureLayer();
            stripe.name = HorseColorCalculator.fixPath("dun/dorsal");
            points.add(stripe);
            if (horse.hasAllele(EquineGenome.Gene.cross, 1)) {
                TextureLayer cross = new TextureLayer();
                cross.name = HorseColorCalculator.fixPath("dun/cross");
                points.add(cross);
            }
        }
        if (horse.hasStripe() || !horse.isChestnut()) {
            TextureLayer legs = new TextureLayer();
            String name = "bay";
            if (horse.hasAllele(EquineGenome.Gene.reduced_points, 1)) {
                name = "wild_bay";
            }
            if (horse.species == Species.DONKEY) {
                name = "wild_bay";
            }
            legs.name = HorseColorCalculator.fixPath(name);
            points.add(legs);
            TextureLayer mane = new TextureLayer();
            mane.name = HorseColorCalculator.fixPath("manetail");
            points.add(mane);
        }
        if (horse.isChestnut()) {
            points.color = HorseColorCalculator.redBodyColor(horse);
            points.color.power(1.1f);
        } else {
            Pigment pigment = HorseColorCalculator.blackFurPigment(horse);
            if (horse.hasAllele(EquineGenome.Gene.champagne, 1)) {
                pigment.concentration *= 1.2f;
                pigment.white = (float)((double)pigment.white * 0.5);
            }
            points.color = pigment.toColor();
            points.color.power(1.2f);
        }
        if (points.layers.size() > 0) {
            layers.add(points);
        }
        HorseColorCalculator.setGrayConcentration(horse, points);
    }

    private static void addGray(EquineGenome horse, List<TextureLayer> layers) {
        if (!horse.isGray()) {
            return;
        }
        float rate = horse.getGrayRate();
        float mane_rate = horse.getGrayManeRate();
        int body_stage = HorseColorCalculator.grayStage(horse, rate, 19, 0.25f);
        int mane_stage = HorseColorCalculator.grayStage(horse, mane_rate, 20, 0.3f);
        if (body_stage > 0) {
            TextureLayer body = new TextureLayer();
            body.name = body_stage > 19 ? HorseColorCalculator.fixPath("body") : HorseColorCalculator.fixPath("gray/dapple" + body_stage);
            HorseColorCalculator.colorGray(horse, body);
            layers.add(body);
        }
        if (mane_stage > 0) {
            TextureLayer mane = new TextureLayer();
            mane.name = mane_stage > 20 ? HorseColorCalculator.fixPath("manetail") : HorseColorCalculator.fixPath("gray/mane" + mane_stage);
            HorseColorCalculator.colorGray(horse, mane);
            layers.add(mane);
        }
    }

    private static int grayStage(EquineGenome horse, float rate, int num_stages, float delay) {
        int YEAR_TICKS = (int)((Double)HorseConfig.Growth.yearLength.get() * 24000.0);
        int MAX_AGE = HorseConfig.GROWTH.getMaxAge();
        int age = horse.getAge() + 24000;
        age = Math.min(age, MAX_AGE);
        if (!((Boolean)HorseConfig.Growth.grayGradually.get()).booleanValue()) {
            age = (int)((float)MAX_AGE * 0.5f);
        }
        float gray_age = (float)age / ((float)YEAR_TICKS * rate);
        if ((gray_age = (gray_age - delay) / (1.0f - delay)) <= 0.0f) {
            return 0;
        }
        if (gray_age >= 1.0f) {
            return num_stages + 1;
        }
        return (int)(gray_age * (float)num_stages);
    }

    private static float grayConcentration(EquineGenome horse, float rate) {
        int stage = HorseColorCalculator.grayStage(horse, rate, 50, 0.0f);
        double val = 1.1 + Math.pow(1.06, stage) * (double)stage / 50.0 * (double)stage / 50.0;
        return (float)val;
    }

    private static void setGrayConcentration(EquineGenome horse, TextureLayer layer) {
        if (horse.isGray()) {
            float concentration = HorseColorCalculator.grayConcentration(horse, horse.getGrayRate());
            Color dark = new Color(layer.color);
            dark.power(concentration);
            float lightnessDiff = (dark.r + dark.g + dark.b) / (layer.color.r + layer.color.g + layer.color.b);
            layer.color.average(Color.BLACK, 1.0f - lightnessDiff);
            layer.color.average(dark, 0.5f);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static TextureLayerGroup getTexturePaths(EquineGenome horse) {
        ArrayList<TextureLayer> textureLayers = new ArrayList<TextureLayer>();
        TextureLayerGroup layerGroup = new TextureLayerGroup(textureLayers);
        TextureLayer red = HorseColorCalculator.getRedBody(horse);
        textureLayers.add(red);
        HorseColorCalculator.addMealy(horse, textureLayers);
        HorseColorCalculator.addBlackBody(horse, layerGroup);
        HorseColorCalculator.addDun(horse, textureLayers);
        HorseColorCalculator.addPoints(horse, textureLayers);
        HorseColorCalculator.addRedManeTail(horse, textureLayers);
        textureLayers.add(HorseColorCalculator.getBlackManeTail(horse));
        HorseColorCalculator.addGray(horse, textureLayers);
        HorseColorCalculator.addNose(horse, layerGroup);
        textureLayers.add(HorseColorCalculator.getHooves(horse));
        if (horse.hasAllele(EquineGenome.Gene.KIT, 14)) {
            TextureLayer roan = new TextureLayer();
            roan.name = HorseColorCalculator.fixPath("roan/roan");
            int r = horse.getRandom("roan_density") >>> 1;
            float a = (float)(50 - r % 16 - r / 16 % 16) / 50.0f;
            roan.color.a *= a;
            textureLayers.add(roan);
        }
        if (horse.hasAllele(EquineGenome.Gene.rabicano, 1)) {
            TextureLayer rabicano = new TextureLayer();
            rabicano.name = HorseColorCalculator.fixPath("roan/rabicano");
            textureLayers.add(rabicano);
        }
        HorsePatternCalculator.addFaceMarkings(horse, textureLayers);
        if (horse.showsLegMarkings()) {
            HorsePatternCalculator.addLegMarkings(horse, textureLayers);
        }
        HorsePatternCalculator.addPinto(horse, textureLayers);
        HorsePatternCalculator.addLeopard(horse, textureLayers);
        textureLayers.add(HorseColorCalculator.getEyes(horse));
        TextureLayer highlights = new TextureLayer();
        highlights.name = HorseColorCalculator.fixPath("base");
        highlights.type = TextureLayer.Type.HIGHLIGHT;
        highlights.color.a = 0.2f;
        textureLayers.add(highlights);
        TextureLayer shading = new TextureLayer();
        shading.name = HorseColorCalculator.fixPath("shading");
        shading.type = TextureLayer.Type.SHADE;
        shading.color.a = 0.5f;
        textureLayers.add(shading);
        TextureLayer common = new TextureLayer();
        common.name = HorseColorCalculator.fixPath("common");
        textureLayers.add(common);
        return layerGroup;
    }
}

