/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity.genetics;

import java.util.ArrayList;
import java.util.List;
import sekelsta.horse_colors.client.renderer.TextureLayer;
import sekelsta.horse_colors.client.renderer.TextureLayerGroup;
import sekelsta.horse_colors.entity.genetics.EquineGenome;
import sekelsta.horse_colors.entity.genetics.HorseColorCalculator;

public class HorsePatternCalculator {
    public static boolean hasPigmentInEars(EquineGenome horse) {
        return HorsePatternCalculator.getPreviousFaceWhiteLevel(horse) <= 18;
    }

    public static int getPreviousFaceWhiteLevel(EquineGenome horse) {
        int white = -2;
        if (horse.hasAllele(EquineGenome.Gene.white_suppression, 1)) {
            white -= 4;
        }
        white += horse.countAlleles(EquineGenome.Gene.KIT, 1);
        white += horse.countAlleles(EquineGenome.Gene.KIT, 2);
        white += 2 * horse.countAlleles(EquineGenome.Gene.KIT, 3);
        white += 2 * horse.countAlleles(EquineGenome.Gene.KIT, 4);
        white += 3 * horse.countAlleles(EquineGenome.Gene.KIT, 5);
        white += 3 * horse.countAlleles(EquineGenome.Gene.KIT, 6);
        white += 3 * horse.countW20();
        white += 4 * horse.countAlleles(EquineGenome.Gene.KIT, 9);
        white += 6 * horse.countAlleles(EquineGenome.Gene.MITF, 0);
        white += 9 * horse.countAlleles(EquineGenome.Gene.MITF, 1);
        white += 8 * horse.countAlleles(EquineGenome.Gene.MITF, 2);
        white += 7 * horse.countAlleles(EquineGenome.Gene.PAX3, 1);
        white += 8 * horse.countAlleles(EquineGenome.Gene.PAX3, 2);
        white += 3 * horse.countAlleles(EquineGenome.Gene.white_star, 1);
        white += horse.countAlleles(EquineGenome.Gene.white_forelegs, 1);
        white += horse.countAlleles(EquineGenome.Gene.white_hindlegs, 1);
        if (horse.hasMC1RWhiteBoost()) {
            white += 2;
        }
        return white;
    }

    public static TextureLayer getPreviousFaceMarking(EquineGenome horse) {
        int white = HorsePatternCalculator.getPreviousFaceWhiteLevel(horse);
        int unused_bits = 2;
        int random = horse.getRandom("leg_white") << 1 >>> 1 + unused_bits;
        if ((white += random & 3) <= 0) {
            return null;
        }
        int face_marking = white / 5;
        TextureLayer layer = new TextureLayer();
        String folder = "face/";
        switch (face_marking) {
            case 0: {
                break;
            }
            case 1: {
                layer.name = HorseColorCalculator.fixPath(folder + "star");
                break;
            }
            case 2: {
                layer.name = HorseColorCalculator.fixPath(folder + "strip");
                break;
            }
            case 3: {
                layer.name = HorseColorCalculator.fixPath(folder + "blaze");
                break;
            }
            default: {
                layer.name = HorseColorCalculator.fixPath(folder + "blaze");
            }
        }
        return layer;
    }

    public static void addFaceMarkings(EquineGenome horse, List<TextureLayer> textureLayers) {
        TextureLayer face = HorsePatternCalculator.getPreviousFaceMarking(horse);
        if (face != null && face.name != null) {
            textureLayers.add(face);
        }
    }

    public static void addLegMarkings(EquineGenome horse, List<TextureLayer> textureLayers) {
        WhiteBoost whiteBoost = new WhiteBoost(horse);
        String[] legs = new String[4];
        int random = horse.getRandom("leg_white");
        random = random << 1 >>> 5;
        for (int i = 0; i < 4; ++i) {
            int r = random & 7;
            random >>>= 3;
            int w = whiteBoost.getForelegs();
            if (i >= 2) {
                w = whiteBoost.getHindlegs();
            }
            if (w > -2) {
                w += whiteBoost.conditional;
            }
            legs[i] = w < 0 ? null : HorseColorCalculator.fixPath("socks/" + String.valueOf(i) + "_" + String.valueOf(Math.min(7, w / 2 + r)));
        }
        for (String marking : legs) {
            if (marking == null) continue;
            TextureLayer layer = new TextureLayer();
            layer.name = marking;
            textureLayers.add(layer);
        }
    }

    public static void addPinto(EquineGenome horse, List<TextureLayer> textureLayers) {
        TextureLayer layer = new TextureLayer();
        if (horse.isWhite()) {
            layer.name = HorseColorCalculator.fixPath("pinto/white");
            textureLayers.add(layer);
            return;
        }
        String folder = "pinto/";
        if (horse.isTobiano()) {
            layer.name = horse.isHomozygous(EquineGenome.Gene.MITF, 0) ? HorseColorCalculator.fixPath(folder + "medicine_hat") : (horse.hasAllele(EquineGenome.Gene.KIT, 12) ? HorseColorCalculator.fixPath(folder + "sabino_tobiano") : (horse.hasAllele(EquineGenome.Gene.frame, 1) ? HorseColorCalculator.fixPath(folder + "war_shield") : HorseColorCalculator.fixPath(folder + "tobiano")));
        } else if (horse.hasAllele(EquineGenome.Gene.KIT, 12)) {
            layer.name = horse.isHomozygous(EquineGenome.Gene.MITF, 0) ? HorseColorCalculator.fixPath(folder + "sabino_splash") : (horse.hasAllele(EquineGenome.Gene.frame, 1) ? HorseColorCalculator.fixPath(folder + "frame_sabino") : HorseColorCalculator.fixPath(folder + "sabino"));
        } else if (horse.hasAllele(EquineGenome.Gene.frame, 1)) {
            layer.name = horse.isHomozygous(EquineGenome.Gene.MITF, 0) ? HorseColorCalculator.fixPath(folder + "frame_splash") : HorseColorCalculator.fixPath(folder + "frame");
        } else if (horse.isHomozygous(EquineGenome.Gene.MITF, 0)) {
            layer.name = HorseColorCalculator.fixPath(folder + "splash");
        }
        if (layer.name != null && !layer.name.equals("")) {
            textureLayers.add(layer);
        }
    }

    public static void addLeopard(EquineGenome horse, List<TextureLayer> textureLayers) {
        if (!horse.hasAllele(EquineGenome.Gene.leopard, 1)) {
            return;
        }
        TextureLayer hooves = new TextureLayer();
        hooves.name = horse.isHomozygous(EquineGenome.Gene.leopard, 1) ? HorseColorCalculator.fixPath("leopard/lplp_features") : HorseColorCalculator.fixPath("leopard/lp_features");
        textureLayers.add(hooves);
        int patn = 7 * horse.countAlleles(EquineGenome.Gene.PATN1, 1);
        patn += 2 * horse.countAlleles(EquineGenome.Gene.PATN2, 1);
        TextureLayer spread = new TextureLayer();
        if ((patn += horse.countAlleles(EquineGenome.Gene.PATN3, 1)) == 0) {
            spread.name = HorseColorCalculator.fixPath("leopard/varnish_roan");
            textureLayers.add(spread);
            return;
        }
        WhiteBoost whiteBoost = new WhiteBoost(horse);
        spread.name = (patn += whiteBoost.getBlanket()) < 1 ? HorseColorCalculator.fixPath("leopard/varnish_roan") : HorseColorCalculator.fixPath("leopard/blanket" + patn);
        TextureLayer spots = new TextureLayer();
        spots.name = horse.isHomozygous(EquineGenome.Gene.leopard, 1) ? HorseColorCalculator.fixPath("leopard/fewspot") : (horse.hasAllele(EquineGenome.Gene.white_suppression, 1) ? HorseColorCalculator.fixPath("leopard/leopard_large") : (horse.hasAllele(EquineGenome.Gene.marble, 1) ? HorseColorCalculator.fixPath("leopard/leopard_marble") : HorseColorCalculator.fixPath("leopard/leopard")));
        if (patn >= 8) {
            textureLayers.add(spots);
            return;
        }
        spots.type = TextureLayer.Type.MASK;
        ArrayList<TextureLayer> layers = new ArrayList<TextureLayer>();
        layers.add(spread);
        layers.add(spots);
        textureLayers.add(new TextureLayerGroup(layers));
    }

    public static class WhiteBoost {
        public int general = 0;
        public int conditional = 0;
        public int leg = 0;
        public int face = 0;
        public int foreleg = 0;
        public int hindleg = 0;
        public int forehead = 0;
        public int noseBridge = 0;
        public int muzzle = 0;
        public int blanket = 0;

        public WhiteBoost(EquineGenome horse) {
            this.foreleg = 2 * horse.countAlleles(EquineGenome.Gene.white_forelegs, 1);
            this.hindleg = 2 * horse.countAlleles(EquineGenome.Gene.white_hindlegs, 1);
            this.forehead += horse.countAlleles(EquineGenome.Gene.white_star, 1);
            this.setOldLegWhite(horse);
            if (horse.hasMC1RWhiteBoost()) {
                this.conditional += 2;
            }
            this.setGeneralWhite(horse);
            this.face = WhiteBoost.getOldFaceWhiteLevel(horse);
        }

        private void setGeneralWhite(EquineGenome horse) {
            if (horse.hasAllele(EquineGenome.Gene.white_suppression, 1)) {
                this.general -= 4;
            }
            this.general += horse.countAlleles(EquineGenome.Gene.KIT, 1);
            this.general += horse.countAlleles(EquineGenome.Gene.KIT, 2);
            this.general += 2 * horse.countAlleles(EquineGenome.Gene.KIT, 3);
            this.general += 2 * horse.countAlleles(EquineGenome.Gene.KIT, 4);
            this.general += 3 * horse.countAlleles(EquineGenome.Gene.KIT, 5);
            this.general += 3 * horse.countAlleles(EquineGenome.Gene.KIT, 6);
            this.general += 3 * horse.countW20();
            this.general += 4 * horse.countAlleles(EquineGenome.Gene.KIT, 9);
            this.general += 2 * horse.countAlleles(EquineGenome.Gene.MITF, 0);
            this.general += 6 * horse.countAlleles(EquineGenome.Gene.MITF, 1);
            this.general += 2 * horse.countAlleles(EquineGenome.Gene.MITF, 2);
            this.general += 2 * horse.countAlleles(EquineGenome.Gene.PAX3, 1);
            this.general += 3 * horse.countAlleles(EquineGenome.Gene.PAX3, 2);
            if (horse.hasAllele(EquineGenome.Gene.white_star, 1)) {
                ++this.general;
            }
        }

        public static int getOldFaceWhiteLevel(EquineGenome horse) {
            int white = -2;
            white += 6 * horse.countAlleles(EquineGenome.Gene.MITF, 0);
            white += 9 * horse.countAlleles(EquineGenome.Gene.MITF, 1);
            white += 8 * horse.countAlleles(EquineGenome.Gene.MITF, 2);
            white += 7 * horse.countAlleles(EquineGenome.Gene.PAX3, 1);
            white += 8 * horse.countAlleles(EquineGenome.Gene.PAX3, 2);
            white += horse.countAlleles(EquineGenome.Gene.white_forelegs, 1);
            white += horse.countAlleles(EquineGenome.Gene.white_hindlegs, 1);
            if (horse.hasMC1RWhiteBoost()) {
                white += 2;
            }
            return white;
        }

        private void setOldLegWhite(EquineGenome horse) {
            int white = -3;
            white += 1 * horse.countAlleles(EquineGenome.Gene.KIT, 2);
            white += 1 * horse.countAlleles(EquineGenome.Gene.KIT, 3);
            white += 2 * horse.countAlleles(EquineGenome.Gene.KIT, 4);
            white += 2 * horse.countAlleles(EquineGenome.Gene.KIT, 5);
            white += 3 * horse.countAlleles(EquineGenome.Gene.KIT, 6);
            white += 4 * horse.countW20();
            this.leg = white += 4 * horse.countAlleles(EquineGenome.Gene.KIT, 9);
        }

        public void setBlanketWhite(EquineGenome horse) {
            if (horse.hasAllele(EquineGenome.Gene.leopard_suppression, 1)) {
                this.blanket -= 1 + horse.countAlleles(EquineGenome.Gene.PATN1, 1);
            }
            if (horse.isHomozygous(EquineGenome.Gene.leopard_suppression2, 1)) {
                --this.blanket;
            }
            if (horse.hasAllele(EquineGenome.Gene.PATN_boost1, 1)) {
                ++this.blanket;
            }
            if (horse.isHomozygous(EquineGenome.Gene.PATN_boost2, 1)) {
                ++this.blanket;
            }
        }

        public int getForelegs() {
            return this.general + this.leg + this.foreleg;
        }

        public int getHindlegs() {
            return this.general + this.leg + this.hindleg;
        }

        public int getBlanket() {
            return this.general / 2 + this.blanket;
        }

        public int getForehead() {
            return (this.general + this.face) / 5 + this.forehead;
        }

        public int getNoseBridge() {
            return (this.general + this.face) / 5 + this.noseBridge;
        }

        public int getMuzzle() {
            return (this.general + this.face) / 5 + this.muzzle;
        }
    }
}

