/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.entity.genetics;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.AgeableEntity;
import sekelsta.horse_colors.breed.Breed;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.genetics.Genome;

public interface IGeneticEntity {
    public Genome getGenome();

    public String getGeneData();

    public void setGeneData(String var1);

    public int getSeed();

    public void setSeed(int var1);

    public Random getRand();

    public boolean isMale();

    public void setMale(boolean var1);

    public int getRebreedTicks();

    public int getBirthAge();

    public int getTrueAge();

    default public float getFractionGrown() {
        int age = this.getTrueAge();
        if (age < 0) {
            if (((Boolean)HorseConfig.Growth.growGradually.get()).booleanValue()) {
                int minAge = this.getBirthAge();
                float fractionGrown = (float)(minAge - age) / (float)minAge;
                return Math.max(0.0f, fractionGrown);
            }
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean setPregnantWith(AgeableEntity var1, AgeableEntity var2);

    default public Breed getDefaultBreed() {
        return new Breed();
    }

    default public int getPopulation() {
        int count = 0;
        for (Breed breed : this.getBreeds()) {
            count += breed.population;
        }
        return count;
    }

    default public List<Breed> getBreeds() {
        return ImmutableList.of((Object)this.getDefaultBreed());
    }

    default public Breed getRandomBreed() {
        int r = this.getRand().nextInt(Math.max(1, this.getPopulation()));
        int count = 0;
        for (Breed breed : this.getBreeds()) {
            if (r >= (count += breed.population)) continue;
            return breed;
        }
        return this.getDefaultBreed();
    }

    default public Breed getBreed(String name) {
        for (Breed breed : this.getBreeds()) {
            if (!name.equals(breed.name)) continue;
            return breed;
        }
        return null;
    }

    public float getMotherSize();

    public void setMotherSize(float var1);
}

