/*
 * Decompiled with CFR 0.152.
 */
package sekelsta.horse_colors.network;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.WaterMobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.network.NetworkEvent;
import sekelsta.horse_colors.HorseColors;
import sekelsta.horse_colors.config.HorseConfig;
import sekelsta.horse_colors.entity.genetics.IGeneticEntity;

public class CMountEntityPacket {
    private int entityId;

    public CMountEntityPacket() {
    }

    public CMountEntityPacket(int entityId) {
        this.entityId = entityId;
    }

    public CMountEntityPacket(Entity entity) {
        this(entity.func_145782_y());
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150787_b(this.entityId);
    }

    public static CMountEntityPacket decode(PacketBuffer buffer) {
        int id = buffer.func_150792_a();
        return new CMountEntityPacket(id);
    }

    private boolean tryMounting(Entity rider, Entity mount) {
        if (!(rider instanceof LivingEntity)) {
            return false;
        }
        if (rider instanceof WaterMobEntity) {
            return false;
        }
        if (!(mount instanceof IGeneticEntity)) {
            AxisAlignedBB riderBox = rider.func_174813_aQ();
            AxisAlignedBB mountBox = mount.func_174813_aQ();
            if (riderBox.func_72320_b() * 2.0 > mountBox.func_72320_b()) {
                return false;
            }
            double riderSize = riderBox.func_216364_b() * riderBox.func_216360_c() * riderBox.func_216362_d();
            if (rider instanceof AnimalEntity) {
                riderSize *= 2.0;
            }
            if (rider instanceof AgeableEntity && ((AgeableEntity)rider).func_70631_g_()) {
                riderSize *= 2.0;
            }
            if (riderSize * 2.0 > mountBox.func_216364_b() * mountBox.func_216360_c() * mountBox.func_216362_d()) {
                return false;
            }
        }
        return rider.func_184220_m(mount);
    }

    private void handleMain(NetworkEvent.Context context) {
        Entity mount;
        boolean extra;
        ServerPlayerEntity sender = context.getSender();
        Entity target = sender.field_70170_p.func_73045_a(this.entityId);
        boolean bl = extra = (Integer)HorseConfig.Common.mountingTweaks.get() > 1;
        if (target == null) {
            HorseColors.logger.warn("Could not find entity with id " + this.entityId + " requested by " + sender.func_200200_C_().getString());
            return;
        }
        if (!target.func_200600_R().func_220339_d().func_75599_d()) {
            return;
        }
        if (target instanceof PlayerEntity) {
            return;
        }
        if (sender.func_184218_aH() && ((mount = sender.func_184187_bx()) instanceof IGeneticEntity || extra) && this.tryMounting(target, mount)) {
            return;
        }
        List entities = sender.field_70170_p.func_175647_a(MobEntity.class, sender.func_174813_aQ().func_72314_b(9.0, 4.0, 9.0), entity -> entity != target && entity.func_110166_bE() == sender && (entity instanceof IGeneticEntity || extra));
        for (MobEntity entity2 : entities) {
            if (!this.tryMounting(target, (Entity)entity2)) continue;
            return;
        }
        if (target instanceof IGeneticEntity || extra) {
            for (Entity passenger : target.func_184188_bt()) {
                if (!(passenger instanceof PlayerEntity) || passenger == sender) continue;
                return;
            }
            if (target.func_184188_bt().size() == 1 && target.func_184179_bs() == sender) {
                return;
            }
            target.func_184226_ay();
        }
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        context.get().enqueueWork(() -> {
            if ((Integer)HorseConfig.Common.mountingTweaks.get() > 0) {
                this.handleMain((NetworkEvent.Context)context.get());
            }
        });
        context.get().setPacketHandled(true);
    }
}

