/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import mod.azure.hwg.client.gui.GunTableScreenHandler;
import mod.azure.hwg.network.C2SMessageSelectCraft;
import mod.azure.hwg.recipe.GunTableRecipe;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_339;
import net.minecraft.class_3532;
import net.minecraft.class_4185;
import net.minecraft.class_4587;
import net.minecraft.class_465;
import net.minecraft.class_5348;

public class GunTableScreen
extends class_465<GunTableScreenHandler> {
    private static final class_2960 TEXTURE = new class_2960("hwg", "textures/gui/gun_table_gui.png");
    private int selectedIndex;
    private final WidgetButtonPage[] offers = new WidgetButtonPage[7];
    private int indexStartOffset;
    private boolean scrolling;

    public GunTableScreen(GunTableScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 300;
        this.field_25269 = 107;
    }

    private void syncRecipeIndex() {
        ((GunTableScreenHandler)this.field_2797).setRecipeIndex(this.selectedIndex);
        ((GunTableScreenHandler)this.field_2797).switchTo(this.selectedIndex);
        C2SMessageSelectCraft.send(this.selectedIndex);
    }

    protected void method_25426() {
        super.method_25426();
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        int k = j + 18;
        for (int l = 0; l < 7; ++l) {
            this.offers[l] = (WidgetButtonPage)this.method_25411((class_339)new WidgetButtonPage(i, k, l, button -> {
                if (button instanceof WidgetButtonPage) {
                    this.selectedIndex = ((WidgetButtonPage)button).getIndex() + this.indexStartOffset;
                    this.syncRecipeIndex();
                }
            }));
            k += 20;
        }
    }

    protected void method_2388(class_4587 matrices, int mouseX, int mouseY) {
        this.field_22793.method_30883(matrices, this.field_22785, (float)(49 + this.field_2792 / 2 - this.field_22793.method_27525((class_5348)this.field_22785) / 2), 6.0f, 0x404040);
    }

    protected void method_2389(class_4587 matrices, float delta, int mouseX, int mouseY) {
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_22787.method_1531().method_22813(TEXTURE);
        int i = (this.field_22789 - this.field_2792) / 2 - 5;
        int j = (this.field_22790 - this.field_2779) / 2;
        GunTableScreen.method_25291((class_4587)matrices, (int)i, (int)j, (int)this.method_25305(), (float)0.0f, (float)0.0f, (int)this.field_2792, (int)this.field_2779, (int)256, (int)512);
    }

    private void renderScrollbar(class_4587 matrices, int x, int y, List<GunTableRecipe> tradeOffers) {
        int i = tradeOffers.size() + 1 - 7;
        if (i > 1) {
            int j = 139 - (27 + (i - 1) * 139 / i);
            int k = 1 + j / i + 139 / i;
            int m = Math.min(113, this.indexStartOffset * k);
            if (this.indexStartOffset == i - 1) {
                m = 113;
            }
            GunTableScreen.method_25291((class_4587)matrices, (int)(x + 113), (int)(y + 18 + m), (int)this.method_25305(), (float)0.0f, (float)199.0f, (int)6, (int)27, (int)256, (int)512);
        } else {
            GunTableScreen.method_25291((class_4587)matrices, (int)(x + 113), (int)(y + 18), (int)this.method_25305(), (float)6.0f, (float)199.0f, (int)6, (int)27, (int)256, (int)512);
        }
    }

    public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
        this.method_25420(matrices);
        super.method_25394(matrices, mouseX, mouseY, delta);
        List<GunTableRecipe> tradeOfferList = ((GunTableScreenHandler)this.field_2797).getRecipes();
        if (!tradeOfferList.isEmpty()) {
            int i = (this.field_22789 - this.field_2792) / 2;
            int j = (this.field_22790 - this.field_2779) / 2;
            int yPos = j + 17;
            int xPos = i + 3;
            RenderSystem.pushMatrix();
            RenderSystem.enableRescaleNormal();
            this.field_22787.method_1531().method_22813(TEXTURE);
            this.renderScrollbar(matrices, i, j, tradeOfferList);
            int m = 0;
            for (GunTableRecipe gunTableRecipe : tradeOfferList) {
                if (this.canScroll(tradeOfferList.size()) && (m < this.indexStartOffset || m >= 7 + this.indexStartOffset)) {
                    ++m;
                    continue;
                }
                class_1799 output = gunTableRecipe.method_8110();
                this.field_22788.field_4730 = 100.0f;
                int n = yPos + 2;
                this.renderIngredients(matrices, gunTableRecipe, xPos, n);
                this.renderArrow(matrices, gunTableRecipe, i + 22, n);
                this.field_22788.method_27953(output, i + 24 + 68, n);
                this.field_22788.method_4025(this.field_22793, output, i + 24 + 68, n);
                this.field_22788.field_4730 = 0.0f;
                yPos += 20;
                ++m;
            }
        }
        for (WidgetButtonPage widgetButtonPage : this.offers) {
            if (widgetButtonPage.method_25367()) {
                widgetButtonPage.method_25352(matrices, mouseX, mouseY);
            }
            widgetButtonPage.field_22764 = widgetButtonPage.index < ((GunTableScreenHandler)this.field_2797).getRecipes().size();
        }
        RenderSystem.popMatrix();
        RenderSystem.enableDepthTest();
        this.method_2380(matrices, mouseX, mouseY);
    }

    private void renderArrow(class_4587 matrices, GunTableRecipe tradeOffer, int x, int y) {
        RenderSystem.enableBlend();
        this.field_22787.method_1531().method_22813(TEXTURE);
        GunTableScreen.method_25291((class_4587)matrices, (int)(x + 5 + 35 + 20), (int)(y + 3), (int)this.method_25305(), (float)15.0f, (float)171.0f, (int)10, (int)9, (int)256, (int)512);
    }

    private void renderIngredients(class_4587 matrices, GunTableRecipe gunTableRecipe, int x, int y) {
        for (int i = 0; i < 5; ++i) {
            class_1799 stack;
            class_1799[] displayStacks = gunTableRecipe.getIngredientForSlot(i).method_8105();
            if (displayStacks.length <= 0 || (stack = new class_1799((class_1935)displayStacks[0].method_7909(), gunTableRecipe.countRequired(i))).method_7960()) continue;
            this.field_22788.method_27953(stack, x, y);
            this.field_22788.method_4025(this.field_22793, stack, x, y);
            x += 16;
        }
    }

    private boolean canScroll(int listSize) {
        return listSize > 7;
    }

    public boolean method_25401(double mouseX, double mouseY, double amount) {
        int i = ((GunTableScreenHandler)this.field_2797).getRecipes().size();
        if (this.canScroll(i)) {
            int j = i - 7;
            this.indexStartOffset = (int)((double)this.indexStartOffset - amount);
            this.indexStartOffset = class_3532.method_15340((int)this.indexStartOffset, (int)0, (int)j);
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double deltaX, double deltaY) {
        int i = ((GunTableScreenHandler)this.field_2797).getRecipes().size();
        if (this.scrolling) {
            int j = this.field_2800 + 18;
            int k = j + 139;
            int l = i - 7;
            float f = ((float)mouseY - (float)j - 13.5f) / ((float)(k - j) - 27.0f);
            f = f * (float)l + 0.5f;
            this.indexStartOffset = class_3532.method_15340((int)((int)f), (int)0, (int)l);
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, deltaX, deltaY);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.scrolling = false;
        int i = (this.field_22789 - this.field_2792) / 2;
        int j = (this.field_22790 - this.field_2779) / 2;
        if (this.canScroll(((GunTableScreenHandler)this.field_2797).getRecipes().size()) && mouseX > (double)(i + 94) && mouseX < (double)(i + 94 + 6) && mouseY > (double)(j + 18) && mouseY <= (double)(j + 18 + 139 + 1)) {
            this.scrolling = true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    @Environment(value=EnvType.CLIENT)
    class WidgetButtonPage
    extends class_4185 {
        final int index;

        public WidgetButtonPage(int x, int y, int index, class_4185.class_4241 onPress) {
            super(x, y, 112, 20, class_2585.field_24366, onPress);
            this.index = index;
            this.field_22764 = false;
        }

        public int getIndex() {
            return this.index;
        }

        public void method_25352(class_4587 matrices, int mouseX, int mouseY) {
            if (this.field_22762 && ((GunTableScreenHandler)GunTableScreen.this.field_2797).getRecipes().size() > this.index + GunTableScreen.this.indexStartOffset) {
                if (mouseX < this.field_22760 + 20) {
                    class_1799 stack = ((GunTableScreenHandler)GunTableScreen.this.field_2797).getRecipes().get(this.index + GunTableScreen.this.indexStartOffset).method_8110();
                    GunTableScreen.this.method_25409(matrices, stack, mouseX, mouseY);
                } else if (mouseX < this.field_22760 + 50 && mouseX > this.field_22760 + 30) {
                    class_1799 stack = ((GunTableScreenHandler)GunTableScreen.this.field_2797).getRecipes().get(this.index + GunTableScreen.this.indexStartOffset).method_8110();
                    if (!stack.method_7960()) {
                        GunTableScreen.this.method_25409(matrices, stack, mouseX, mouseY);
                    }
                } else if (mouseX > this.field_22760 + 65) {
                    class_1799 stack = ((GunTableScreenHandler)GunTableScreen.this.field_2797).getRecipes().get(this.index + GunTableScreen.this.indexStartOffset).method_8110();
                    GunTableScreen.this.method_25409(matrices, stack, mouseX, mouseY);
                }
            }
        }
    }
}

