/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.entity;

import java.util.Arrays;
import java.util.List;
import java.util.Random;
import mod.azure.hwg.entity.HWGEntity;
import mod.azure.hwg.entity.goal.RangedAttackGoal;
import mod.azure.hwg.entity.projectiles.BulletEntity;
import mod.azure.hwg.entity.projectiles.FireballEntity;
import mod.azure.hwg.entity.projectiles.FlameFiring;
import mod.azure.hwg.item.ammo.BulletAmmo;
import mod.azure.hwg.item.weapons.BrimstoneItem;
import mod.azure.hwg.item.weapons.FlamethrowerItem;
import mod.azure.hwg.item.weapons.HellhorseRevolverItem;
import mod.azure.hwg.util.registry.HWGItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1266;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class TechnodemonEntity
extends HWGEntity
implements IAnimatable {
    private final RangedAttackGoal<TechnodemonEntity> bowAttackGoal = new RangedAttackGoal<TechnodemonEntity>(this, 1.0, 20, 15.0f);
    private final class_1366 meleeAttackGoal = new class_1366(this, 1.2, false){

        public void method_6270() {
            super.method_6270();
            TechnodemonEntity.this.method_19540(false);
        }

        public void method_6269() {
            super.method_6269();
            TechnodemonEntity.this.method_19540(true);
        }
    };
    private static final class_2940<Boolean> SHOOTING = class_2945.method_12791(TechnodemonEntity.class, (class_2941)class_2943.field_13323);
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public TechnodemonEntity(class_1299<TechnodemonEntity> entityType, class_1937 worldIn) {
        super(entityType, worldIn);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving() && !this.method_5681() && !((Boolean)this.field_6011.method_12789(SHOOTING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (this.method_6510() && !this.field_6272 && !((double)this.method_6032() < 0.01) && !this.method_29504()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    public void registerControllers(AnimationData data) {
        data.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public static boolean canSpawn(class_1299<? extends HWGEntity> type, class_1936 world, class_3730 spawnReason, class_2338 pos, Random random) {
        return world.method_8407() != class_1267.field_5801;
    }

    protected void method_5959() {
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(9, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(5, (class_1352)new class_1394((class_1314)this, 0.8));
        this.field_6185.method_6277(2, (class_1352)new class_1399((class_1314)this, new Class[0]).method_6318(new Class[0]));
        this.field_6185.method_6277(2, (class_1352)new class_1400((class_1308)this, class_1657.class, true));
    }

    @Environment(value=EnvType.CLIENT)
    public boolean isShooting() {
        return (Boolean)this.field_6011.method_12789(SHOOTING);
    }

    @Override
    public void setShooting(boolean shooting) {
        this.field_6011.method_12778(SHOOTING, (Object)shooting);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(SHOOTING, (Object)false);
        this.field_6011.method_12784(VARIANT, (Object)0);
    }

    @Override
    public void method_5749(class_2487 tag) {
        super.method_5749(tag);
        this.updateAttackType();
        this.setVariant(tag.method_10550("Variant"));
    }

    public void method_5673(class_1304 slot, class_1799 stack) {
        super.method_5673(slot, stack);
        if (!this.field_6002.field_9236) {
            this.updateAttackType();
        }
    }

    public void updateAttackType() {
        if (this.field_6002 != null && !this.field_6002.field_9236) {
            this.field_6201.method_6280((class_1352)this.meleeAttackGoal);
            this.field_6201.method_6280(this.bowAttackGoal);
            class_1799 itemStack = this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)this.method_6118(class_1304.field_6173).method_7909()));
            if (itemStack.method_7909() == this.method_6118(class_1304.field_6173).method_7909()) {
                int i = 20;
                if (this.field_6002.method_8407() != class_1267.field_5807) {
                    i = 40;
                }
                this.bowAttackGoal.setAttackInterval(i);
                this.field_6201.method_6277(4, this.bowAttackGoal);
            } else {
                this.field_6201.method_6277(4, (class_1352)this.meleeAttackGoal);
            }
        }
    }

    protected BulletEntity createArrowProjectile(class_1799 arrow, float damageModifier) {
        return TechnodemonEntity.createArrowProjectile((class_1309)this, arrow, damageModifier);
    }

    public boolean canUseRangedWeapon(class_1792 weapon) {
        return weapon == this.method_6118(class_1304.field_6173).method_7909();
    }

    public static BulletEntity createArrowProjectile(class_1309 entity, class_1799 stack, float damageModifier) {
        BulletAmmo arrowItem = stack.method_7909() instanceof BulletAmmo ? stack.method_7909() : HWGItems.BULLETS;
        BulletEntity persistentProjectileEntity = arrowItem.createArrow(entity.field_6002, stack, entity);
        persistentProjectileEntity.method_7435(entity, damageModifier);
        return persistentProjectileEntity;
    }

    @Override
    public void method_5652(class_2487 tag) {
        super.method_5652(tag);
        tag.method_10569("Variant", this.getVariant());
    }

    public int getVariant() {
        return class_3532.method_15340((int)((Integer)this.field_6011.method_12789(VARIANT)), (int)1, (int)4);
    }

    public static class_5132.class_5133 createMobAttributes() {
        return class_1309.method_26827().method_26868(class_5134.field_23717, 50.0).method_26868(class_5134.field_23719, 0.25).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23716, TechnodemonEntity.config.lesser_health).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_23722, 1.0);
    }

    protected boolean shouldDrown() {
        return false;
    }

    protected boolean shouldBurnInDay() {
        return false;
    }

    protected float method_18394(class_4050 pose, class_4048 dimensions) {
        return 2.25f;
    }

    @Override
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, class_1315 entityData, class_2487 entityTag) {
        this.setVariant(this.field_5974.nextInt(5));
        this.method_5673(class_1304.field_6173, this.makeInitialWeapon());
        this.updateAttackType();
        return super.method_5943(world, difficulty, spawnReason, entityData, entityTag);
    }

    private class_1799 makeInitialWeapon() {
        Random rand = new Random();
        List<class_1935> givenList = Arrays.asList(new class_1935[]{HWGItems.HELLHORSE, HWGItems.FLAMETHROWER, HWGItems.BRIMSTONE});
        int randomIndex = rand.nextInt(givenList.size());
        class_1935 randomElement = givenList.get(randomIndex);
        return new class_1799(randomElement);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        class_1665 abstractarrowentity;
        class_1799 itemStack = this.method_18808(this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)this.method_6118(class_1304.field_6173).method_7909())));
        if (this.method_6118(class_1304.field_6173).method_7909() instanceof HellhorseRevolverItem) {
            BulletEntity projectile = this.createArrowProjectile(itemStack, pullProgress);
            double d = target.method_23317() - this.method_23317();
            double e = target.method_23323(0.3333333333333333) - projectile.method_23318();
            double f = target.method_23321() - this.method_23321();
            double g = class_3532.method_15368((double)(d * d + f * f));
            projectile.method_7485(d, e + g * (double)0.05f, f, 1.6f, 0.0f);
            this.field_6002.method_8649((class_1297)projectile);
        }
        if (this.method_6118(class_1304.field_6173).method_7909() instanceof FlamethrowerItem) {
            abstractarrowentity = this.createFlame(this.field_6002, itemStack, (class_1309)this);
            abstractarrowentity.method_24919((class_1297)this, this.field_5965, this.field_6031, 0.0f, 0.75f, 2.0f);
            abstractarrowentity.method_5808(this.method_23317(), this.method_23323(0.5), this.method_23321(), 0.0f, 0.0f);
            abstractarrowentity.field_6012 = 30;
            this.field_6002.method_8649((class_1297)abstractarrowentity);
            FlameFiring abstractarrowentity1 = this.createFlame(this.field_6002, itemStack, (class_1309)this);
            abstractarrowentity1.method_24919((class_1297)this, this.field_5965, this.field_6031 + 10.0f, 0.0f, 0.75f, 2.0f);
            abstractarrowentity1.method_5808(this.method_23317(), this.method_23323(0.5), this.method_23321(), 0.0f, 0.0f);
            abstractarrowentity1.field_6012 = 30;
            this.field_6002.method_8649((class_1297)abstractarrowentity1);
            FlameFiring abstractarrowentity3 = this.createFlame(this.field_6002, itemStack, (class_1309)this);
            abstractarrowentity3.method_24919((class_1297)this, this.field_5965, this.field_6031 + 5.0f, 0.0f, 0.75f, 2.0f);
            abstractarrowentity3.method_5808(this.method_23317(), this.method_23323(0.5), this.method_23321(), 0.0f, 0.0f);
            abstractarrowentity3.field_6012 = 30;
            this.field_6002.method_8649((class_1297)abstractarrowentity3);
            FlameFiring abstractarrowentity2 = this.createFlame(this.field_6002, itemStack, (class_1309)this);
            abstractarrowentity2.method_24919((class_1297)this, this.field_5965, this.field_6031 - 10.0f, 0.0f, 0.75f, 2.0f);
            abstractarrowentity2.method_5808(this.method_23317(), this.method_23323(0.5), this.method_23321(), 0.0f, 0.0f);
            abstractarrowentity2.field_6012 = 30;
            this.field_6002.method_8649((class_1297)abstractarrowentity2);
            FlameFiring abstractarrowentity4 = this.createFlame(this.field_6002, itemStack, (class_1309)this);
            abstractarrowentity4.method_24919((class_1297)this, this.field_5965, this.field_6031 - 5.0f, 0.0f, 0.75f, 2.0f);
            abstractarrowentity4.method_5808(this.method_23317(), this.method_23323(0.5), this.method_23321(), 0.0f, 0.0f);
            abstractarrowentity4.field_6012 = 30;
            this.field_6002.method_8649((class_1297)abstractarrowentity4);
        }
        if (this.method_6118(class_1304.field_6173).method_7909() instanceof BrimstoneItem) {
            abstractarrowentity = this.createArrow(this.field_6002, itemStack, (class_1309)this);
            abstractarrowentity.method_24919((class_1297)this, this.field_5965, this.field_6031, 0.0f, 0.75f, 1.0f);
            abstractarrowentity.method_5808(this.method_23317(), this.method_23323(0.5), this.method_23321(), 0.0f, 0.0f);
            abstractarrowentity.method_20803(100);
            abstractarrowentity.method_7438(6.5);
            abstractarrowentity.method_7449(1);
            FireballEntity abstractarrowentity1 = this.createArrow(this.field_6002, itemStack, (class_1309)this);
            abstractarrowentity1.method_24919((class_1297)this, this.field_5965, this.field_6031 + 5.0f, 0.0f, 0.75f, 1.0f);
            abstractarrowentity1.method_5808(this.method_23317(), this.method_23323(0.5), this.method_23321(), 0.0f, 0.0f);
            abstractarrowentity1.method_20803(100);
            abstractarrowentity1.method_7438(6.5);
            abstractarrowentity1.method_7449(1);
            FireballEntity abstractarrowentity2 = this.createArrow(this.field_6002, itemStack, (class_1309)this);
            abstractarrowentity2.method_24919((class_1297)this, this.field_5965, this.field_6031 - 5.0f, 0.0f, 0.75f, 1.0f);
            abstractarrowentity2.method_5808(this.method_23317(), this.method_23323(0.5), this.method_23321(), 0.0f, 0.0f);
            abstractarrowentity2.method_20803(100);
            abstractarrowentity2.method_7438(6.5);
            abstractarrowentity2.method_7449(1);
            this.field_6002.method_8649((class_1297)abstractarrowentity);
            this.field_6002.method_8649((class_1297)abstractarrowentity1);
            this.field_6002.method_8649((class_1297)abstractarrowentity2);
        }
    }

    public FlameFiring createFlame(class_1937 worldIn, class_1799 stack, class_1309 shooter) {
        FlameFiring arrowentity = new FlameFiring(worldIn, shooter);
        return arrowentity;
    }

    public FireballEntity createArrow(class_1937 worldIn, class_1799 stack, class_1309 shooter) {
        FireballEntity arrowentity = new FireballEntity(worldIn, shooter);
        return arrowentity;
    }

    public int method_5945() {
        return 1;
    }

    public void setVariant(int variant) {
        this.field_6011.method_12778(VARIANT, (Object)variant);
    }

    @Override
    public int getVariants() {
        return 4;
    }

    protected class_3414 getStepSound() {
        return class_3417.field_14621;
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        this.method_5783(this.getStepSound(), 0.15f, 1.0f);
    }

    public class_1310 method_6046() {
        return class_1310.field_6289;
    }
}

