/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.item.weapons;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import mod.azure.hwg.HWGMod;
import mod.azure.hwg.entity.projectiles.launcher.EMPGEntity;
import mod.azure.hwg.entity.projectiles.launcher.FragGEntity;
import mod.azure.hwg.entity.projectiles.launcher.NapalmGEntity;
import mod.azure.hwg.entity.projectiles.launcher.SmokeGEntity;
import mod.azure.hwg.entity.projectiles.launcher.StunGEntity;
import mod.azure.hwg.item.ammo.GrenadeEmpItem;
import mod.azure.hwg.item.weapons.HWGGunLoadedBase;
import mod.azure.hwg.util.registry.HWGItems;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1158;
import net.minecraft.class_1160;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1834;
import net.minecraft.class_1836;
import net.minecraft.class_1839;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class GrenadeLauncherItem
extends HWGGunLoadedBase {
    private boolean charged = false;
    private boolean loaded = false;
    public static final Predicate<class_1799> EMP = stack -> stack.method_7909() == HWGItems.G_EMP;
    public static final Predicate<class_1799> GRENADES = EMP.or(stack -> stack.method_7909() == HWGItems.G_FRAG).or(stack -> stack.method_7909() == HWGItems.G_NAPALM).or(stack -> stack.method_7909() == HWGItems.G_SMOKE).or(stack -> stack.method_7909() == HWGItems.G_STUN);

    public GrenadeLauncherItem() {
        super(new class_1792.class_1793().method_7892(HWGMod.WeaponItemGroup).method_7889(1).method_7895(31));
    }

    public boolean method_7870(class_1799 stack) {
        return false;
    }

    public Predicate<class_1799> method_20310() {
        return GRENADES;
    }

    public Predicate<class_1799> method_19268() {
        return GRENADES;
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return class_1834.field_8923.method_8023().method_8093(ingredient) || super.method_7878(stack, ingredient);
    }

    private static void shoot(class_1937 world, class_1309 shooter, class_1268 hand, class_1799 stack, class_1799 projectile, float soundPitch, boolean creative, float speed, float divergence, float simulated) {
        if (!world.field_9236) {
            boolean b4;
            boolean bl = projectile.method_7909() == HWGItems.G_EMP;
            boolean b2 = projectile.method_7909() == HWGItems.G_FRAG;
            boolean b3 = projectile.method_7909() == HWGItems.G_NAPALM;
            boolean bl2 = b4 = projectile.method_7909() == HWGItems.G_STUN;
            class_1665 projectileEntity2 = bl ? new EMPGEntity(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true) : (b2 ? new FragGEntity(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true) : (b3 ? new NapalmGEntity(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true) : (b4 ? new StunGEntity(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true) : new SmokeGEntity(world, projectile, (class_1297)shooter, shooter.method_23317(), shooter.method_23320() - (double)0.15f, shooter.method_23321(), true))));
            class_243 vec3d = shooter.method_18864(1.0f);
            class_1158 quaternion = new class_1158(new class_1160(vec3d), simulated, true);
            class_243 vec3d2 = shooter.method_5828(1.0f);
            class_1160 vector3f = new class_1160(vec3d2);
            vector3f.method_19262(quaternion);
            ((class_1665)projectileEntity2).method_7485((double)vector3f.method_4943(), (double)vector3f.method_4945(), (double)vector3f.method_4947(), speed, divergence);
            stack.method_7956(1, shooter, p -> p.method_20236(shooter.method_6058()));
            world.method_8649((class_1297)projectileEntity2);
            world.method_8465((class_1657)null, shooter.method_23317(), shooter.method_23318(), shooter.method_23321(), class_3417.field_15152, class_3419.field_15248, 1.0f, soundPitch);
        }
    }

    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8949;
    }

    public int method_24792() {
        return 16;
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 itemStack = user.method_5998(hand);
        if (GrenadeLauncherItem.isCharged(itemStack) && itemStack.method_7919() < itemStack.method_7936() - 1 && !user.method_7357().method_7904((class_1792)this)) {
            GrenadeLauncherItem.shootAll(world, (class_1309)user, hand, itemStack, GrenadeLauncherItem.getSpeed(itemStack), 1.0f);
            user.method_7357().method_7906((class_1792)this, 25);
            GrenadeLauncherItem.setCharged(itemStack, false);
            return class_1271.method_22428((Object)itemStack);
        }
        if (!user.method_18808(itemStack).method_7960()) {
            if (!GrenadeLauncherItem.isCharged(itemStack)) {
                this.charged = false;
                this.loaded = false;
                user.method_6019(hand);
            }
            return class_1271.method_22428((Object)itemStack);
        }
        return class_1271.method_22431((Object)itemStack);
    }

    public void method_7840(class_1799 stack, class_1937 world, class_1309 user, int remainingUseTicks) {
        if (!GrenadeLauncherItem.isCharged(stack) && GrenadeLauncherItem.loadProjectiles(user, stack)) {
            GrenadeLauncherItem.setCharged(stack, true);
            class_3419 soundCategory = user instanceof class_1657 ? class_3419.field_15248 : class_3419.field_15251;
            world.method_8465((class_1657)null, user.method_23317(), user.method_23318(), user.method_23321(), class_3417.field_14787, soundCategory, 1.0f, 0.5f);
        }
    }

    private static boolean loadProjectiles(class_1309 shooter, class_1799 projectile) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9108, (class_1799)projectile);
        int j = i == 0 ? 1 : 3;
        boolean bl = shooter instanceof class_1657 && ((class_1657)shooter).field_7503.field_7477;
        class_1799 itemStack = shooter.method_18808(projectile);
        class_1799 itemStack2 = itemStack.method_7972();
        for (int k = 0; k < j; ++k) {
            if (k > 0) {
                itemStack = itemStack2.method_7972();
            }
            if (itemStack.method_7960() && bl) {
                itemStack = new class_1799((class_1935)HWGItems.G_SMOKE);
                itemStack2 = itemStack.method_7972();
            }
            if (GrenadeLauncherItem.loadProjectile(shooter, projectile, itemStack, k > 0, bl)) continue;
            return false;
        }
        return true;
    }

    private static boolean loadProjectile(class_1309 shooter, class_1799 crossbow, class_1799 projectile, boolean simulated, boolean creative) {
        class_1799 itemStack2;
        boolean bl;
        if (projectile.method_7960()) {
            return false;
        }
        boolean bl2 = bl = creative && projectile.method_7909() instanceof GrenadeEmpItem;
        if (!(bl || creative || simulated)) {
            itemStack2 = projectile.method_7971(1);
            if (projectile.method_7960() && shooter instanceof class_1657) {
                ((class_1657)shooter).field_7514.method_7378(projectile);
            }
        } else {
            itemStack2 = projectile.method_7972();
        }
        GrenadeLauncherItem.putProjectile(crossbow, itemStack2);
        return true;
    }

    public static boolean isCharged(class_1799 stack) {
        class_2487 compoundTag = stack.method_7969();
        return compoundTag != null && compoundTag.method_10577("Charged");
    }

    public static void setCharged(class_1799 stack, boolean charged) {
        class_2487 compoundTag = stack.method_7948();
        compoundTag.method_10556("Charged", charged);
    }

    private static void putProjectile(class_1799 crossbow, class_1799 projectile) {
        class_2487 compoundTag = crossbow.method_7948();
        class_2499 listTag2 = compoundTag.method_10573("ChargedProjectiles", 9) ? compoundTag.method_10554("ChargedProjectiles", 10) : new class_2499();
        class_2487 compoundTag2 = new class_2487();
        projectile.method_7953(compoundTag2);
        listTag2.add((Object)compoundTag2);
        compoundTag.method_10566("ChargedProjectiles", (class_2520)listTag2);
    }

    private static List<class_1799> getProjectiles(class_1799 crossbow) {
        class_2499 listTag;
        ArrayList list = Lists.newArrayList();
        class_2487 compoundTag = crossbow.method_7969();
        if (compoundTag != null && compoundTag.method_10573("ChargedProjectiles", 9) && (listTag = compoundTag.method_10554("ChargedProjectiles", 10)) != null) {
            for (int i = 0; i < listTag.size(); ++i) {
                class_2487 compoundTag2 = listTag.method_10602(i);
                list.add(class_1799.method_7915((class_2487)compoundTag2));
            }
        }
        return list;
    }

    private static void clearProjectiles(class_1799 crossbow) {
        class_2487 compoundTag = crossbow.method_7969();
        if (compoundTag != null) {
            class_2499 listTag = compoundTag.method_10554("ChargedProjectiles", 9);
            listTag.clear();
            compoundTag.method_10566("ChargedProjectiles", (class_2520)listTag);
        }
    }

    public static boolean hasProjectile(class_1799 crossbow, class_1792 projectile) {
        return GrenadeLauncherItem.getProjectiles(crossbow).stream().anyMatch(s -> s.method_7909() == projectile);
    }

    public static void shootAll(class_1937 world, class_1309 entity, class_1268 hand, class_1799 stack, float speed, float divergence) {
        List<class_1799> list = GrenadeLauncherItem.getProjectiles(stack);
        float[] fs = GrenadeLauncherItem.getSoundPitches(entity.method_6051());
        for (int i = 0; i < list.size(); ++i) {
            boolean bl;
            class_1799 itemStack = list.get(i);
            boolean bl2 = bl = entity instanceof class_1657 && ((class_1657)entity).field_7503.field_7477;
            if (itemStack.method_7960()) continue;
            if (i == 0) {
                GrenadeLauncherItem.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 0.0f);
                continue;
            }
            if (i == 1) {
                GrenadeLauncherItem.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, -10.0f);
                continue;
            }
            if (i != 2) continue;
            GrenadeLauncherItem.shoot(world, entity, hand, stack, itemStack, fs[i], bl, speed, divergence, 10.0f);
        }
        GrenadeLauncherItem.postShoot(world, entity, stack);
    }

    private static float[] getSoundPitches(Random random) {
        boolean bl = random.nextBoolean();
        return new float[]{1.0f, GrenadeLauncherItem.getSoundPitch(bl), GrenadeLauncherItem.getSoundPitch(!bl)};
    }

    private static float getSoundPitch(boolean flag) {
        float f = flag ? 0.63f : 0.43f;
        return 1.0f / (field_8005.nextFloat() * 0.5f + 1.8f) + f;
    }

    private static void postShoot(class_1937 world, class_1309 entity, class_1799 stack) {
        GrenadeLauncherItem.clearProjectiles(stack);
    }

    public void method_7852(class_1937 world, class_1309 user, class_1799 stack, int remainingUseTicks) {
        if (!world.field_9236) {
            float f = (float)(stack.method_7935() - remainingUseTicks) / (float)GrenadeLauncherItem.getPullTime(stack);
            if (f < 0.2f) {
                this.charged = false;
                this.loaded = false;
            }
            if (f >= 0.2f && !this.charged) {
                this.charged = true;
            }
            if (f >= 0.5f && !this.loaded) {
                this.loaded = true;
            }
        }
    }

    public int method_7881(class_1799 stack) {
        return GrenadeLauncherItem.getPullTime(stack) + 3000;
    }

    public static int getPullTime(class_1799 stack) {
        int i = class_1890.method_8225((class_1887)class_1893.field_9098, (class_1799)stack);
        return 25 - 5 * i;
    }

    @Environment(value=EnvType.CLIENT)
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        List<class_1799> list = GrenadeLauncherItem.getProjectiles(stack);
        if (GrenadeLauncherItem.isCharged(stack) && !list.isEmpty()) {
            class_1799 itemStack = list.get(0);
            tooltip.add((class_2561)new class_2588("Ammo").method_27693(" ").method_10852(itemStack.method_7954()));
            if (context.method_8035() && itemStack.method_7909() == GRENADES) {
                ArrayList list2 = Lists.newArrayList();
                HWGItems.G_EMP.method_7851(itemStack, world, list2, context);
                if (!list2.isEmpty()) {
                    for (int i = 0; i < list2.size(); ++i) {
                        list2.set(i, new class_2585("  ").method_10852((class_2561)list2.get(i)).method_27692(class_124.field_1080));
                    }
                    tooltip.addAll(list2);
                }
            }
        }
    }

    private static float getSpeed(class_1799 stack) {
        return stack.method_7909() == class_1802.field_8399 && GrenadeLauncherItem.hasProjectile(stack, class_1802.field_8639) ? 1.6f : 3.15f;
    }
}

