/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.recipe;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import mod.azure.hwg.HWGMod;
import mod.azure.hwg.client.gui.GunTableInventory;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1869;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_3956;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;

public class GunTableRecipe
implements class_1860<GunTableInventory>,
Comparable<GunTableRecipe> {
    public static final class_3956<GunTableRecipe> GUN_TABLE = class_3956.method_17726((String)new class_2960("hwg", "gun_table").toString());
    private final class_2960 id;
    private final Pair<class_1856, Integer>[] ingredients;
    private final class_1799 output;

    public GunTableRecipe(class_2960 id, Pair<class_1856, Integer>[] ingredients, class_1799 output) {
        this.id = id;
        this.ingredients = ingredients;
        this.output = output;
    }

    public boolean matches(GunTableInventory inv, class_1937 world) {
        for (int i = 0; i < 5; ++i) {
            class_1799 slotStack = inv.method_5438(i);
            Pair<class_1856, Integer> pair = this.ingredients[i];
            class_1856 ingredient = (class_1856)pair.getLeft();
            int count = (Integer)pair.getRight();
            if (slotStack.method_7947() >= count && ingredient.method_8093(slotStack)) continue;
            return false;
        }
        return true;
    }

    public class_1856 getIngredientForSlot(int index) {
        return (class_1856)this.ingredients[index].getLeft();
    }

    public int countRequired(int index) {
        return (Integer)this.ingredients[index].getRight();
    }

    public class_1799 craft(GunTableInventory inv) {
        return this.method_8110().method_7972();
    }

    public boolean method_8113(int width, int height) {
        return true;
    }

    public class_1799 method_8110() {
        return this.output;
    }

    public class_2960 method_8114() {
        return this.id;
    }

    public class_1865<?> method_8119() {
        return HWGMod.GUN_TABLE_RECIPE_SERIALIZER;
    }

    public class_3956<?> method_17716() {
        return GUN_TABLE;
    }

    @Override
    public int compareTo(@NotNull GunTableRecipe o) {
        class_1792 outputThis = this.method_8110().method_7909();
        class_1792 outputOther = o.method_8110().method_7909();
        return class_2378.field_11142.method_10221((Object)outputThis).method_12833(class_2378.field_11142.method_10221((Object)outputOther));
    }

    public static class Serializer
    implements class_1865<GunTableRecipe> {
        public GunTableRecipe read(class_2960 identifier, JsonObject jsonObject) {
            Map<String, Pair<class_1856, Integer>> map;
            String pattern = class_3518.method_15265((JsonObject)jsonObject, (String)"pattern");
            List<Pair<class_1856, Integer>> pairList = Serializer.getIngredients(pattern, map = Serializer.getComponents(class_3518.method_15296((JsonObject)jsonObject, (String)"key")), pattern.length());
            if (pairList.isEmpty()) {
                throw new JsonParseException("No ingredients for gun table recipe");
            }
            if (pairList.size() > 5) {
                throw new JsonParseException("Too many ingredients for gun table recipe");
            }
            class_1799 itemStack = class_1869.method_8155((JsonObject)class_3518.method_15296((JsonObject)jsonObject, (String)"result"));
            return new GunTableRecipe(identifier, pairList.toArray(new Pair[0]), itemStack);
        }

        private static List<Pair<class_1856, Integer>> getIngredients(String pattern, Map<String, Pair<class_1856, Integer>> keys, int width) {
            ArrayList<Pair<class_1856, Integer>> pairList = new ArrayList<Pair<class_1856, Integer>>();
            for (int i = 0; i < 5; ++i) {
                pairList.add(Pair.of((Object)class_1856.field_9017, (Object)0));
            }
            HashSet set = Sets.newHashSet(keys.keySet());
            set.remove(" ");
            for (int i = 0; i < pattern.length(); ++i) {
                String key = pattern.substring(i, i + 1);
                class_1856 ingredient = (class_1856)keys.get(key).getKey();
                if (ingredient == null) {
                    throw new JsonSyntaxException("Pattern references symbol '" + key + "' but it's not defined in the key");
                }
                set.remove(key);
                pairList.set(i, (Pair<class_1856, Integer>)Pair.of((Object)ingredient, (Object)keys.get(key).getRight()));
            }
            if (!set.isEmpty()) {
                throw new JsonSyntaxException("Key defines symbols that aren't used in pattern: " + set);
            }
            return pairList;
        }

        public GunTableRecipe read(class_2960 identifier, class_2540 packetByteBuf) {
            Pair[] pairs = new Pair[5];
            for (int j = 0; j < 5; ++j) {
                class_1856 ingredient = class_1856.method_8086((class_2540)packetByteBuf);
                int count = packetByteBuf.readInt();
                pairs[j] = Pair.of((Object)ingredient, (Object)count);
            }
            class_1799 output = packetByteBuf.method_10819();
            return new GunTableRecipe(identifier, pairs, output);
        }

        public void write(class_2540 packetByteBuf, GunTableRecipe gunTableRecipe) {
            for (int i = 0; i < 5; ++i) {
                Pair pair = gunTableRecipe.ingredients[i];
                class_1856 ingredient = (class_1856)pair.getLeft();
                int count = (Integer)pair.getRight();
                ingredient.method_8088(packetByteBuf);
                packetByteBuf.writeInt(count);
            }
            packetByteBuf.method_10793(gunTableRecipe.output);
        }

        private static Map<String, Pair<class_1856, Integer>> getComponents(JsonObject json) {
            HashMap map = Maps.newHashMap();
            for (Map.Entry entry : json.entrySet()) {
                String key = (String)entry.getKey();
                JsonElement jsonElement = (JsonElement)entry.getValue();
                if (key.length() != 1) {
                    throw new JsonSyntaxException("Invalid key entry: '" + (String)entry.getKey() + "' is an invalid symbol (must be 1 String only).");
                }
                if (" ".equals(key)) {
                    throw new JsonSyntaxException("Invalid key entry: ' ' is a reserved symbol.");
                }
                map.put(key, Pair.of((Object)class_1856.method_8102((JsonElement)jsonElement), (Object)class_3518.method_15282((JsonObject)jsonElement.getAsJsonObject(), (String)"count", (int)1)));
            }
            map.put(" ", Pair.of((Object)class_1856.field_9017, (Object)0));
            return map;
        }
    }
}

