/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.hwg.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import mod.azure.hwg.util.registry.HWGItems;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class HWGEquipmentUtils {
    public static String TAG = "hwgguntag";

    public static boolean ruinedItemHasEnchantment(class_1799 ruinedItem, class_1887 enchantment) {
        if (ruinedItem.method_7969() == null) {
            return false;
        }
        String tagString = ruinedItem.method_7969().method_10558(TAG);
        Map<class_1887, Integer> enchantMap = HWGEquipmentUtils.processEncodedEnchantments(tagString);
        if (enchantMap == null) {
            return false;
        }
        for (class_1887 e : enchantMap.keySet()) {
            if (e != enchantment) continue;
            return true;
        }
        return false;
    }

    public static int compareItemsById(class_1792 i1, class_1792 i2) {
        return class_2378.field_11142.method_10221((Object)i1).method_12833(class_2378.field_11142.method_10221((Object)i2));
    }

    public static int generateRepairLevelCost(class_1799 repaired, int maxLevel) {
        int targetLevel = maxLevel * (repaired.method_7936() - repaired.method_7919()) / repaired.method_7936();
        return Math.max(targetLevel, 1);
    }

    public static class_1799 generateRepairedItemForAnvilByFraction(class_1799 leftStack, double damageFraction) {
        int maxDamage = new class_1799((class_1935)HWGItems.getItemMap().get(leftStack.method_7909())).method_7936();
        return HWGEquipmentUtils.generateRepairedItemForAnvilByDamage(leftStack, (int)(damageFraction * (double)maxDamage));
    }

    public static class_1799 generateRepairedItemForAnvilByDamage(class_1799 leftStack, int targetDamage) {
        Map<class_1887, Integer> enchantMap;
        class_1799 repaired = new class_1799((class_1935)HWGItems.getItemMap().get(leftStack.method_7909()));
        class_2487 tag = leftStack.method_7948();
        String encodedEnch = tag.method_10558(TAG);
        if (!encodedEnch.isEmpty()) {
            tag.method_10551(TAG);
        }
        if ((enchantMap = HWGEquipmentUtils.processEncodedEnchantments(encodedEnch)) != null) {
            for (Map.Entry<class_1887, Integer> enchant : enchantMap.entrySet()) {
                repaired.method_7978(enchant.getKey(), enchant.getValue().intValue());
            }
        }
        repaired.method_7980(repaired.method_7948().method_10543(tag));
        repaired.method_7974(targetDamage);
        return repaired;
    }

    public static Map<class_1887, Integer> processEncodedEnchantments(String encodedEnchants) {
        if (encodedEnchants.isEmpty()) {
            return null;
        }
        HashMap<class_1887, Integer> enchants = new HashMap<class_1887, Integer>();
        for (String encodedEnchant : encodedEnchants.split(",")) {
            String[] enchantItem = encodedEnchant.split(">");
            String[] enchantKey = enchantItem[0].split(":");
            int enchantLevel = Integer.parseInt(enchantItem[1]);
            enchants.put((class_1887)class_2378.field_11160.method_10223(new class_2960(enchantKey[0], enchantKey[1])), enchantLevel);
        }
        return enchants.isEmpty() ? null : enchants;
    }

    public static void onSendEquipmentBreakStatusImpl(class_3222 serverPlayer, class_1799 breakingStack, boolean forceSet) {
        for (Map.Entry<class_1792, class_1792> itemMap : HWGItems.getItemMap().entrySet()) {
            class_2487 enchantTag;
            if (!HWGEquipmentUtils.isVanillaItemStackBreaking(breakingStack, itemMap.getValue())) continue;
            class_1799 ruinedStack = new class_1799((class_1935)itemMap.getKey());
            class_2487 breakingNBT = breakingStack.method_7948();
            if (breakingNBT.method_10545("Damage")) {
                breakingNBT.method_10551("Damage");
            }
            if (breakingNBT.method_10545("RepairCost")) {
                breakingNBT.method_10551("RepairCost");
            }
            if ((enchantTag = HWGEquipmentUtils.getTagForEnchantments(breakingStack, ruinedStack)) != null) {
                breakingNBT.method_10543(enchantTag);
            }
            if (breakingNBT.method_10545("Enchantments")) {
                breakingNBT.method_10551("Enchantments");
            }
            ruinedStack.method_7980(breakingNBT);
            serverPlayer.field_7514.method_7398(serverPlayer.field_6002, ruinedStack);
        }
    }

    public static class_2487 getTagForEnchantments(class_1799 breakingStack, class_1799 ruinedStack) {
        HashSet<String> enchantmentStrings = new HashSet<String>();
        for (Map.Entry ench : class_1890.method_8222((class_1799)breakingStack).entrySet()) {
            String enchantString = class_2378.field_11160.method_10221(ench.getKey()) + ">" + ench.getValue();
            enchantmentStrings.add(enchantString);
        }
        if (!enchantmentStrings.isEmpty()) {
            class_2487 tag = ruinedStack.method_7969();
            if (tag == null) {
                tag = new class_2487();
            }
            tag.method_10582(TAG, String.join((CharSequence)",", enchantmentStrings));
            return tag;
        }
        return null;
    }

    public static boolean isVanillaItemStackBreaking(class_1799 breakingStack, class_1792 vanillaItem) {
        return breakingStack.method_7962(new class_1799((class_1935)vanillaItem)) && breakingStack.method_7936() - breakingStack.method_7919() <= 0;
    }
}

