/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.inventoryspam;

import com.google.common.collect.Lists;
import gigaherz.inventoryspam.ContainerWrapper;
import gigaherz.inventoryspam.config.Config;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ContainerPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ScrollingOverlay
extends GuiScreen {
    private static final int TTL = 240;
    private static final int FADE = 40;
    private int hard_limit;
    private RenderItem renderItem;
    private int dim;
    private int dimLoadTicks;
    private ItemStack[] previous;
    private EntityPlayer playerEntity;
    private ItemStack previousInCursor = ItemStack.field_190927_a;
    private final List<ChangeInfo> changeEntries = Lists.newArrayList();

    public static void init() {
        MinecraftForge.EVENT_BUS.register((Object)new ScrollingOverlay());
    }

    private ScrollingOverlay() {
        this.renderItem = Minecraft.func_71410_x().func_175599_af();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        int align;
        int y;
        int x;
        int number;
        int rectWidth;
        if (!Config.showItemAdditions && !Config.showItemRemovals) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.CHAT) {
            return;
        }
        ScaledResolution resolution = event.getResolution();
        int width = resolution.func_78326_a();
        int height = resolution.func_78328_b();
        width = (int)((double)width / Config.drawScale);
        height = (int)((double)height / Config.drawScale);
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        int iconSize = (int)(16.0 * Config.iconScale);
        int rightMargin = Config.drawIcon ? 2 + iconSize : 0;
        int topMargin1 = 2 + (Config.drawIcon ? Math.max(0, (iconSize - font.field_78288_b) / 2) : 0);
        int topMargin2 = 1 + Math.max(0, -(iconSize - font.field_78288_b) / 2);
        int lineHeight = font.field_78288_b;
        if (Config.drawIcon) {
            lineHeight = Math.max(2 + iconSize, lineHeight);
        }
        this.hard_limit = height / lineHeight;
        ArrayList computedStrings = Lists.newArrayList();
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            if (this.changeEntries.size() == 0) {
                return;
            }
            rectWidth = this.computeStrings(computedStrings, font);
            number = computedStrings.size();
            if (number == 0) {
                return;
            }
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179139_a((double)Config.drawScale, (double)Config.drawScale, (double)1.0);
        rectWidth += rightMargin;
        int rectHeight = lineHeight * number;
        switch (Config.drawPosition) {
            default: {
                x = width - 2 - rectWidth - Config.drawOffsetHorizontal;
                y = height - 2 - rectHeight - Config.drawOffsetVertical;
                align = 1;
                break;
            }
            case Bottom: {
                x = (width - rectWidth) / 2 - 2 + Config.drawOffsetHorizontal;
                y = height - 2 - rectHeight - Config.drawOffsetVertical;
                align = 0;
                break;
            }
            case BottomLeft: {
                x = 2 + Config.drawOffsetHorizontal;
                y = height - 2 - rectHeight - Config.drawOffsetVertical;
                align = -1;
                break;
            }
            case Left: {
                x = 2 + Config.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + Config.drawOffsetVertical;
                align = -1;
                break;
            }
            case TopLeft: {
                x = 2 + Config.drawOffsetHorizontal;
                y = 2 + Config.drawOffsetVertical;
                align = -1;
                break;
            }
            case Top: {
                x = (width - rectWidth) / 2 - 2 + Config.drawOffsetHorizontal;
                y = 2 + Config.drawOffsetVertical;
                align = 0;
                break;
            }
            case TopRight: {
                x = width - 2 - rectWidth - Config.drawOffsetHorizontal;
                y = 2 + Config.drawOffsetVertical;
                align = 1;
                break;
            }
            case Right: {
                x = width - 2 - rectWidth - Config.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + Config.drawOffsetVertical;
                align = 1;
                break;
            }
            case Center: {
                x = (width - rectWidth) / 2 - 2 + Config.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + Config.drawOffsetVertical;
                align = 0;
            }
        }
        ScrollingOverlay.func_73734_a((int)(x - 2), (int)(y - 2), (int)(x + rectWidth + 4), (int)(y + rectHeight + 4), (int)Integer.MIN_VALUE);
        for (int i = 0; i < computedStrings.size(); ++i) {
            Triple e = (Triple)computedStrings.get(i);
            ChangeInfo change = (ChangeInfo)e.getLeft();
            String[] strings = (String[])e.getMiddle();
            int fade = (Integer)e.getRight();
            int w = 0;
            int[] widths = new int[strings.length];
            for (int n = 0; n < strings.length; ++n) {
                String str = strings[n];
                int wn = widths[n] = font.func_78256_a(str);
                w += wn;
            }
            int forcedFade = Config.fadeLimit > 0 ? fade * 255 / (Config.fadeLimit + 2) : 255;
            int ttlFade = change.ttl * 255 / 40;
            int alpha = Math.min(255, Math.min(forcedFade, ttlFade));
            int color = alpha << 24 | (change.mode == ChangeMode.Obtained ? 0x7FFF7F : 0xFF5F5F);
            int leftMargin = 0;
            switch (align) {
                case -1: {
                    leftMargin = 2;
                    break;
                }
                case 0: {
                    leftMargin = (rectWidth - w - rightMargin) / 2;
                    break;
                }
                case 1: {
                    leftMargin = rectWidth - w - rightMargin;
                }
            }
            GlStateManager.func_179147_l();
            int wAcc = 0;
            for (int n = 0; n < strings.length; ++n) {
                font.func_175063_a(strings[n], (float)(x + leftMargin + wAcc), (float)(y + topMargin1), color);
                wAcc += widths[n];
            }
            if (Config.drawIcon) {
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)(x + 2 + w + leftMargin), (float)(y + topMargin2), (float)0.0f);
                GlStateManager.func_179139_a((double)Config.iconScale, (double)Config.iconScale, (double)1.0);
                RenderHelper.func_74520_c();
                this.renderItem.func_180450_b(change.item.stack, 0, 0);
                this.renderItem.func_180453_a(font, change.item.stack, 0, 0, null);
                RenderHelper.func_74518_a();
                GlStateManager.func_179121_F();
            }
            y += lineHeight;
        }
        GlStateManager.func_179121_F();
    }

    private int computeStrings(List<Triple<ChangeInfo, String[], Integer>> computedStrings, FontRenderer font) {
        int rectWidth = 0;
        int itemsToShow = Math.min(Math.min(this.hard_limit, Config.softLimit + Config.fadeLimit), this.changeEntries.size());
        int offset = Math.max(0, this.changeEntries.size() - itemsToShow);
        int fadeOffset = this.changeEntries.size() - Config.softLimit - Config.fadeLimit;
        for (int i = offset; i < this.changeEntries.size(); ++i) {
            ChangeInfo change = this.changeEntries.get(i);
            String[] parts = this.getChangeStrings(change);
            int w = Arrays.stream(parts).mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).sum();
            rectWidth = Math.max(rectWidth, w);
            computedStrings.add((Triple<ChangeInfo, String[], Integer>)Triple.of((Object)change, (Object)parts, (Object)Math.min(Config.fadeLimit + 2, 1 + i - fadeOffset)));
        }
        return rectWidth;
    }

    private String[] getChangeStrings(ChangeInfo change) {
        String mode = change.mode == ChangeMode.Obtained ? "+" : "-";
        String s1 = String.format("%s%d", mode, change.count);
        if (Config.drawName) {
            String name = change.item.stack.func_82833_r();
            String italics = change.item.stack.func_82837_s() ? "" + TextFormatting.ITALIC : "";
            String s2 = String.format("%s%s", italics, name);
            return new String[]{s1, " ", s2};
        }
        return new String[]{s1};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!Config.showItemAdditions && !Config.showItemRemovals) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player == null) {
            return;
        }
        if (player != this.playerEntity) {
            if (player.field_71069_bz != null) {
                player.field_71069_bz = new ContainerWrapper((ContainerPlayer)player.field_71069_bz, (EntityPlayer)player, () -> {
                    this.previous = null;
                    this.dimLoadTicks = 0;
                });
                this.playerEntity = player;
            }
            this.previous = null;
        }
        if (player.field_71093_bK != this.dim) {
            this.previous = null;
            this.dimLoadTicks = 200;
            this.dim = player.field_71093_bK;
        }
        if (this.dimLoadTicks > 0) {
            this.previous = null;
            --this.dimLoadTicks;
            return;
        }
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            this.changeEntries.forEach(e -> --e.ttl);
            while (this.changeEntries.size() > this.hard_limit) {
                this.changeEntries.remove(0);
            }
            this.changeEntries.removeIf(e -> e.ttl <= 0 || e.count == 0);
        }
        if (this.previous == null || this.previous.length != player.field_71071_by.func_70302_i_()) {
            this.previous = new ItemStack[player.field_71071_by.func_70302_i_()];
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                this.previous[i] = ScrollingOverlay.safeCopy(player.field_71071_by.func_70301_a(i));
            }
            this.previousInCursor = player.field_71071_by.func_70445_o();
            return;
        }
        ArrayList changes = Lists.newArrayList();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack old = this.previous[i];
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (this.isChangeMeaningful(old, stack)) {
                changes.add(Pair.of((Object)old, (Object)stack));
            }
            this.previous[i] = stack.func_77946_l();
        }
        ItemStack stackInCursor = player.field_71071_by.func_70445_o();
        if (this.isChangeMeaningful(stackInCursor, this.previousInCursor)) {
            changes.add(Pair.of((Object)this.previousInCursor, (Object)stackInCursor));
        }
        this.previousInCursor = stackInCursor.func_77946_l();
        if (changes.size() == 0) {
            return;
        }
        ArrayList changeList = Lists.newArrayList();
        changes.forEach(change -> {
            boolean rightEmpty;
            ItemStack left = (ItemStack)change.getLeft();
            boolean leftEmpty = left.func_190916_E() <= 0;
            ItemStack right = (ItemStack)change.getRight();
            boolean bl = rightEmpty = right.func_190916_E() <= 0;
            if (ScrollingOverlay.areSameishItem(left, right)) {
                if (!this.isBlacklisted(left)) {
                    int difference = right.func_190916_E() - left.func_190916_E();
                    if (difference > 0) {
                        this.obtainedItem(changeList, left, difference);
                    } else if (difference < 0) {
                        this.lostItem(changeList, left, -difference);
                    }
                }
            } else {
                if (!leftEmpty && !this.isBlacklisted(left)) {
                    this.lostItem(changeList, left, left.func_190916_E());
                }
                if (!rightEmpty && !this.isBlacklisted(right)) {
                    this.obtainedItem(changeList, right, right.func_190916_E());
                }
            }
        });
        changeList.removeIf(e -> e.count == 0);
        if (changeList.size() > 0) {
            List<ChangeInfo> list2 = this.changeEntries;
            synchronized (list2) {
                for (ChangeInfo info : changeList) {
                    if (info.count == 0) continue;
                    this.accumulate(this.changeEntries, info.item.stack, info.mode, info.count, false);
                }
            }
        }
    }

    private boolean isBlacklisted(ItemStack left) {
        return Config.ignoreItems.contains(left.func_77973_b().getRegistryName().toString());
    }

    private boolean isChangeMeaningful(ItemStack a, ItemStack b) {
        if (a.func_190916_E() != b.func_190916_E()) {
            return true;
        }
        if (a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b)) {
            return false;
        }
        if (a.func_77973_b() == b.func_77973_b() && Config.ignoreSubitemChanges.contains(a.func_77973_b().getRegistryName().toString())) {
            return false;
        }
        return !ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
    }

    private static boolean areLooselyTheSame(ItemStack a, ItemStack b) {
        return a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b) || ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
    }

    private static boolean areSameishItem(ItemStack a, ItemStack b) {
        return a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b) || ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    private static boolean isStackEmpty(ItemStack stack) {
        return stack.func_190916_E() <= 0;
    }

    private static ItemStack safeCopy(ItemStack stack) {
        return stack.func_77946_l();
    }

    private void obtainedItem(List<ChangeInfo> changeList, ItemStack item, int added) {
        if (added <= 0 || !Config.showItemAdditions) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.Obtained, added, true);
    }

    private void lostItem(List<ChangeInfo> changeList, ItemStack item, int removed) {
        if (removed <= 0 || !Config.showItemRemovals) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.Lost, removed, true);
    }

    private void accumulate(List<ChangeInfo> changeList, ItemStack stack, ChangeMode mode, int count, boolean isLocal) {
        ChangeInfo info;
        if (stack.func_190916_E() <= 0) {
            return;
        }
        ComparableItem name = new ComparableItem(stack);
        ChangeInfo changeInfo = info = isLocal ? (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name)).findFirst().orElse(null) : (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name) && e.mode == mode).findFirst().orElse(null);
        if (info == null) {
            info = new ChangeInfo(name, mode, count, 240);
            changeList.add(info);
            return;
        }
        if (info.mode != mode) {
            count = -count;
        }
        info.count += count;
        info.ttl = 240;
        if (info.count < 0) {
            info.count = -info.count;
            info.mode = info.mode == ChangeMode.Lost ? ChangeMode.Obtained : ChangeMode.Lost;
        }
    }

    private static class ComparableItem {
        ItemStack stack;

        ComparableItem(ItemStack stack) {
            this.stack = stack.func_77946_l();
            this.stack.func_190920_e(1);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComparableItem)) {
                return false;
            }
            ItemStack stack = ((ComparableItem)obj).stack;
            return ScrollingOverlay.areSameishItem(stack, this.stack);
        }

        public int hashCode() {
            return this.stack.func_77973_b().hashCode() * 31 ^ this.stack.func_77960_j();
        }
    }

    private static enum ChangeMode {
        Obtained,
        Lost;

    }

    private static class ChangeInfo {
        final ComparableItem item;
        ChangeMode mode;
        int count;
        int ttl;

        ChangeInfo(ComparableItem item, ChangeMode mode, int count, int ttl) {
            this.item = item;
            this.mode = mode;
            this.count = count;
            this.ttl = ttl;
        }
    }
}

