/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.inventoryspam.config;

import com.google.common.collect.Sets;
import gigaherz.inventoryspam.config.ExponentialNumberSliderEntry;
import java.io.File;
import java.util.Arrays;
import java.util.Set;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.config.GuiConfigEntries;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod.EventBusSubscriber
public class Config {
    private static Configuration config;
    private static ConfigCategory general;
    private static ConfigCategory blacklists;
    private static Property showItemAdditionsProperty;
    private static Property showItemRemovalsProperty;
    private static Property drawIconProperty;
    private static Property drawNameProperty;
    private static Property drawOffsetVerticalProperty;
    private static Property drawOffsetHorizontalProperty;
    private static Property drawPositionProperty;
    private static Property drawScaleProperty;
    private static Property iconScaleProperty;
    private static Property softLimitProperty;
    private static Property fadeLimitProperty;
    private static Property ignoreItemsProperty;
    private static Property ignoreSubitemChangesProperty;
    public static boolean showItemAdditions;
    public static boolean showItemRemovals;
    public static boolean drawIcon;
    public static boolean drawName;
    public static int drawOffsetHorizontal;
    public static int drawOffsetVertical;
    public static DrawPosition drawPosition;
    public static double drawScale;
    public static double iconScale;
    public static int softLimit;
    public static int fadeLimit;
    public static Set<String> ignoreItems;
    public static Set<String> ignoreSubitemChanges;

    public static ConfigCategory getGeneralCategory() {
        return general;
    }

    public static ConfigCategory getBlacklistsCategory() {
        return blacklists;
    }

    public static void init(File configurationFile) {
        config = new Configuration(configurationFile);
        config.load();
        general = config.getCategory("General");
        general.setComment("General settings");
        blacklists = config.getCategory("Blacklists");
        blacklists.setComment("Item blacklists");
        showItemAdditionsProperty = config.get("General", "ShowItemAdditions", true);
        showItemRemovalsProperty = config.get("General", "ShowItemRemovals", true);
        drawIconProperty = config.get("General", "DrawIcon", true);
        drawNameProperty = config.get("General", "DrawName", true);
        drawOffsetHorizontalProperty = config.get("General", "DrawOffsetHorizontal", 0);
        drawOffsetHorizontalProperty.setMinValue(0);
        drawOffsetHorizontalProperty.setMaxValue(256);
        drawOffsetHorizontalProperty.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        drawOffsetVerticalProperty = config.get("General", "DrawOffsetVertical", 18);
        drawOffsetVerticalProperty.setMinValue(0);
        drawOffsetVerticalProperty.setMaxValue(256);
        drawOffsetVerticalProperty.setConfigEntryClass(GuiConfigEntries.NumberSliderEntry.class);
        drawPositionProperty = config.get("General", "SnapPosition", DrawPosition.BottomRight.toString());
        drawPositionProperty.setValidValues((String[])Arrays.stream(DrawPosition.values()).map(Enum::toString).toArray(String[]::new));
        drawPositionProperty.setComment("Edge/corner of the screen to use as the base location:\n  BottomRight\n  Bottom\n  BottomLeft\n  Left\n  TopLeft\n  Top\n  TopRight\n  Right\n  Center");
        drawScaleProperty = config.get("General", "DrawScaleProperty", 0.0);
        drawScaleProperty.setMinValue(-2);
        drawScaleProperty.setMaxValue(2);
        drawScaleProperty.setComment("Exponential: -2 is 1%, 2 is 10000%(100x) -- Use the ingame config gui");
        drawScaleProperty.setConfigEntryClass(ExponentialNumberSliderEntry.class);
        iconScaleProperty = config.get("General", "IconScaleProperty", -0.2);
        iconScaleProperty.setMinValue(-2);
        iconScaleProperty.setMaxValue(2);
        iconScaleProperty.setComment("Exponential: -2 is 1%, 2 is 10000%(100x) -- Use the ingame config gui");
        iconScaleProperty.setConfigEntryClass(ExponentialNumberSliderEntry.class);
        softLimitProperty = config.get("General", "SoftLimit", 6);
        softLimitProperty.setMinValue(1);
        softLimitProperty.setComment("The maximum number of items in the queue before they start fading out artificially");
        fadeLimitProperty = config.get("General", "FadeLimit", 3);
        fadeLimitProperty.setMinValue(0);
        fadeLimitProperty.setComment("The number of items that will be faded out after the soft limit is reached");
        ignoreItemsProperty = config.get("Blacklists", "IgnoreItem", new String[0]);
        ignoreItemsProperty.setComment("List of item registry names to ignore when displaying changes");
        ignoreSubitemChangesProperty = config.get("Blacklists", "IgnoreSubitemChanges", new String[0]);
        ignoreSubitemChangesProperty.setComment("List of item registry names for which to ignore subitem changes");
        Config.reload();
        if (!(!config.hasChanged() && showItemAdditionsProperty.wasRead() && showItemRemovalsProperty.wasRead() && drawIconProperty.wasRead() && drawNameProperty.wasRead() && drawOffsetHorizontalProperty.wasRead() && drawOffsetHorizontalProperty.wasRead() && drawPositionProperty.wasRead() && iconScaleProperty.wasRead() && softLimitProperty.wasRead() && fadeLimitProperty.wasRead())) {
            config.save();
        }
    }

    private static void reload() {
        showItemAdditions = showItemAdditionsProperty.getBoolean();
        showItemRemovals = showItemRemovalsProperty.getBoolean();
        drawIcon = drawIconProperty.getBoolean();
        drawName = drawNameProperty.getBoolean();
        drawOffsetHorizontal = drawOffsetHorizontalProperty.getInt();
        drawOffsetVertical = drawOffsetVerticalProperty.getInt();
        drawScale = Math.pow(10.0, drawScaleProperty.getDouble());
        iconScale = Math.pow(10.0, iconScaleProperty.getDouble());
        softLimit = softLimitProperty.getInt();
        fadeLimit = fadeLimitProperty.getInt();
        try {
            drawPosition = DrawPosition.valueOf(drawPositionProperty.getString());
        }
        catch (IllegalArgumentException ex) {
            drawPositionProperty.setToDefault();
            drawPosition = DrawPosition.valueOf(drawPositionProperty.getString());
        }
        ignoreItems = Sets.newHashSet((Object[])ignoreItemsProperty.getStringList());
        ignoreSubitemChanges = Sets.newHashSet((Object[])ignoreSubitemChangesProperty.getStringList());
    }

    @SubscribeEvent
    public static void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("inventoryspam".equals(event.getModID())) {
            if (config.hasChanged()) {
                config.save();
            }
            Config.reload();
        }
    }

    public static enum DrawPosition {
        BottomRight,
        Bottom,
        BottomLeft,
        Left,
        TopLeft,
        Top,
        TopRight,
        Right,
        Center;

    }
}

