/*
 * Decompiled with CFR 0.152.
 */
package gigaherz.inventoryspam;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.GlStateManager;
import gigaherz.inventoryspam.PlayerContainerHooks;
import gigaherz.inventoryspam.config.ConfigData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.ItemRenderer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;

public class ScrollingOverlay
extends Screen {
    private static final int TTL = 240;
    private static final int FADE = 40;
    private int hard_limit;
    private DimensionType dim;
    private int dimLoadTicks;
    private ItemStack[] previous;
    private PlayerEntity playerEntity;
    private ItemStack previousInCursor = ItemStack.field_190927_a;
    private final List<ChangeInfo> changeEntries = Lists.newArrayList();
    private final Minecraft mc = Minecraft.func_71410_x();

    public static void register() {
        MinecraftForge.EVENT_BUS.register((Object)new ScrollingOverlay());
    }

    private ScrollingOverlay() {
        super((ITextComponent)new StringTextComponent("OVERLAY"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void renderOverlay(RenderGameOverlayEvent.Post event) {
        int align;
        int y;
        int x;
        int number;
        int rectWidth;
        int n;
        int rightMargin;
        if (!ConfigData.showItemAdditions && !ConfigData.showItemRemovals) {
            return;
        }
        if (event.getType() != RenderGameOverlayEvent.ElementType.CHAT) {
            return;
        }
        int width = this.mc.field_195558_d.func_198107_o();
        int height = this.mc.field_195558_d.func_198087_p();
        width = (int)((double)width / ConfigData.drawScale);
        height = (int)((double)height / ConfigData.drawScale);
        FontRenderer fontRenderer = this.mc.field_71466_p;
        ItemRenderer itemRenderer = this.mc.func_175599_af();
        int iconSize = (int)(16.0 * ConfigData.iconScale);
        int n2 = rightMargin = ConfigData.drawIcon ? 2 + iconSize : 0;
        if (ConfigData.drawIcon) {
            fontRenderer.getClass();
            n = Math.max(0, (iconSize - 9) / 2);
        } else {
            n = 0;
        }
        int topMargin1 = 2 + n;
        fontRenderer.getClass();
        int topMargin2 = 1 + Math.max(0, -(iconSize - 9) / 2);
        fontRenderer.getClass();
        int lineHeight = 9;
        if (ConfigData.drawIcon) {
            lineHeight = Math.max(2 + iconSize, lineHeight);
        }
        this.hard_limit = height / lineHeight;
        ArrayList computedStrings = Lists.newArrayList();
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            if (this.changeEntries.size() == 0) {
                return;
            }
            rectWidth = this.computeStrings(computedStrings, fontRenderer);
            number = computedStrings.size();
            if (number == 0) {
                return;
            }
        }
        GlStateManager.pushMatrix();
        GlStateManager.scaled((double)ConfigData.drawScale, (double)ConfigData.drawScale, (double)1.0);
        rectWidth += rightMargin;
        int rectHeight = lineHeight * number;
        switch (ConfigData.drawPosition) {
            default: {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                align = 1;
                break;
            }
            case Bottom: {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                align = 0;
                break;
            }
            case BottomLeft: {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = height - 2 - rectHeight - ConfigData.drawOffsetVertical;
                align = -1;
                break;
            }
            case Left: {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                align = -1;
                break;
            }
            case TopLeft: {
                x = 2 + ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                align = -1;
                break;
            }
            case Top: {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                align = 0;
                break;
            }
            case TopRight: {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = 2 + ConfigData.drawOffsetVertical;
                align = 1;
                break;
            }
            case Right: {
                x = width - 2 - rectWidth - ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                align = 1;
                break;
            }
            case Center: {
                x = (width - rectWidth) / 2 - 2 + ConfigData.drawOffsetHorizontal;
                y = (height - rectHeight) / 2 - 2 + ConfigData.drawOffsetVertical;
                align = 0;
            }
        }
        ScrollingOverlay.fill((int)(x - 2), (int)(y - 2), (int)(x + rectWidth + 4), (int)(y + rectHeight + 4), (int)Integer.MIN_VALUE);
        for (Triple e : computedStrings) {
            ChangeInfo change = (ChangeInfo)e.getLeft();
            String[] strings = (String[])e.getMiddle();
            int fade = (Integer)e.getRight();
            int w = 0;
            int[] widths = new int[strings.length];
            for (int n3 = 0; n3 < strings.length; ++n3) {
                String str = strings[n3];
                int wn = widths[n3] = fontRenderer.func_78256_a(str);
                w += wn;
            }
            int forcedFade = ConfigData.fadeLimit > 0 ? fade * 255 / (ConfigData.fadeLimit + 2) : 255;
            int ttlFade = change.ttl * 255 / 40;
            int alpha = Math.min(255, Math.min(forcedFade, ttlFade));
            int color = alpha << 24 | (change.mode == ChangeMode.Obtained ? 0x7FFF7F : 0xFF5F5F);
            int leftMargin = 0;
            switch (align) {
                case -1: {
                    leftMargin = 2;
                    break;
                }
                case 0: {
                    leftMargin = (rectWidth - w - rightMargin) / 2;
                    break;
                }
                case 1: {
                    leftMargin = rectWidth - w - rightMargin;
                }
            }
            GlStateManager.enableBlend();
            int wAcc = 0;
            for (int n4 = 0; n4 < strings.length; ++n4) {
                fontRenderer.func_175063_a(strings[n4], (float)(x + leftMargin + wAcc), (float)(y + topMargin1), color);
                wAcc += widths[n4];
            }
            if (ConfigData.drawIcon) {
                GlStateManager.pushMatrix();
                GlStateManager.translatef((float)(x + 2 + w + leftMargin), (float)(y + topMargin2), (float)0.0f);
                GlStateManager.scaled((double)ConfigData.iconScale, (double)ConfigData.iconScale, (double)1.0);
                RenderHelper.func_74520_c();
                itemRenderer.func_180450_b(change.item.stack, 0, 0);
                itemRenderer.func_180453_a(fontRenderer, change.item.stack, 0, 0, null);
                RenderHelper.func_74518_a();
                GlStateManager.popMatrix();
            }
            y += lineHeight;
        }
        GlStateManager.popMatrix();
    }

    private int computeStrings(List<Triple<ChangeInfo, String[], Integer>> computedStrings, FontRenderer font) {
        int rectWidth = 0;
        int itemsToShow = Math.min(Math.min(this.hard_limit, ConfigData.softLimit + ConfigData.fadeLimit), this.changeEntries.size());
        int offset = Math.max(0, this.changeEntries.size() - itemsToShow);
        int fadeOffset = this.changeEntries.size() - ConfigData.softLimit - ConfigData.fadeLimit;
        for (int i = offset; i < this.changeEntries.size(); ++i) {
            ChangeInfo change = this.changeEntries.get(i);
            String[] parts = this.getChangeStrings(change);
            int w = Arrays.stream(parts).mapToInt(arg_0 -> ((FontRenderer)font).func_78256_a(arg_0)).sum();
            rectWidth = Math.max(rectWidth, w);
            computedStrings.add((Triple<ChangeInfo, String[], Integer>)Triple.of((Object)change, (Object)parts, (Object)Math.min(ConfigData.fadeLimit + 2, 1 + i - fadeOffset)));
        }
        return rectWidth;
    }

    private String[] getChangeStrings(ChangeInfo change) {
        String mode = change.mode == ChangeMode.Obtained ? "+" : "-";
        String s1 = String.format("%s%d", mode, change.count);
        if (ConfigData.drawName) {
            String name = change.item.stack.func_200301_q().func_150254_d();
            String italics = change.item.stack.func_82837_s() ? "" + TextFormatting.ITALIC : "";
            String s2 = String.format("%s%s", italics, name);
            return new String[]{s1, " ", s2};
        }
        return new String[]{s1};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END) {
            return;
        }
        if (!ConfigData.showItemAdditions && !ConfigData.showItemRemovals) {
            return;
        }
        ClientPlayerEntity player = this.mc.field_71439_g;
        if (player == null) {
            return;
        }
        if (player != this.playerEntity) {
            PlayerContainerHooks.setTarget((Container)player.field_71069_bz, () -> {
                this.previous = null;
                this.dimLoadTicks = 0;
            });
            this.playerEntity = player;
            this.previous = null;
        }
        if (player.field_71093_bK != this.dim) {
            this.previous = null;
            this.dimLoadTicks = 200;
            this.dim = player.field_71093_bK;
        }
        if (this.dimLoadTicks > 0) {
            this.previous = null;
            --this.dimLoadTicks;
            return;
        }
        List<ChangeInfo> list = this.changeEntries;
        synchronized (list) {
            this.changeEntries.forEach(e -> --e.ttl);
            while (this.changeEntries.size() > this.hard_limit) {
                this.changeEntries.remove(0);
            }
            this.changeEntries.removeIf(e -> e.ttl <= 0 || e.count == 0);
        }
        PlayerInventory inventory = player.field_71071_by;
        if (this.previous == null || this.previous.length != inventory.func_70302_i_()) {
            this.previous = new ItemStack[inventory.func_70302_i_()];
            for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                this.previous[i] = ScrollingOverlay.safeCopy(inventory.func_70301_a(i));
            }
            this.previousInCursor = inventory.func_70445_o();
            return;
        }
        ArrayList changes = Lists.newArrayList();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            ItemStack old = this.previous[i];
            ItemStack stack = inventory.func_70301_a(i);
            if (this.isChangeMeaningful(old, stack)) {
                changes.add(Pair.of((Object)old, (Object)stack));
            }
            this.previous[i] = stack.func_77946_l();
        }
        ItemStack stackInCursor = inventory.func_70445_o();
        if (this.isChangeMeaningful(stackInCursor, this.previousInCursor)) {
            changes.add(Pair.of((Object)this.previousInCursor, (Object)stackInCursor));
        }
        this.previousInCursor = stackInCursor.func_77946_l();
        if (changes.size() == 0) {
            return;
        }
        ArrayList changeList = Lists.newArrayList();
        changes.forEach(change -> {
            boolean rightEmpty;
            ItemStack left = (ItemStack)change.getLeft();
            boolean leftEmpty = left.func_190916_E() <= 0;
            ItemStack right = (ItemStack)change.getRight();
            boolean bl = rightEmpty = right.func_190916_E() <= 0;
            if (ScrollingOverlay.areSameishItem(left, right)) {
                if (!this.isBlacklisted(left)) {
                    int difference = right.func_190916_E() - left.func_190916_E();
                    if (difference > 0) {
                        this.obtainedItem(changeList, left, difference);
                    } else if (difference < 0) {
                        this.lostItem(changeList, left, -difference);
                    }
                }
            } else {
                if (!leftEmpty && !this.isBlacklisted(left)) {
                    this.lostItem(changeList, left, left.func_190916_E());
                }
                if (!rightEmpty && !this.isBlacklisted(right)) {
                    this.obtainedItem(changeList, right, right.func_190916_E());
                }
            }
        });
        changeList.removeIf(e -> e.count == 0);
        if (changeList.size() > 0) {
            List<ChangeInfo> list2 = this.changeEntries;
            synchronized (list2) {
                for (ChangeInfo info : changeList) {
                    if (info.count == 0) continue;
                    this.accumulate(this.changeEntries, info.item.stack, info.mode, info.count, false);
                }
            }
        }
    }

    private boolean isBlacklisted(ItemStack left) {
        return ConfigData.ignoreItems.contains(left.func_77973_b().getRegistryName().toString());
    }

    private boolean isChangeMeaningful(ItemStack a, ItemStack b) {
        if (a.func_190916_E() != b.func_190916_E()) {
            return true;
        }
        if (a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b)) {
            return false;
        }
        if (a.func_77973_b() == b.func_77973_b() && ConfigData.ignoreSubitemChanges.contains(a.func_77973_b().getRegistryName().toString())) {
            return false;
        }
        return !ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
    }

    private static boolean areLooselyTheSame(ItemStack a, ItemStack b) {
        return a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b) || ItemStack.func_185132_d((ItemStack)a, (ItemStack)b);
    }

    private static boolean areSameishItem(ItemStack a, ItemStack b) {
        return a == b || ScrollingOverlay.isStackEmpty(a) && ScrollingOverlay.isStackEmpty(b) || ItemStack.func_179545_c((ItemStack)a, (ItemStack)b) && ItemStack.func_77970_a((ItemStack)a, (ItemStack)b);
    }

    private static boolean isStackEmpty(ItemStack stack) {
        return stack.func_190916_E() <= 0;
    }

    private static ItemStack safeCopy(ItemStack stack) {
        return stack.func_77946_l();
    }

    private void obtainedItem(List<ChangeInfo> changeList, ItemStack item, int added) {
        if (added <= 0 || !ConfigData.showItemAdditions) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.Obtained, added, true);
    }

    private void lostItem(List<ChangeInfo> changeList, ItemStack item, int removed) {
        if (removed <= 0 || !ConfigData.showItemRemovals) {
            return;
        }
        this.accumulate(changeList, item, ChangeMode.Lost, removed, true);
    }

    private void accumulate(List<ChangeInfo> changeList, ItemStack stack, ChangeMode mode, int count, boolean isLocal) {
        ChangeInfo info;
        if (stack.func_190916_E() <= 0) {
            return;
        }
        ComparableItem name = new ComparableItem(stack);
        ChangeInfo changeInfo = info = isLocal ? (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name)).findFirst().orElse(null) : (ChangeInfo)changeList.stream().filter(e -> e.item.equals(name) && e.mode == mode).findFirst().orElse(null);
        if (info == null) {
            info = new ChangeInfo(name, mode, count, 240);
            changeList.add(info);
            return;
        }
        if (info.mode != mode) {
            count = -count;
        }
        info.count += count;
        info.ttl = 240;
        if (info.count < 0) {
            info.count = -info.count;
            info.mode = info.mode == ChangeMode.Lost ? ChangeMode.Obtained : ChangeMode.Lost;
        }
    }

    private static class ComparableItem {
        ItemStack stack;

        ComparableItem(ItemStack stack) {
            this.stack = stack.func_77946_l();
            this.stack.func_190920_e(1);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof ComparableItem)) {
                return false;
            }
            ItemStack stack = ((ComparableItem)obj).stack;
            return ScrollingOverlay.areSameishItem(stack, this.stack);
        }

        public int hashCode() {
            return this.stack.func_77973_b().hashCode();
        }
    }

    private static enum ChangeMode {
        Obtained,
        Lost;

    }

    private static class ChangeInfo {
        final ComparableItem item;
        ChangeMode mode;
        int count;
        int ttl;

        ChangeInfo(ComparableItem item, ChangeMode mode, int count, int ttl) {
            this.item = item;
            this.mode = mode;
            this.count = count;
            this.ttl = ttl;
        }
    }
}

