/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.itank.common.blocks;

import com.ewyboy.bibliotheca.common.block.BlockBaseModeled;
import com.ewyboy.bibliotheca.common.compatibilities.waila.IWailaInformationUser;
import com.ewyboy.bibliotheca.common.interfaces.IBlockRenderer;
import com.ewyboy.itank.client.render.TankRenderer;
import com.ewyboy.itank.common.loaders.ConfigLoader;
import com.ewyboy.itank.common.loaders.CreativeTabLoader;
import com.ewyboy.itank.common.tiles.TileEntityTank;
import com.ewyboy.itank.common.utility.ItemStackUtils;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.DefaultStateMapper;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockTank
extends BlockBaseModeled
implements IBlockRenderer,
IWailaInformationUser {
    public static final PropertyInteger STATE = PropertyInteger.func_177719_a((String)"state", (int)0, (int)3);

    public BlockTank() {
        super(Material.field_151592_s);
        this.func_149711_c(1.0f);
        this.func_149647_a(CreativeTabLoader.ITank);
        this.func_180632_j(this.field_176227_L.func_177621_b());
    }

    public void setState(World world, BlockPos pos, int state) {
        TileEntity tileEntityOriginal = world.func_175625_s(pos);
        NBTTagCompound tag = new NBTTagCompound();
        tileEntityOriginal.func_189515_b(tag);
        world.func_175656_a(pos, this.func_176223_P().func_177226_a((IProperty)STATE, (Comparable)Integer.valueOf(state)));
        TileEntity tileEntityNew = world.func_175625_s(pos);
        tileEntityNew.func_145839_a(tag);
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block blockIn, BlockPos fromPos) {
        if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            this.setState(world, pos, 1);
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() == this && world.func_180495_p(pos.func_177977_b()).func_177230_c() != this) {
            this.setState(world, pos, 2);
        } else if (world.func_180495_p(pos.func_177984_a()).func_177230_c() != this && world.func_180495_p(pos.func_177977_b()).func_177230_c() == this) {
            this.setState(world, pos, 3);
        } else {
            this.setState(world, pos, 0);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STATE, (Comparable)Integer.valueOf(meta));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STATE);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STATE});
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (!player.func_184812_l_()) {
            if (player.func_70093_af()) {
                ItemStackUtils.dropStackInWorld(world, pos, new ItemStack((Block)this));
            } else {
                TileEntityTank tank = (TileEntityTank)world.func_175625_s(pos);
                ItemStackUtils.dropStackInWorld(world, pos, ItemStackUtils.createStackFromTileEntity(Objects.requireNonNull(tank)));
            }
        }
        return world.func_175698_g(pos);
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        TileEntityTank tank = (TileEntityTank)world.func_175625_s(pos);
        return ItemStackUtils.createStackFromTileEntity(tank);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        TileEntityTank te = this.getTE((IBlockAccess)world, pos);
        if (te != null && FluidUtil.interactWithFluidHandler((EntityPlayer)player, (EnumHand)EnumHand.MAIN_HAND, (World)world, (BlockPos)pos, (EnumFacing)facing)) {
            return true;
        }
        if (!world.field_72995_K) {
            player.func_184586_b(hand);
            if (player.func_184586_b(hand).func_77973_b().equals(Item.func_150898_a((Block)this))) {
                for (int i = 0; i < pos.func_177956_o() + 4; ++i) {
                    if (world.func_175623_d(pos.func_177982_a(0, i, 0))) {
                        TileEntityTank tank;
                        if (!player.func_184812_l_()) {
                            player.func_184586_b(hand).func_190918_g(1);
                        }
                        world.func_180501_a(pos.func_177981_b(i), this.func_176223_P(), 3);
                        if (!player.func_184586_b(hand).func_77942_o() || (tank = (TileEntityTank)world.func_175625_s(pos.func_177981_b(i))) == null) break;
                        tank.readNBT(player.func_184586_b(hand).func_77978_p().func_74775_l("TileData"));
                        break;
                    }
                    if (!world.func_175623_d(pos.func_177981_b(i)) && world.func_180495_p(pos.func_177981_b(i)).func_177230_c() != this) break;
                }
            }
        }
        world.func_184133_a(player, pos, SoundEvents.field_187567_bP, SoundCategory.BLOCKS, 1.0f, 1.0f);
        return true;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_150898_a((Block)this);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        TileEntityTank tank;
        if (stack.func_77942_o() && (tank = (TileEntityTank)worldIn.func_175625_s(pos)) != null) {
            tank.readNBT(stack.func_77978_p().func_74775_l("TileData"));
        }
    }

    public void onBlockExploded(World world, BlockPos pos, Explosion explosion) {
        ItemStackUtils.dropStackInWorld(world, pos, ItemStackUtils.createStackFromTileEntity(world.func_175625_s(pos)));
        world.func_175698_g(pos);
        this.func_180652_a(world, pos, explosion);
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntityTank) {
            TileEntityTank tank = (TileEntityTank)te;
            if (tank.tank.getFluid() != null && tank.tank.getFluidAmount() > 0) {
                return tank.tank.getFluid().getFluid().getLuminosity(tank.tank.getFluid());
            }
        }
        return 0;
    }

    @Nonnull
    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT_MIPPED;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        return false;
    }

    public boolean func_149637_q(IBlockState blockState) {
        return false;
    }

    public boolean func_149662_c(IBlockState blockState) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockRenderer() {
        ClientRegistry.bindTileEntitySpecialRenderer(TileEntityTank.class, (TileEntitySpecialRenderer)new TankRenderer());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new DefaultStateMapper(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(BlockTank.this.getRegistryName(), this.func_178131_a((Map)state.func_177228_b()));
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    public void registerBlockItemRenderer() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)new ItemStack((Block)this).func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }

    public TileEntityTank getTE(IBlockAccess world, BlockPos pos) {
        return (TileEntityTank)world.func_175625_s(pos);
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityTank();
    }

    public void func_190948_a(ItemStack stack, @Nullable World player, List<String> currenttip, ITooltipFlag advanced) {
        FluidStack fluid = null;
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b("TileData")) {
            fluid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.func_77978_p().func_74775_l("TileData").func_74775_l("FluidData"));
        }
        if (fluid != null) {
            currenttip.add("Fluid: " + fluid.getLocalizedName());
            currenttip.add(fluid.amount + "/" + ConfigLoader.maxTankCapacity + " mB");
        }
    }

    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler iWailaConfigHandler) {
        TileEntityTank te = this.getTE((IBlockAccess)accessor.getWorld(), accessor.getPosition());
        if (te != null) {
            currenttip.add(te.tank.getFluid() != null ? te.tank.getFluid().getLocalizedName() : "EMPTY");
            currenttip.add(te.tank.getFluidAmount() + "/" + te.tank.getCapacity() + " mB");
        }
        return currenttip;
    }
}

