/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.itank.common.tiles;

import com.ewyboy.itank.common.loaders.ConfigLoader;
import com.ewyboy.itank.common.tiles.TileEntityBase;
import com.ewyboy.itank.common.tiles.TileTank;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;

public class TileEntityTank
extends TileEntityBase
implements ITickable {
    public TileTank tank = new TileTank(1000 * (ConfigLoader.maxTankCapacity / 1000));

    public TileEntityTank() {
        this.tank.setTileEntity(this);
    }

    @Override
    public void writeNBT(NBTTagCompound dataTag) {
        if (this.tank != null && this.tank.getFluid() != null) {
            NBTTagCompound tankTag = new NBTTagCompound();
            this.tank.getFluid().writeToNBT(tankTag);
            dataTag.func_74782_a("FluidData", (NBTBase)tankTag);
        }
    }

    @Override
    public void readNBT(NBTTagCompound dataTag) {
        if (dataTag.func_74764_b("FluidData")) {
            this.tank = dataTag.func_74764_b("FluidData") ? new TileTank(FluidStack.loadFluidStackFromNBT((NBTTagCompound)dataTag.func_74775_l("FluidData")), 1000 * (ConfigLoader.maxTankCapacity / 1000)) : new TileTank(1000 * (ConfigLoader.maxTankCapacity / 1000));
        }
        this.tank.setTileEntity(this);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability.equals((Object)CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY)) {
            return (T)((Object)this.tank);
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        TileEntity te;
        if (this.tank.getFluid() != null && this.tank.getFluidAmount() > 0 && (te = this.field_145850_b.func_175625_s(this.field_174879_c.func_177977_b())) != null && te.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP)) {
            IFluidHandler fluidHandler = (IFluidHandler)te.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, EnumFacing.UP);
            this.tank.drain(fluidHandler.fill(this.tank.drain(this.tank.getCapacity(), false), true), true);
        }
    }

    public TileTank getTank() {
        return this.tank;
    }
}

