/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.bibliotheca.client;

import com.ewyboy.bibliotheca.common.fluid.BaseFluidBlock;
import com.ewyboy.bibliotheca.common.interfaces.IBlockRenderer;
import com.ewyboy.bibliotheca.common.interfaces.IItemRenderer;
import com.ewyboy.bibliotheca.common.item.ItemBase;
import com.ewyboy.bibliotheca.common.loaders.BlockLoader;
import com.ewyboy.bibliotheca.common.loaders.ItemLoader;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class InternalModelLoader {
    @SideOnly(value=Side.CLIENT)
    public static void init() {
        InternalModelLoader.initBlockModels();
        InternalModelLoader.initItemModels();
        InternalModelLoader.initFluidModels();
    }

    private static void initFluidModels() {
        BlockLoader.BLOCKS.values().stream().filter(block -> block instanceof BaseFluidBlock).forEachOrdered(block -> InternalModelLoader.registerFluidBlockRendering(block, block.getRegistryName().toString().replace(BlockLoader.MOD_ID + ":block", "")));
    }

    @SideOnly(value=Side.CLIENT)
    private static void initItemModels() {
        ItemLoader.ITEMS.values().stream().filter(item -> item instanceof IItemRenderer).forEachOrdered(item -> {
            for (int i : ((IItemRenderer)item).modelMetas()) {
                ModelBakery.registerItemVariants((Item)item, (ResourceLocation[])new ResourceLocation[]{new ResourceLocation(ItemLoader.MOD_ID + ":" + ((ItemBase)item).itemName(i))});
                ModelLoader.setCustomModelResourceLocation((Item)item, (int)i, (ModelResourceLocation)new ModelResourceLocation(ItemLoader.MOD_ID + ":" + ((ItemBase)item).itemName(i), "inventory"));
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private static void initBlockModels() {
        BlockLoader.BLOCKS.values().stream().filter(block -> block instanceof IBlockRenderer).forEachOrdered(block -> {
            for (int i : ((IBlockRenderer)block).modelMetas()) {
                ModelBakery.registerItemVariants((Item)Item.func_150898_a((Block)block), (ResourceLocation[])new ResourceLocation[]{block.getRegistryName()});
                ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)block), (int)i, (ModelResourceLocation)new ModelResourceLocation(block.getRegistryName(), "inventory"));
            }
        });
    }

    @SideOnly(value=Side.CLIENT)
    private static void registerFluidBlockRendering(Block block, String name) {
        final ModelResourceLocation fluidLocation = new ModelResourceLocation(BlockLoader.MOD_ID + ":fluids", name);
        ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)new StateMapperBase(){

            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return fluidLocation;
            }
        });
    }
}

