/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.bibliotheca.common.loaders;

import com.ewyboy.bibliotheca.common.interfaces.IBlockRenderer;
import com.ewyboy.bibliotheca.common.utility.Logger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class BlockLoader {
    public static String MOD_ID;
    public static final HashMap<String, Block> BLOCKS;

    public static void init(String modID, Class blockRegister) {
        MOD_ID = modID;
        BlockLoader.registerBlocks(modID, blockRegister);
    }

    private static void registerBlocks(String modID, Class blockRegister) {
        try {
            for (Field field : blockRegister.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof Block)) continue;
                Block block = (Block)obj;
                String name = "block" + field.getName().toLowerCase(Locale.ENGLISH);
                BlockLoader.registerBlock(modID, block, name);
                if (!(block instanceof IBlockRenderer) || !FMLCommonHandler.instance().getEffectiveSide().isClient()) continue;
                ((IBlockRenderer)block).registerBlockRenderer();
                ((IBlockRenderer)block).registerBlockItemRenderer();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerBlock(String modID, Block block, String name) {
        ForgeRegistries.BLOCKS.register((IForgeRegistryEntry)((Block)block.setRegistryName(modID, name)).func_149663_c(modID + "." + name));
        BLOCKS.put(block.getRegistryName().toString(), block);
        ItemBlock item = block instanceof IHasCustomItem ? ((IHasCustomItem)block).getItemBlock() : new ItemBlock(block);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)item.setRegistryName(modID, name)).func_77655_b(modID + "." + name));
        Logger.info("[BLOCK]: " + name + " has been registered by Bibliotheca for the mod " + modID);
        if (block instanceof IHasCustomItem) {
            Logger.info("[ITEMBLOCK]: " + name + " | " + item.getRegistryName() + " has been registered by Bibliotheca for the mod " + modID);
        }
    }

    static {
        BLOCKS = new HashMap();
    }

    public static interface IHasCustomItem {
        public ItemBlock getItemBlock();
    }
}

