/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.bibliotheca.common.loaders;

import com.ewyboy.bibliotheca.common.interfaces.IItemRenderer;
import com.ewyboy.bibliotheca.common.utility.Logger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemLoader {
    public static String MOD_ID;
    public static final HashMap<String, Item> ITEMS;

    public static void init(String modid, Class itemRegister) {
        MOD_ID = modid;
        ItemLoader.registerItems(modid, itemRegister);
    }

    private static void registerItems(String modID, Class itemRegister) {
        try {
            for (Field field : itemRegister.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof Item)) continue;
                Item item = (Item)obj;
                String name = "item" + field.getName().toLowerCase(Locale.ENGLISH);
                ItemLoader.registerItem(modID, item, name);
                if (!(item instanceof IItemRenderer) || !FMLCommonHandler.instance().getEffectiveSide().isClient()) continue;
                ((IItemRenderer)item).registerItemRenderer();
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    public static void registerItem(String modID, Item item, String name) {
        String itemName = name.toLowerCase(Locale.ENGLISH);
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)((Item)item.setRegistryName(modID, itemName)).func_77655_b(modID + "." + itemName));
        ITEMS.put(item.getRegistryName().toString(), item);
        Logger.info("[ITEM]: " + name + " has been registered by Bibliotheca for the mod " + modID);
    }

    static {
        ITEMS = new HashMap();
    }
}

