/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.bibliotheca.common.loaders;

import com.ewyboy.bibliotheca.common.network.PacketBase;
import com.ewyboy.bibliotheca.common.utility.Logger;
import java.lang.reflect.Field;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.SimpleNetworkWrapper;

public class PacketLoader {
    private static int packetID = 0;
    public static SimpleNetworkWrapper wrapper;

    private static int getPacketID() {
        return packetID++;
    }

    public static void init(String modid, Class packetRegister) {
        PacketLoader.registerPackets(modid, packetRegister);
    }

    private static void registerPackets(String modid, Class packetRegister) {
        wrapper = NetworkRegistry.INSTANCE.newSimpleChannel(modid);
        PacketBase.PacketBaseHandler packetHandler = new PacketBase.PacketBaseHandler();
        try {
            for (Field field : packetRegister.getDeclaredFields()) {
                Object obj = field.get(null);
                if (obj instanceof PacketBase.PacketBaseHandler) {
                    packetHandler = (PacketBase.PacketBaseHandler)obj;
                }
                if (!(obj instanceof PacketBase)) continue;
                PacketBase packet = (PacketBase)obj;
                if (packet.getSide() != null) {
                    Logger.info("[PACKET]: " + packet.getClass().getSimpleName() + " has been registered on the " + packet.getSide().name() + " side with packet ID: " + packetID + " by Bibliotheca for the mod " + modid);
                    wrapper.registerMessage((IMessageHandler)packetHandler, packet.getClass(), PacketLoader.getPacketID(), packet.getSide());
                    continue;
                }
                Logger.info("[ERROR]: " + packet.getClass().getSimpleName() + " has not specified a side");
            }
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
    }
}

