/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.bibliotheca.common.loaders;

import java.util.stream.IntStream;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.GameData;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class RecipeLoader {
    public static void addShapedOreRecipe(ItemStack output, Object ... params) {
        ResourceLocation location = RecipeLoader.getNameForRecipe(output);
        ShapedOreRecipe recipe = new ShapedOreRecipe(location, output, params);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapedRecipe(ItemStack output, Object ... params) {
        ResourceLocation location = RecipeLoader.getNameForRecipe(output);
        CraftingHelper.ShapedPrimer primer = CraftingHelper.parseShaped((Object[])params);
        ShapedRecipes recipe = new ShapedRecipes(output.func_77973_b().getRegistryName().toString(), primer.width, primer.height, primer.input, output);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessOreRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeLoader.getNameForRecipe(output);
        ShapelessOreRecipe recipe = new ShapelessOreRecipe(location, output, input);
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static void addShapelessRecipe(ItemStack output, Object ... input) {
        ResourceLocation location = RecipeLoader.getNameForRecipe(output);
        ShapelessRecipes recipe = new ShapelessRecipes(location.func_110624_b(), output, RecipeLoader.buildInput(input));
        recipe.setRegistryName(location);
        GameData.register_impl((IForgeRegistryEntry)recipe);
    }

    public static ResourceLocation getNameForRecipe(ItemStack output) {
        ResourceLocation baseLoc;
        ModContainer activeContainer = Loader.instance().activeModContainer();
        ResourceLocation recipeLoc = baseLoc = new ResourceLocation(activeContainer.getModId(), output.func_77973_b().getRegistryName().func_110623_a());
        int index = 0;
        while (CraftingManager.field_193380_a.func_148741_d((Object)recipeLoc)) {
            recipeLoc = new ResourceLocation(activeContainer.getModId(), baseLoc.func_110623_a() + "_" + ++index);
        }
        return recipeLoc;
    }

    private static NonNullList<Ingredient> buildInput(Object[] input) {
        NonNullList list = NonNullList.func_191196_a();
        for (Object obj : input) {
            if (obj instanceof Ingredient) {
                list.add((Object)((Ingredient)obj));
                continue;
            }
            Ingredient ingredient = CraftingHelper.getIngredient((Object)obj);
            if (ingredient == null) {
                ingredient = Ingredient.field_193370_a;
            }
            list.add((Object)ingredient);
        }
        return list;
    }

    public static void addPlainTwoByTwoRecipe(ItemStack stackIn, ItemStack stackOut, int amountOut) {
        RecipeLoader.addShapedRecipe(new ItemStack(stackOut.func_77973_b(), amountOut), "xx", "xx", Character.valueOf('x'), stackIn);
    }

    public static void addPlainThreeByThreeRecipe(ItemStack stackIn, ItemStack stackOut, int amountOut) {
        RecipeLoader.addShapedRecipe(new ItemStack(stackOut.func_77973_b(), amountOut), "xxx", "xxx", "xxx", Character.valueOf('x'), stackIn);
    }

    public static void addThreeByThreeWithCenterRecipe(ItemStack stackInAround, ItemStack stackInCenter, ItemStack stackOut, int amountOut) {
        RecipeLoader.addShapedRecipe(new ItemStack(stackOut.func_77973_b(), amountOut), "xxx", "xox", "xxx", Character.valueOf('x'), stackInAround, Character.valueOf('o'), stackInCenter);
    }

    public static void addScalingRecipe(ItemStack stackIn, ItemStack stackOut) {
        IntStream.rangeClosed(1, 9).forEachOrdered(i -> RecipeLoader.addShapelessOreRecipe(new ItemStack(stackIn.func_77973_b(), i), new ItemStack(stackOut.func_77973_b()), i));
    }

    public static void addMultiScalingRecipe(ItemStack stackInOne, ItemStack stackInTwo, ItemStack stackOut) {
        IntStream.rangeClosed(1, 8).forEachOrdered(i -> RecipeLoader.addShapelessOreRecipe(new ItemStack(stackInOne.func_77973_b(), i), stackInTwo, new ItemStack(stackOut.func_77973_b()), i));
    }

    public static void addSmelting(Block input, ItemStack output, float xp) {
        GameRegistry.addSmelting((Block)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(Item input, ItemStack output, float xp) {
        GameRegistry.addSmelting((Item)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(ItemStack input, ItemStack output, float xp) {
        GameRegistry.addSmelting((ItemStack)input, (ItemStack)output, (float)xp);
    }

    public static void addSmelting(ItemStack input, ItemStack output) {
        RecipeLoader.addSmelting(input, output, 1.0f);
    }

    public static void addSmelting(Item input, ItemStack output) {
        RecipeLoader.addSmelting(input, output, 1.0f);
    }

    public static void addSmelting(Block input, ItemStack output) {
        RecipeLoader.addSmelting(input, output, 1.0f);
    }
}

