/*
 * Decompiled with CFR 0.152.
 */
package com.ewyboy.bibliotheca.common.loaders;

import com.ewyboy.bibliotheca.common.utility.Logger;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Locale;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class TileEntityLoader {
    public static final HashMap<String, TileEntity> TILE_ENTITIES = new HashMap();

    public static void init(Class tileEntityRegister) {
        TileEntityLoader.registerTileEntity(tileEntityRegister);
    }

    private static void registerTileEntity(Class tileEntityRegister) {
        try {
            for (Field field : tileEntityRegister.getDeclaredFields()) {
                Object obj = field.get(null);
                if (!(obj instanceof TileEntity)) continue;
                TileEntity tileEntity = (TileEntity)obj;
                String name = field.getName().toLowerCase(Locale.ENGLISH);
                TileEntityLoader.registerTileEntity(tileEntity, name);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private static void registerTileEntity(TileEntity tileEntity, String name) {
        GameRegistry.registerTileEntity(tileEntity.getClass(), (String)name);
        TILE_ENTITIES.put(tileEntity.toString(), tileEntity);
        Logger.info("[TILE ENTITY]: " + tileEntity.getClass().getSimpleName() + " has been registered by Bibliotheca");
    }
}

