/*
 * Decompiled with CFR 0.152.
 */
package com.leethesologamer.leescreatures;

import com.leethesologamer.leescreatures.entities.BeastDogEntity;
import com.leethesologamer.leescreatures.entities.BoarlinEntity;
import com.leethesologamer.leescreatures.entities.CrestedCrikestreakerEntity;
import com.leethesologamer.leescreatures.entities.CrystalWyvernEntity;
import com.leethesologamer.leescreatures.entities.JungleSerpentEntity;
import com.leethesologamer.leescreatures.entities.SouleuronEntity;
import com.leethesologamer.leescreatures.init.ModBlocks;
import com.leethesologamer.leescreatures.init.ModEntityTypes;
import com.leethesologamer.leescreatures.init.ModItems;
import com.leethesologamer.leescreatures.objects.items.ModSpawnEggItem;
import com.leethesologamer.leescreatures.world.ModEntitySpawing;
import com.leethesologamer.leescreatures.world.OreGeneration;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.GlobalEntityTypeAttributes;
import net.minecraft.item.BlockItem;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import software.bernie.example.GeckoLibMod;
import software.bernie.geckolib3.GeckoLib;

@Mod(value="leescreatures")
public class LeesCreatures {
    public static final Logger LOGGER = LogManager.getLogger();
    public static final String MOD_ID = "leescreatures";
    public static final ItemGroup LEES_CREATURES_GROUP = new LeesCreaturesGroup("leescreaturestab");

    public LeesCreatures() {
        IEventBus bus = FMLJavaModLoadingContext.get().getModEventBus();
        bus.addListener(this::setup);
        GeckoLibMod.DISABLE_IN_DEV = true;
        GeckoLib.initialize();
        ModBlocks.BLOCKS.register(bus);
        ModItems.ITEMS.register(bus);
        ModEntityTypes.ENTITY_TYPES.register(bus);
        MinecraftForge.EVENT_BUS.addListener(EventPriority.HIGH, OreGeneration::generateOres);
        MinecraftForge.EVENT_BUS.addListener(this::onBiomeLoad);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onBiomeLoad(BiomeLoadingEvent event) {
        ModEntitySpawing.onBiomesLoad(event);
    }

    private void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.BOARLIN_ENTITY.get()), (AttributeModifierMap)BoarlinEntity.registerAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.SOULEURON_ENTITY.get()), (AttributeModifierMap)SouleuronEntity.registerAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.CRYSTAL_WYVERN_ENTITY.get()), (AttributeModifierMap)CrystalWyvernEntity.registerAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.JUNGLE_SERPENT_ENTITY.get()), (AttributeModifierMap)JungleSerpentEntity.registerAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.BEAST_DOG_ENTITY.get()), (AttributeModifierMap)BeastDogEntity.registerAttributes().func_233813_a_());
            GlobalEntityTypeAttributes.put((EntityType)((EntityType)ModEntityTypes.CRESTED_CRIKESTREAKER_ENTITY.get()), (AttributeModifierMap)CrestedCrikestreakerEntity.registerAttributes().func_233813_a_());
        });
    }

    private void doClientStuff(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public static void onRegisterEntities(RegistryEvent.Register<EntityType<?>> event) {
        ModSpawnEggItem.initSpawnEggs();
    }

    public static class LeesCreaturesGroup
    extends ItemGroup {
        public LeesCreaturesGroup(String label) {
            super(label);
        }

        public ItemStack func_78016_d() {
            return ((BlockItem)ModItems.DURANTIUM_ORE_ITEM.get()).func_190903_i();
        }
    }
}

