/*
 * Decompiled with CFR 0.152.
 */
package com.leethesologamer.leescreatures.entities;

import com.leethesologamer.leescreatures.entities.CrystalWyvernEntity;
import com.leethesologamer.leescreatures.entities.flying.ai.TamedAiRide;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IAngerable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.EatGrassGoal;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class BoarlinEntity
extends TameableEntity
implements IAngerable,
IAnimatable {
    private static final DataParameter<Boolean> BUCKING = EntityDataManager.func_187226_a(BoarlinEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> ANGER_TIME = EntityDataManager.func_187226_a(BoarlinEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151015_O, Items.field_151174_bG, Items.field_185164_cV});
    private EatGrassGoal eatGrassGoal;
    private int exampleTimer;
    private UUID lastHurtBy;
    private int riderAttackCooldown = 0;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public BoarlinEntity(EntityType<BoarlinEntity> entityType, World worldIn) {
        super(entityType, worldIn);
        this.func_70903_f(false);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving() && !((Boolean)this.field_70180_af.func_187225_a(BUCKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(BUCKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.eatGrassGoal = new EatGrassGoal((MobEntity)this);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new BuckingGoal());
        this.field_70714_bg.func_75776_a(1, (Goal)new TamedAiRide((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.1, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 0.3));
        this.field_70714_bg.func_75776_a(5, (Goal)this.eatGrassGoal);
        this.field_70714_bg.func_75776_a(6, (Goal)new TemptGoal((CreatureEntity)this, 1.1, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(7, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(9, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, CrystalWyvernEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 45.0).func_233815_a_(Attributes.field_233819_b_, 35.0).func_233815_a_(Attributes.field_233821_d_, (double)0.23f).func_233815_a_(Attributes.field_233823_f_, 10.0);
    }

    public void func_70636_d() {
        PlayerEntity rider;
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.exampleTimer = Math.max(0, this.exampleTimer - 1);
        }
        if (this.riderAttackCooldown > 0) {
            --this.riderAttackCooldown;
        }
        if (this.func_184179_bs() != null && this.func_184179_bs() instanceof PlayerEntity && (rider = (PlayerEntity)this.func_184179_bs()).func_110144_aD() != null && this.func_70032_d((Entity)rider.func_110144_aD()) < this.func_213311_cf() + 3.0f && !this.func_184191_r((Entity)rider.func_110144_aD())) {
            UUID preyUUID = rider.func_110144_aD().func_110124_au();
            if (!this.func_110124_au().equals(preyUUID) && this.riderAttackCooldown == 0) {
                this.func_70652_k((Entity)rider.func_110144_aD());
                this.riderAttackCooldown = 20;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.exampleTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public int func_70641_bl() {
        return 6;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return super.func_184652_a(player);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld serverWorld, AgeableEntity ageableEntity) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(BUCKING, (Object)false);
        this.field_70180_af.func_187214_a(ANGER_TIME, (Object)0);
    }

    public boolean isBucking() {
        return (Boolean)this.field_70180_af.func_187225_a(BUCKING);
    }

    public void setBucking(boolean bucking) {
        this.field_70180_af.func_187227_b(BUCKING, (Object)bucking);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Bucking", this.isBucking());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setBucking(compound.func_74767_n("Bucking"));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CrystalWyvernEntity)) {
            if (target instanceof BoarlinEntity) {
                BoarlinEntity boarlinEntity = (BoarlinEntity)target;
                return !boarlinEntity.func_70909_n() || boarlinEntity.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    public int func_230256_F__() {
        return (Integer)this.field_70180_af.func_187225_a(ANGER_TIME);
    }

    public void func_230260_a__(int time) {
        this.field_70180_af.func_187227_b(ANGER_TIME, (Object)time);
    }

    public UUID func_230257_G__() {
        return this.lastHurtBy;
    }

    public void func_230259_a_(@Nullable UUID target) {
        this.lastHurtBy = target;
    }

    public void func_230258_H__() {
    }

    public void func_193101_c(PlayerEntity player) {
        super.func_193101_c(player);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 3;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187697_dL;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187703_dN;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187700_dM;
    }

    protected SoundEvent getStepSound() {
        return SoundEvents.field_187709_dP;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(this.getStepSound(), 0.15f, 1.0f);
    }

    @Nullable
    public Entity func_184179_bs() {
        for (Entity passenger : this.func_184188_bt()) {
            if (!(passenger instanceof PlayerEntity)) continue;
            PlayerEntity player = (PlayerEntity)passenger;
            return player;
        }
        return null;
    }

    public void func_184232_k(Entity passenger) {
        if (this.func_184196_w(passenger)) {
            float radius = 0.0f;
            float angle = (float)Math.PI / 180 * this.field_70761_aq;
            double extraX = radius * MathHelper.func_76126_a((float)((float)(Math.PI + (double)angle)));
            double extraZ = radius * MathHelper.func_76134_b((float)angle);
            passenger.func_70107_b(this.func_226277_ct_() + extraX, this.func_226278_cu_() + this.func_70042_X() + passenger.func_70033_W(), this.func_226281_cx_() + extraZ);
        }
    }

    public double func_70042_X() {
        float f = Math.min(0.25f, this.field_70721_aZ);
        float f1 = this.field_184619_aG;
        return (double)this.func_213302_cg() - 0.5 + (double)(0.6f * MathHelper.func_76134_b((float)(f1 * 1.2f)) * 1.0f * f);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        ActionResultType type = super.func_230254_b_(player, hand);
        if (item == Items.field_151015_O && !this.func_70909_n()) {
            int tameAmount;
            int size = itemstack.func_190916_E();
            if (size > (tameAmount = 58 + this.field_70146_Z.nextInt(16))) {
                this.func_193101_c(player);
            }
            itemstack.func_190918_g(size);
            return ActionResultType.SUCCESS;
        }
        if (type != ActionResultType.SUCCESS && this.func_70909_n() && this.func_152114_e((LivingEntity)player)) {
            if (this.func_70877_b(itemstack)) {
                this.func_204700_e(600);
                this.func_175505_a(player, itemstack);
                return ActionResultType.SUCCESS;
            }
            if (!player.func_225608_bj_() && !this.func_70877_b(itemstack)) {
                player.func_184220_m((Entity)this);
                return ActionResultType.SUCCESS;
            }
        }
        return type;
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    class BuckingGoal
    extends MeleeAttackGoal {
        public BuckingGoal() {
            super((CreatureEntity)BoarlinEntity.this, 1.0, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
                BoarlinEntity.this.setBucking(false);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    BoarlinEntity.this.setBucking(false);
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    BoarlinEntity.this.setBucking(true);
                }
            } else {
                this.func_234039_g_();
                BoarlinEntity.this.setBucking(false);
            }
        }

        public void func_75251_c() {
            BoarlinEntity.this.setBucking(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 3.0f + attackTarget.func_213311_cf();
        }
    }
}

