/*
 * Decompiled with CFR 0.152.
 */
package com.leethesologamer.leescreatures.entities;

import com.leethesologamer.leescreatures.entities.BoarlinEntity;
import com.leethesologamer.leescreatures.init.ModItems;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.SheepEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CrestedCrikestreakerEntity
extends CreatureEntity
implements IAnimatable {
    private static final DataParameter<Boolean> ATTACKING = EntityDataManager.func_187226_a(CrestedCrikestreakerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> VARIANT = EntityDataManager.func_187226_a(CrestedCrikestreakerEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private int exampleTimer;
    public int timeUntilNextCrestedEgg;
    private AnimationFactory factory;

    public CrestedCrikestreakerEntity(EntityType<CrestedCrikestreakerEntity> entityType, World worldIn) {
        super(entityType, worldIn);
        this.timeUntilNextCrestedEgg = this.field_70146_Z.nextInt(6000) + 6000;
        this.factory = new AnimationFactory((IAnimatable)this);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving() && !((Boolean)this.field_70180_af.func_187225_a(ATTACKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("walking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(ATTACKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new AttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.8));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, BoarlinEntity.class, false));
        this.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)this, SheepEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 47.0).func_233815_a_(Attributes.field_233819_b_, 10.0).func_233815_a_(Attributes.field_233821_d_, (double)0.45f).func_233815_a_(Attributes.field_233823_f_, 13.0);
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_72995_K) {
            this.exampleTimer = Math.max(0, this.exampleTimer - 1);
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && !this.func_70631_g_() && --this.timeUntilNextCrestedEgg <= 0) {
            this.func_199703_a((IItemProvider)ModItems.CRESTED_CRIKESTREAKER_EGG.get());
            this.timeUntilNextCrestedEgg = this.field_70146_Z.nextInt(6000) + 6000;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.exampleTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public int func_70641_bl() {
        return 3;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(VARIANT, (Object)0);
        this.field_70180_af.func_187214_a(ATTACKING, (Object)false);
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return super.func_184652_a(player);
    }

    protected int func_70693_a(PlayerEntity player) {
        return 3;
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public int getVariant() {
        return (Integer)this.field_70180_af.func_187225_a(VARIANT);
    }

    public void setVariant(int type) {
        this.field_70180_af.func_187227_b(VARIANT, (Object)type);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isAttacking() {
        return (Boolean)this.field_70180_af.func_187225_a(ATTACKING);
    }

    public void setAttacking(boolean attacking) {
        this.field_70180_af.func_187227_b(ATTACKING, (Object)attacking);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74768_a("Variant", this.getVariant());
        compound.func_74757_a("Attacking", this.isAttacking());
        compound.func_74768_a("EggDropTime", this.timeUntilNextCrestedEgg);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setVariant(compound.func_74762_e("Variant"));
        this.setAttacking(compound.func_74767_n("Attacking"));
        if (compound.func_74764_b("EggDropTime")) {
            this.timeUntilNextCrestedEgg = compound.func_74762_e("EggDropTime");
        }
    }

    @Nullable
    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        Random random = new Random();
        int type = (double)random.nextFloat() > 0.9 ? 1 : ((double)random.nextFloat() > 0.9 ? 2 : 0);
        this.setVariant(type);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        boolean flag = entityIn.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), (float)((int)this.func_233637_b_(Attributes.field_233823_f_)));
        if (flag) {
            this.func_174815_a((LivingEntity)this, entityIn);
        }
        return flag;
    }

    class AttackGoal
    extends MeleeAttackGoal {
        public AttackGoal() {
            super((CreatureEntity)CrestedCrikestreakerEntity.this, 1.2, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
                CrestedCrikestreakerEntity.this.setAttacking(false);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    CrestedCrikestreakerEntity.this.setAttacking(false);
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    CrestedCrikestreakerEntity.this.setAttacking(true);
                }
            } else {
                this.func_234039_g_();
                CrestedCrikestreakerEntity.this.setAttacking(false);
            }
        }

        public void func_75251_c() {
            CrestedCrikestreakerEntity.this.setAttacking(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 3.0f + attackTarget.func_213311_cf();
        }
    }
}

