/*
 * Decompiled with CFR 0.152.
 */
package com.leethesologamer.leescreatures.entities;

import com.leethesologamer.leescreatures.entities.BoarlinEntity;
import com.leethesologamer.leescreatures.entities.CrystalWyvernEntity;
import com.leethesologamer.leescreatures.init.ModItems;
import javax.annotation.Nullable;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtByTargetGoal;
import net.minecraft.entity.ai.goal.OwnerHurtTargetGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.passive.horse.AbstractHorseEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class JungleSerpentEntity
extends TameableEntity
implements IAnimatable {
    private static final DataParameter<Boolean> STRIKING = EntityDataManager.func_187226_a(JungleSerpentEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private int exampleTimer;
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);

    public JungleSerpentEntity(EntityType<JungleSerpentEntity> entityType, World worldIn) {
        super(entityType, worldIn);
        this.func_70903_f(false);
    }

    private <E extends IAnimatable> PlayState predicate(AnimationEvent<E> event) {
        if (event.isMoving() && !((Boolean)this.field_70180_af.func_187225_a(STRIKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("slithering", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        if (((Boolean)this.field_70180_af.func_187225_a(STRIKING)).booleanValue()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("attacking", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        event.getController().setAnimation(new AnimationBuilder().addAnimation("idle", Boolean.valueOf(true)));
        return PlayState.CONTINUE;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new StrikeAttackGoal());
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.5, 10.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(3, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(4, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.5));
        this.applyEntityAI();
    }

    protected void applyEntityAI() {
        this.field_70715_bh.func_75776_a(1, (Goal)new OwnerHurtByTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(2, (Goal)new OwnerHurtTargetGoal((TameableEntity)this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[]{PlayerEntity.class}));
        this.field_70715_bh.func_75776_a(4, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
        this.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(6, (Goal)new NearestAttackableTargetGoal((MobEntity)this, AnimalEntity.class, true));
    }

    public static AttributeModifierMap.MutableAttribute registerAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 57.0).func_233815_a_(Attributes.field_233819_b_, 20.0).func_233815_a_(Attributes.field_233821_d_, (double)0.29f).func_233815_a_(Attributes.field_233823_f_, 12.0);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.exampleTimer = Math.max(0, this.exampleTimer - 1);
        }
        super.func_70636_d();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.exampleTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    public int func_70641_bl() {
        return 1;
    }

    protected int func_70693_a(PlayerEntity player) {
        return 3;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "controller", 0.0f, this::predicate));
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }

    public boolean func_184652_a(PlayerEntity player) {
        return super.func_184652_a(player);
    }

    @Nullable
    public AgeableEntity func_241840_a(ServerWorld p_241840_1_, AgeableEntity p_241840_2_) {
        return null;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(STRIKING, (Object)false);
    }

    public boolean func_205019_a(IWorldReader worldIn) {
        return worldIn.func_226668_i_((Entity)this);
    }

    public void func_193101_c(PlayerEntity player) {
        super.func_193101_c(player);
    }

    public boolean isStriking() {
        return (Boolean)this.field_70180_af.func_187225_a(STRIKING);
    }

    public void setStriking(boolean striking) {
        this.field_70180_af.func_187227_b(STRIKING, (Object)striking);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Striking", this.isStriking());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setStriking(compound.func_74767_n("Striking"));
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        return super.func_70097_a(source, amount);
    }

    public boolean func_70652_k(Entity entityIn) {
        if (super.func_70652_k(entityIn)) {
            if (entityIn instanceof LivingEntity) {
                int i = 0;
                if (this.field_70170_p.func_175659_aa() == Difficulty.NORMAL) {
                    i = 10;
                } else if (this.field_70170_p.func_175659_aa() == Difficulty.HARD) {
                    i = 20;
                }
                ((LivingEntity)entityIn).func_195064_c(new EffectInstance(Effects.field_76436_u, i * 24, 0));
            }
            return true;
        }
        return false;
    }

    public boolean func_142018_a(LivingEntity target, LivingEntity owner) {
        if (!(target instanceof CrystalWyvernEntity)) {
            if (target instanceof BoarlinEntity) {
                BoarlinEntity boarlinEntity = (BoarlinEntity)target;
                return !boarlinEntity.func_70909_n() || boarlinEntity.func_70902_q() != owner;
            }
            if (target instanceof PlayerEntity && owner instanceof PlayerEntity && !((PlayerEntity)owner).func_96122_a((PlayerEntity)target)) {
                return false;
            }
            if (target instanceof AbstractHorseEntity && ((AbstractHorseEntity)target).func_110248_bS()) {
                return false;
            }
            return !(target instanceof TameableEntity) || !((TameableEntity)target).func_70909_n();
        }
        return false;
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
        Item item = itemstack.func_77973_b();
        if (this.field_70170_p.field_72995_K) {
            boolean flag = this.func_152114_e((LivingEntity)p_230254_1_) || this.func_70909_n() || item == ModItems.CRESTED_CRIKESTREAKER_EGG.get() && !this.func_70909_n();
            return flag ? ActionResultType.CONSUME : ActionResultType.PASS;
        }
        if (this.func_70909_n()) {
            if (this.func_70877_b(itemstack) && this.func_110143_aJ() < this.func_110138_aP()) {
                if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                    itemstack.func_190918_g(1);
                }
                this.func_70691_i(item.func_219967_s().func_221466_a());
                return ActionResultType.SUCCESS;
            }
            if (!(item instanceof DyeItem)) {
                ActionResultType actionresulttype = super.func_230254_b_(p_230254_1_, p_230254_2_);
                if ((!actionresulttype.func_226246_a_() || this.func_70631_g_()) && this.func_152114_e((LivingEntity)p_230254_1_)) {
                    this.func_233687_w_(!this.func_233685_eM_());
                    this.field_70699_by.func_75499_g();
                    this.func_70624_b(null);
                    return ActionResultType.SUCCESS;
                }
                return actionresulttype;
            }
        } else if (item == ModItems.CRESTED_CRIKESTREAKER_EGG.get()) {
            if (!p_230254_1_.field_71075_bZ.field_75098_d) {
                itemstack.func_190918_g(1);
            }
            if (this.field_70146_Z.nextInt(5) == 0 && !ForgeEventFactory.onAnimalTame((AnimalEntity)this, (PlayerEntity)p_230254_1_)) {
                this.func_193101_c(p_230254_1_);
                this.field_70699_by.func_75499_g();
                this.func_70624_b(null);
                this.func_233687_w_(true);
                this.field_70170_p.func_72960_a((Entity)this, (byte)7);
            } else {
                this.field_70170_p.func_72960_a((Entity)this, (byte)6);
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(p_230254_1_, p_230254_2_);
    }

    public boolean func_184191_r(Entity entityIn) {
        if (this.func_70909_n()) {
            LivingEntity livingentity = this.func_70902_q();
            if (entityIn == livingentity) {
                return true;
            }
            if (entityIn instanceof TameableEntity) {
                return ((TameableEntity)entityIn).func_152114_e(livingentity);
            }
            if (livingentity != null) {
                return livingentity.func_184191_r(entityIn);
            }
        }
        return super.func_184191_r(entityIn);
    }

    class StrikeAttackGoal
    extends MeleeAttackGoal {
        public StrikeAttackGoal() {
            super((CreatureEntity)JungleSerpentEntity.this, 1.0, true);
        }

        protected void func_190102_a(LivingEntity enemy, double distToEnemySqr) {
            double d0 = this.func_179512_a(enemy);
            if (distToEnemySqr <= d0 && this.func_234040_h_()) {
                this.func_234039_g_();
                this.field_75441_b.func_70652_k((Entity)enemy);
                JungleSerpentEntity.this.setStriking(true);
            } else if (distToEnemySqr <= d0 * 2.0) {
                if (this.func_234040_h_()) {
                    JungleSerpentEntity.this.setStriking(false);
                    this.func_234039_g_();
                }
                if (this.func_234041_j_() <= 10) {
                    JungleSerpentEntity.this.setStriking(true);
                }
            } else {
                this.func_234039_g_();
                JungleSerpentEntity.this.setStriking(false);
            }
        }

        public void func_75251_c() {
            JungleSerpentEntity.this.setStriking(false);
            super.func_75251_c();
        }

        protected double func_179512_a(LivingEntity attackTarget) {
            return 3.0f + attackTarget.func_213311_cf();
        }
    }
}

