/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.api;

import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.item.minecart.ContainerMinecartEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.Cancelable;
import noobanidus.mods.lootr.api.ILootCart;
import noobanidus.mods.lootr.api.ILootTile;
import noobanidus.mods.lootr.api.ILootrInventory;

public class LootrLootingEvent
extends PlayerEvent {
    protected final World world;
    protected final RegistryKey<World> dimension;
    protected final ILootrInventory inventory;
    protected final LockableLootTileEntity tile;
    protected final ContainerMinecartEntity cartEntity;

    public LootrLootingEvent(PlayerEntity player, World world, RegistryKey<World> dimension, ILootrInventory inventory, LockableLootTileEntity tile, ContainerMinecartEntity cartEntity) {
        super(player);
        this.world = world;
        this.dimension = dimension;
        this.inventory = inventory;
        this.tile = tile;
        this.cartEntity = cartEntity;
    }

    @Nullable
    public UUID getUniqueId() {
        if (this.tile instanceof ILootTile) {
            return ((ILootTile)this.tile).getTileId();
        }
        if (this.cartEntity != null) {
            return this.cartEntity.func_110124_au();
        }
        return null;
    }

    @Nullable
    public ResourceLocation getTable() {
        if (this.tile instanceof ILootTile) {
            return ((ILootTile)this.tile).getTable();
        }
        if (this.cartEntity != null) {
            return this.cartEntity.field_184290_c;
        }
        return null;
    }

    public long getSeed() {
        if (this.tile instanceof ILootTile) {
            return ((ILootTile)this.tile).getSeed();
        }
        if (this.cartEntity != null) {
            return this.cartEntity.field_184291_d;
        }
        return -1L;
    }

    public World getWorld() {
        return this.world;
    }

    public RegistryKey<World> getDimension() {
        return this.dimension;
    }

    @Nullable
    public BlockPos getPos() {
        return this.inventory.getPos();
    }

    public Set<UUID> getOpeners() {
        if (this.tile instanceof ILootTile) {
            return ((ILootTile)this.tile).getOpeners();
        }
        if (this.cartEntity instanceof ILootCart) {
            return ((ILootCart)this.cartEntity).getOpeners();
        }
        return Collections.emptySet();
    }

    public int getOpenerCount() {
        return this.getOpeners().size();
    }

    @Nullable
    public LockableLootTileEntity getTile() {
        return this.tile;
    }

    public ContainerMinecartEntity getMinecart() {
        return this.cartEntity;
    }

    public boolean isMinecart() {
        return this.cartEntity != null;
    }

    public static class Post
    extends LootrLootingEvent {
        public Post(PlayerEntity player, World world, RegistryKey<World> dimension, ILootrInventory inventory, LockableLootTileEntity tile, ContainerMinecartEntity cartEntity) {
            super(player, world, dimension, inventory, tile, cartEntity);
        }

        public NonNullList<ItemStack> getContents() {
            return this.inventory.getContents();
        }
    }

    @Cancelable
    public static class Pre
    extends LootrLootingEvent {
        private ResourceLocation newTable = null;
        private long newSeed = Long.MIN_VALUE;

        public Pre(PlayerEntity player, World world, RegistryKey<World> dimension, ILootrInventory inventory, LockableLootTileEntity tile, ContainerMinecartEntity cartEntity) {
            super(player, world, dimension, inventory, tile, cartEntity);
        }

        public ResourceLocation getNewTable() {
            if (this.newTable == null) {
                return this.getTable();
            }
            return this.newTable;
        }

        public void setTable(ResourceLocation newTable) {
            this.newTable = newTable;
        }

        public long getNewSeed() {
            if (this.newSeed == Long.MIN_VALUE) {
                return this.getSeed();
            }
            return this.newSeed;
        }

        public void setSeed(long newSeed) {
            this.newSeed = newSeed;
        }
    }
}

