/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.BlockModel;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.IUnbakedModel;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.Direction;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.TransformationMatrix;
import net.minecraftforge.client.model.IModelConfiguration;
import net.minecraftforge.client.model.IModelLoader;
import net.minecraftforge.client.model.ModelTransformComposition;
import net.minecraftforge.client.model.PerspectiveMapWrapper;
import net.minecraftforge.client.model.data.IDynamicBakedModel;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.geometry.IModelGeometry;
import noobanidus.mods.lootr.blocks.LootrBarrelBlock;

public class BarrelModel
implements IModelGeometry<BarrelModel> {
    private final IUnbakedModel opened;
    private final IUnbakedModel unopened;

    public BarrelModel(IUnbakedModel opened, IUnbakedModel unopened) {
        this.opened = opened;
        this.unopened = unopened;
    }

    public Collection<RenderMaterial> getTextures(IModelConfiguration owner, Function<ResourceLocation, IUnbakedModel> modelGetter, Set<Pair<String, String>> missingTextureErrors) {
        HashSet materials = Sets.newHashSet();
        materials.add(owner.resolveTexture("particle"));
        materials.addAll(this.unopened.func_225614_a_(modelGetter, missingTextureErrors));
        materials.addAll(this.opened.func_225614_a_(modelGetter, missingTextureErrors));
        return materials;
    }

    private static IBakedModel buildModel(IUnbakedModel entry, IModelTransform modelTransform, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, ResourceLocation modelLocation) {
        return entry.func_225613_a_(bakery, spriteGetter, modelTransform, modelLocation);
    }

    public IBakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ItemOverrideList overrides, ResourceLocation modelLocation) {
        return new BarrelBakedModel(owner.useSmoothLighting(), owner.isShadedInGui(), owner.isSideLit(), spriteGetter.apply(owner.resolveTexture("particle")), overrides, BarrelModel.buildModel(this.opened, modelTransform, bakery, spriteGetter, modelLocation), BarrelModel.buildModel(this.unopened, modelTransform, bakery, spriteGetter, modelLocation), (ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix>)PerspectiveMapWrapper.getTransforms((IModelTransform)new ModelTransformComposition(owner.getCombinedTransform(), modelTransform)));
    }

    public static final class Loader
    implements IModelLoader<BarrelModel> {
        public static final Loader INSTANCE = new Loader();

        private Loader() {
        }

        public void func_195410_a(IResourceManager resourceManager) {
        }

        public BarrelModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
            IUnbakedModel unopened = (IUnbakedModel)deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)modelContents, (String)"unopened"), BlockModel.class);
            IUnbakedModel opened = (IUnbakedModel)deserializationContext.deserialize((JsonElement)JSONUtils.func_152754_s((JsonObject)modelContents, (String)"opened"), BlockModel.class);
            return new BarrelModel(opened, unopened);
        }
    }

    private static final class BarrelBakedModel
    implements IDynamicBakedModel {
        private final IBakedModel opened;
        private final IBakedModel unopened;
        private final ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms;
        protected final boolean ambientOcclusion;
        protected final boolean gui3d;
        protected final boolean isSideLit;
        protected final TextureAtlasSprite particle;
        protected final ItemOverrideList overrides;

        public BarrelBakedModel(boolean ambientOcclusion, boolean isGui3d, boolean isSideLit, TextureAtlasSprite particle, ItemOverrideList overrides, IBakedModel opened, IBakedModel unopened, ImmutableMap<ItemCameraTransforms.TransformType, TransformationMatrix> cameraTransforms) {
            this.isSideLit = isSideLit;
            this.cameraTransforms = cameraTransforms;
            this.ambientOcclusion = ambientOcclusion;
            this.gui3d = isGui3d;
            this.particle = particle;
            this.overrides = overrides;
            this.opened = opened;
            this.unopened = unopened;
        }

        @Nonnull
        public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @Nonnull Random rand, @Nonnull IModelData extraData) {
            IBakedModel model = extraData.getData(LootrBarrelBlock.OPENED) == Boolean.TRUE ? this.opened : this.unopened;
            ImmutableList.Builder builder = ImmutableList.builder();
            builder.addAll((Iterable)model.getQuads(state, side, rand, extraData));
            return builder.build();
        }

        public boolean func_177555_b() {
            return this.ambientOcclusion;
        }

        public boolean isAmbientOcclusion(BlockState state) {
            return this.ambientOcclusion;
        }

        public boolean func_177556_c() {
            return this.gui3d;
        }

        public boolean func_230044_c_() {
            return this.isSideLit;
        }

        public boolean func_188618_c() {
            return false;
        }

        public TextureAtlasSprite func_177554_e() {
            return this.particle;
        }

        public TextureAtlasSprite getParticleTexture(@Nonnull IModelData data) {
            if (data.getData(LootrBarrelBlock.OPENED) == Boolean.TRUE) {
                return this.opened.func_177554_e();
            }
            return this.unopened.func_177554_e();
        }

        public boolean doesHandlePerspectives() {
            return true;
        }

        public IBakedModel handlePerspective(ItemCameraTransforms.TransformType cameraTransformType, MatrixStack mat) {
            return PerspectiveMapWrapper.handlePerspective((IBakedModel)this, this.cameraTransforms, (ItemCameraTransforms.TransformType)cameraTransformType, (MatrixStack)mat);
        }

        public ItemOverrideList func_188617_f() {
            return ItemOverrideList.field_188022_a;
        }

        public boolean isLayered() {
            return false;
        }
    }
}

