/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.Registry;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.FolderName;
import net.minecraft.world.storage.WorldSavedData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.LootFiller;
import noobanidus.mods.lootr.api.LootrLootingEvent;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class NewChestData
extends WorldSavedData {
    private BlockPos pos;
    private RegistryKey<World> dimension;
    private UUID entityId;
    private UUID tileId;
    private UUID customId;
    private Map<UUID, SpecialChestInventory> inventories = new HashMap<UUID, SpecialChestInventory>();
    private NonNullList<ItemStack> reference;
    private boolean custom;

    public UUID getEntityId() {
        return this.entityId;
    }

    public static String REF_ID(RegistryKey<World> dimension, UUID id) {
        return "Lootr-custom-" + dimension.func_240901_a_().func_110623_a() + "-" + id.toString();
    }

    public static String OLD_ID(RegistryKey<World> dimension, BlockPos pos) {
        return "Lootr-chests-" + dimension.func_240901_a_().func_110623_a() + "-" + pos.func_218275_a();
    }

    public static String ID(RegistryKey<World> dimension, UUID id) {
        return "Lootr-chests-" + dimension.func_240901_a_().func_110623_a() + "-" + id.toString();
    }

    public static String ENTITY(UUID entityId) {
        return "Lootr-entity-" + entityId.toString();
    }

    public NewChestData(RegistryKey<World> dimension, UUID id, @Nullable UUID customId, @Nullable NonNullList<ItemStack> base) {
        super(NewChestData.REF_ID(dimension, id));
        this.pos = null;
        this.dimension = dimension;
        this.entityId = null;
        this.tileId = id;
        this.reference = base;
        this.custom = true;
        this.customId = customId;
        if (customId == null && base == null) {
            throw new IllegalArgumentException("Both customId and inventory reference cannot be null.");
        }
    }

    public NewChestData(RegistryKey<World> dimension, UUID id) {
        super(NewChestData.ID(dimension, id));
        this.pos = null;
        this.dimension = dimension;
        this.entityId = null;
        this.tileId = id;
        this.reference = null;
        this.custom = false;
        this.customId = null;
    }

    public NewChestData(RegistryKey<World> dimension, BlockPos pos) {
        super(NewChestData.OLD_ID(dimension, pos));
        this.pos = pos;
        this.dimension = dimension;
        this.entityId = null;
        this.tileId = null;
        this.reference = null;
        this.custom = false;
        this.customId = null;
    }

    public NewChestData(UUID entityId) {
        super(NewChestData.ENTITY(entityId));
        this.pos = null;
        this.dimension = null;
        this.tileId = null;
        this.entityId = entityId;
        this.reference = null;
        this.custom = false;
        this.customId = null;
    }

    private LootFiller customInventory() {
        return (player, inventory, table, seed) -> {
            for (int i = 0; i < this.reference.size(); ++i) {
                inventory.func_70299_a(i, ((ItemStack)this.reference.get(i)).func_77946_l());
            }
        };
    }

    public Map<UUID, SpecialChestInventory> getInventories() {
        return this.inventories;
    }

    public void setInventories(Map<UUID, SpecialChestInventory> inventories) {
        this.inventories = inventories;
    }

    private boolean clearInventory(UUID uuid) {
        return this.inventories.remove(uuid) != null;
    }

    @Nullable
    private SpecialChestInventory getInventory(ServerPlayerEntity player, BlockPos pos) {
        SpecialChestInventory result = this.inventories.get(player.func_110124_au());
        if (result != null) {
            result.setBlockPos(pos);
        }
        return result;
    }

    private SpecialChestInventory createInventory(ServerPlayerEntity player, LootFiller filler, @Nullable LockableLootTileEntity tile) {
        SpecialChestInventory result;
        ServerWorld world = (ServerWorld)player.field_70170_p;
        LootrChestMinecartEntity cart = null;
        long seed = -1L;
        if (this.entityId != null) {
            Entity initial = world.func_217461_a(this.entityId);
            if (!(initial instanceof LootrChestMinecartEntity)) {
                return null;
            }
            cart = (LootrChestMinecartEntity)initial;
            NonNullList items = NonNullList.func_191197_a((int)cart.func_70302_i_(), (Object)ItemStack.field_190927_a);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, cart.func_145748_c_(), this.pos);
        } else {
            if (world.func_234923_W_() != this.dimension) {
                MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
                if (server == null) {
                    return null;
                }
                world = server.func_71218_a(this.dimension);
            }
            if (world == null || tile == null) {
                return null;
            }
            NonNullList items = NonNullList.func_191197_a((int)tile.func_70302_i_(), (Object)ItemStack.field_190927_a);
            result = new SpecialChestInventory(this, (NonNullList<ItemStack>)items, tile.func_145748_c_(), this.pos);
        }
        LootrLootingEvent.Pre preEvent = new LootrLootingEvent.Pre((PlayerEntity)player, (World)world, this.dimension, result, tile, cart);
        if (!MinecraftForge.EVENT_BUS.post((Event)preEvent)) {
            filler.fillWithLoot((PlayerEntity)player, result, preEvent.getNewTable(), preEvent.getNewSeed());
            LootrLootingEvent.Post postEvent = new LootrLootingEvent.Post((PlayerEntity)player, (World)world, this.dimension, result, tile, cart);
            MinecraftForge.EVENT_BUS.post((Event)postEvent);
        }
        this.inventories.put(player.func_110124_au(), result);
        this.func_76185_a();
        world.func_217481_x().func_212775_b();
        return result;
    }

    public void func_76184_a(CompoundNBT compound) {
        this.inventories.clear();
        this.pos = null;
        this.dimension = null;
        this.entityId = null;
        this.tileId = null;
        if (compound.func_74764_b("position")) {
            this.pos = BlockPos.func_218283_e((long)compound.func_74763_f("position"));
        }
        if (compound.func_74764_b("dimension")) {
            this.dimension = RegistryKey.func_240903_a_((RegistryKey)Registry.field_239699_ae_, (ResourceLocation)new ResourceLocation(compound.func_74779_i("dimension")));
        }
        if (compound.func_186855_b("entityId")) {
            this.entityId = compound.func_186857_a("entityId");
        }
        if (compound.func_186855_b("tileId")) {
            this.tileId = compound.func_186857_a("tileId");
        }
        if (compound.func_74764_b("custom")) {
            this.custom = compound.func_74767_n("custom");
        }
        if (compound.func_186855_b("customId")) {
            this.customId = compound.func_186857_a("customId");
        }
        if (compound.func_74764_b("reference") && compound.func_74764_b("referenceSize")) {
            int size = compound.func_74762_e("referenceSize");
            this.reference = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound.func_74775_l("reference"), this.reference);
        }
        ListNBT compounds = compound.func_150295_c("inventories", 10);
        for (int i = 0; i < compounds.size(); ++i) {
            CompoundNBT thisTag = compounds.func_150305_b(i);
            CompoundNBT items = thisTag.func_74775_l("chest");
            String name = thisTag.func_74779_i("name");
            UUID uuid = thisTag.func_186857_a("uuid");
            this.inventories.put(uuid, new SpecialChestInventory(this, items, name, this.pos));
        }
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        if (this.pos != null) {
            compound.func_74772_a("position", this.pos.func_218275_a());
        }
        if (this.dimension != null) {
            compound.func_74778_a("dimension", this.dimension.func_240901_a_().toString());
        }
        if (this.entityId != null) {
            compound.func_186854_a("entityId", this.entityId);
        }
        if (this.tileId != null) {
            compound.func_186854_a("tileId", this.tileId);
        }
        if (this.customId != null) {
            compound.func_186854_a("customId", this.customId);
        }
        compound.func_74757_a("custom", this.custom);
        if (this.reference != null) {
            compound.func_74768_a("referenceSize", this.reference.size());
            compound.func_218657_a("reference", (INBT)ItemStackHelper.func_191281_a((CompoundNBT)new CompoundNBT(), this.reference, (boolean)true));
        }
        ListNBT compounds = new ListNBT();
        for (Map.Entry<UUID, SpecialChestInventory> entry : this.inventories.entrySet()) {
            CompoundNBT thisTag = new CompoundNBT();
            thisTag.func_186854_a("uuid", entry.getKey());
            thisTag.func_218657_a("chest", (INBT)entry.getValue().writeItems());
            thisTag.func_74778_a("name", entry.getValue().writeName());
            compounds.add((Object)thisTag);
        }
        compound.func_218657_a("inventories", (INBT)compounds);
        return compound;
    }

    public void clear() {
        this.inventories.clear();
    }

    private static ServerWorld getServerWorld() {
        return ServerLifecycleHooks.getCurrentServer().func_71218_a(World.field_234918_g_);
    }

    private static NewChestData getInstancePos(ServerWorld world, BlockPos pos) {
        RegistryKey dimension = world.func_234923_W_();
        return (NewChestData)NewChestData.getServerWorld().func_217481_x().func_215753_b(() -> new NewChestData((RegistryKey<World>)dimension, pos), NewChestData.OLD_ID((RegistryKey<World>)dimension, pos));
    }

    private static NewChestData getInstanceUuid(ServerWorld world, UUID id) {
        RegistryKey dimension = world.func_234923_W_();
        return (NewChestData)NewChestData.getServerWorld().func_217481_x().func_215752_a(() -> new NewChestData((RegistryKey<World>)dimension, id), NewChestData.ID((RegistryKey<World>)dimension, id));
    }

    private static NewChestData getInstance(ServerWorld world, UUID id) {
        return (NewChestData)NewChestData.getServerWorld().func_217481_x().func_215752_a(() -> new NewChestData(id), NewChestData.ENTITY(id));
    }

    private static NewChestData getInstanceInventory(ServerWorld world, UUID id, @Nullable UUID customId, @Nullable NonNullList<ItemStack> base) {
        RegistryKey dimension = world.func_234923_W_();
        return (NewChestData)NewChestData.getServerWorld().func_217481_x().func_215752_a(() -> new NewChestData((RegistryKey<World>)dimension, id, customId, base), NewChestData.REF_ID((RegistryKey<World>)dimension, id));
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, UUID uuid, BlockPos pos, ServerPlayerEntity player, LockableLootTileEntity tile, LootFiller filler) {
        SpecialChestInventory inventory;
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return null;
        }
        NewChestData data = NewChestData.getInstanceUuid((ServerWorld)world, uuid);
        NewChestData oldData = NewChestData.getInstancePos((ServerWorld)world, pos);
        if (oldData != null) {
            Map<UUID, SpecialChestInventory> inventories = data.getInventories();
            inventories.putAll(oldData.getInventories());
            data.setInventories(inventories);
            oldData.clear();
            oldData.func_76185_a();
        }
        if ((inventory = data.getInventory(player, pos)) == null) {
            inventory = data.createInventory(player, filler, tile);
            inventory.setBlockPos(pos);
        }
        return inventory;
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, UUID uuid, NonNullList<ItemStack> base, ServerPlayerEntity player, BlockPos pos, LockableLootTileEntity tile) {
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return null;
        }
        NewChestData data = NewChestData.getInstanceInventory((ServerWorld)world, uuid, null, base);
        SpecialChestInventory inventory = data.getInventory(player, pos);
        if (inventory == null) {
            inventory = data.createInventory(player, data.customInventory(), tile);
            inventory.setBlockPos(pos);
        }
        return inventory;
    }

    public static boolean clearInventories(ServerPlayerEntity player) {
        return NewChestData.clearInventories(player.func_110124_au());
    }

    public static boolean clearInventories(UUID uuid) {
        ServerWorld world = NewChestData.getServerWorld();
        DimensionSavedDataManager data = world.func_217481_x();
        Path dataPath = world.func_73046_m().func_240776_a_(new FolderName("data"));
        ArrayList ids = new ArrayList();
        try {
            Stream<Path> paths = Files.walk(dataPath, new FileVisitOption[0]);
            Object object = null;
            try {
                paths.forEach(o -> {
                    String name;
                    if (Files.isRegularFile(o, new LinkOption[0]) && (name = o.getFileName().toString()).startsWith("Lootr-")) {
                        ids.add(name.replace(".dat", ""));
                    }
                });
            }
            catch (Throwable throwable) {
                object = throwable;
                throw throwable;
            }
            finally {
                if (paths != null) {
                    if (object != null) {
                        try {
                            paths.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)object).addSuppressed(throwable);
                        }
                    } else {
                        paths.close();
                    }
                }
            }
        }
        catch (IOException e) {
            return false;
        }
        int cleared = 0;
        for (String id : ids) {
            NewChestData chestData = (NewChestData)data.func_215753_b(() -> null, id);
            if (chestData == null || !chestData.clearInventory(uuid)) continue;
            ++cleared;
            chestData.func_76185_a();
        }
        data.func_212775_b();
        Lootr.LOG.info("Cleared " + cleared + " inventories for play UUID " + uuid.toString());
        return cleared != 0;
    }

    @Nullable
    public static SpecialChestInventory getInventory(World world, LootrChestMinecartEntity cart, ServerPlayerEntity player, LootFiller filler) {
        if (world.field_72995_K || !(world instanceof ServerWorld)) {
            return null;
        }
        NewChestData data = NewChestData.getInstance((ServerWorld)world, cart.func_110124_au());
        SpecialChestInventory inventory = data.getInventory(player, null);
        if (inventory == null) {
            inventory = data.createInventory(player, filler, null);
        }
        return inventory;
    }

    public static void wipeInventory(ServerWorld world, BlockPos pos) {
        ServerWorld serverWorld = NewChestData.getServerWorld();
        RegistryKey dimension = world.func_234923_W_();
        DimensionSavedDataManager manager = serverWorld.func_217481_x();
        String id = NewChestData.OLD_ID((RegistryKey<World>)dimension, pos);
        if (!manager.field_212778_c.containsKey(id)) {
            return;
        }
        NewChestData data = (NewChestData)manager.func_215753_b(() -> null, id);
        if (data != null) {
            data.clear();
            data.func_76185_a();
        }
    }

    public static void deleteLootChest(ServerWorld world, BlockPos pos) {
        if (world.func_201670_d()) {
            return;
        }
        NewChestData.wipeInventory(world, pos);
        NewChestData.getServerWorld().func_217481_x().func_212775_b();
    }
}

