/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.data;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import noobanidus.mods.lootr.api.ILootTile;
import noobanidus.mods.lootr.api.ILootrInventory;
import noobanidus.mods.lootr.data.NewChestData;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;

public class SpecialChestInventory
implements ILootrInventory {
    private NewChestData newChestData;
    private final NonNullList<ItemStack> contents;
    private final ITextComponent name;
    @Nullable
    private BlockPos pos;

    public SpecialChestInventory(NewChestData newChestData, NonNullList<ItemStack> contents, ITextComponent name, @Nullable BlockPos pos) {
        this.newChestData = newChestData;
        this.contents = contents;
        this.name = name;
        this.pos = pos;
    }

    public SpecialChestInventory(NewChestData newChestData, CompoundNBT items, String componentAsJSON, BlockPos pos) {
        this.newChestData = newChestData;
        this.name = ITextComponent.Serializer.func_240643_a_((String)componentAsJSON);
        this.contents = NonNullList.func_191197_a((int)27, (Object)ItemStack.field_190927_a);
        ItemStackHelper.func_191283_b((CompoundNBT)items, this.contents);
        this.pos = pos;
    }

    public void setBlockPos(BlockPos pos) {
        this.pos = pos;
    }

    @Override
    @Nullable
    public LockableLootTileEntity getTile(World world) {
        if (world == null || world.func_201670_d() || this.pos == null) {
            return null;
        }
        TileEntity te = world.func_175625_s(this.pos);
        if (te instanceof ILootTile) {
            return (LockableLootTileEntity)te;
        }
        return null;
    }

    @Override
    @Nullable
    public LootrChestMinecartEntity getEntity(World world) {
        if (world == null || world.func_201670_d() || this.newChestData.getEntityId() == null) {
            return null;
        }
        if (!(world instanceof ServerWorld)) {
            return null;
        }
        ServerWorld serverWorld = (ServerWorld)world;
        Entity entity = serverWorld.func_217461_a(this.newChestData.getEntityId());
        if (entity instanceof LootrChestMinecartEntity) {
            return (LootrChestMinecartEntity)entity;
        }
        return null;
    }

    public int func_70302_i_() {
        return 27;
    }

    public boolean func_191420_l() {
        for (ItemStack itemstack : this.contents) {
            if (itemstack.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.contents.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack itemstack = ItemStackHelper.func_188382_a(this.contents, (int)index, (int)count);
        if (!itemstack.func_190926_b()) {
            this.func_70296_d();
        }
        return itemstack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack result = ItemStackHelper.func_188383_a(this.contents, (int)index);
        if (!result.func_190926_b()) {
            this.func_70296_d();
        }
        return result;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.contents.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void func_70296_d() {
        this.newChestData.func_76185_a();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public void func_174888_l() {
        this.contents.clear();
        this.func_70296_d();
    }

    public ITextComponent func_145748_c_() {
        return this.name;
    }

    @Nullable
    public Container createMenu(int id, PlayerInventory inventory, PlayerEntity player) {
        return ChestContainer.func_216992_a((int)id, (PlayerInventory)inventory, (IInventory)this);
    }

    public void func_174889_b(PlayerEntity player) {
        LootrChestMinecartEntity entity;
        World world = player.field_70170_p;
        LockableLootTileEntity tile = this.getTile(world);
        if (tile != null) {
            tile.func_174889_b(player);
        }
        if (this.newChestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.func_174889_b(player);
        }
    }

    public void func_174886_c(PlayerEntity player) {
        LootrChestMinecartEntity entity;
        LockableLootTileEntity tile;
        this.func_70296_d();
        World world = player.field_70170_p;
        if (this.pos != null && (tile = this.getTile(world)) != null) {
            tile.func_174886_c(player);
        }
        if (this.newChestData.getEntityId() != null && (entity = this.getEntity(world)) != null) {
            entity.func_174886_c(player);
        }
    }

    public CompoundNBT writeItems() {
        CompoundNBT result = new CompoundNBT();
        return ItemStackHelper.func_191282_a((CompoundNBT)result, this.contents);
    }

    public String writeName() {
        return ITextComponent.Serializer.func_150696_a((ITextComponent)this.name);
    }

    @Override
    @Nullable
    public BlockPos getPos() {
        return this.pos;
    }

    @Override
    public NonNullList<ItemStack> getContents() {
        return this.contents;
    }
}

