/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.mixins;

import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.block.ChestBlock;
import net.minecraft.state.Property;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.chunk.IChunk;
import noobanidus.mods.lootr.api.ILootTile;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.world.processor.LootrChestProcessor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={LockableLootTileEntity.class})
public class MixinLockableLootTileEntity {
    private Logger log = LogManager.getLogger((String)"lootr");

    @Inject(method={"Lnet/minecraft/tileentity/LockableLootTileEntity;setLootTable(Lnet/minecraft/world/IBlockReader;Ljava/util/Random;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/util/ResourceLocation;)V"}, at={@At(value="HEAD")})
    private static void setLootTable(IBlockReader reader, Random rand, BlockPos pos, ResourceLocation lootTableIn, CallbackInfo info) {
        BlockState state;
        BlockState replacement;
        if (reader instanceof IServerWorld && (replacement = LootrChestProcessor.replacement(state = reader.func_180495_p(pos))) != null) {
            IServerWorld world = (IServerWorld)reader;
            IChunk chunk = world.func_217349_x(pos);
            chunk.func_177425_e(pos);
            if (state.func_235904_r_().contains(ChestBlock.field_204511_c)) {
                replacement = (BlockState)replacement.func_206870_a((Property)ChestBlock.field_204511_c, state.func_177229_b((Property)ChestBlock.field_204511_c));
            }
            world.func_180501_a(pos, replacement, 2);
            TileEntity te = replacement.func_177230_c().createTileEntity(replacement, reader);
            if (te != null) {
                chunk.func_177426_a(pos, te);
            }
        }
    }

    @Inject(method={"Lnet/minecraft/tileentity/LockableLootTileEntity;setLootTable(Lnet/minecraft/util/ResourceLocation;J)V"}, at={@At(value="HEAD")})
    private void setLootTable(ResourceLocation table, long seed, CallbackInfo info) {
        if (this instanceof ILootTile || !((Boolean)ConfigManager.REPORT_TABLES.get()).booleanValue()) {
            return;
        }
        HashSet modids = Sets.newHashSet((Object[])new String[]{"apotheosis", "artifacts"});
        if (table != null && modids.contains(table.func_110624_b())) {
            return;
        }
        StackTraceElement[] stacktrace = Thread.currentThread().getStackTrace();
        this.log.error("\n=================================================\n  Lootr detected a loot chest creation that it \n  can't replace. Please consider reporting it!\n    Table: " + table + "\n    Location: " + ((LockableLootTileEntity)this).func_174877_v().toString() + "\n    Stack: " + stacktrace[3].toString() + "\n           " + stacktrace[4].toString() + "\n           " + stacktrace[5].toString());
    }
}

