/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.tiles;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.loot.LootContext;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootParameters;
import net.minecraft.loot.LootTable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.Property;
import net.minecraft.tileentity.BarrelTileEntity;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.data.ModelDataMap;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import noobanidus.mods.lootr.api.ILootTile;
import noobanidus.mods.lootr.blocks.LootrBarrelBlock;
import noobanidus.mods.lootr.config.ConfigManager;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModTiles;
import noobanidus.mods.lootr.tiles.SpecialLootChestTile;
import noobanidus.mods.lootr.util.Getter;

public class SpecialLootBarrelTile
extends BarrelTileEntity
implements ILootTile {
    public Set<UUID> openers = new HashSet<UUID>();
    private int specialNumPlayersUsingBarrel;
    private ResourceLocation savedLootTable = null;
    private long seed = -1L;
    private UUID tileId = null;

    public SpecialLootBarrelTile() {
        super(ModTiles.SPECIAL_LOOT_BARREL);
    }

    @Nonnull
    public IModelData getModelData() {
        ModelDataMap data = new ModelDataMap.Builder().withInitial(LootrBarrelBlock.OPENED, (Object)false).build();
        PlayerEntity player = Getter.getPlayer();
        if (player != null) {
            data.setData(LootrBarrelBlock.OPENED, (Object)this.openers.contains(player.func_110124_au()));
        }
        return data;
    }

    @Override
    public UUID getTileId() {
        if (this.tileId == null) {
            this.tileId = UUID.randomUUID();
        }
        return this.tileId;
    }

    public void func_189404_a(ResourceLocation lootTableIn, long seedIn) {
        this.savedLootTable = lootTableIn;
        this.seed = seedIn;
        super.func_189404_a(lootTableIn, seedIn);
    }

    public void func_184281_d(@Nullable PlayerEntity player) {
    }

    @Override
    public void fillWithLoot(PlayerEntity player, IInventory inventory, @Nullable ResourceLocation overrideTable, long seed) {
        if (this.field_145850_b != null && this.savedLootTable != null && this.field_145850_b.func_73046_m() != null) {
            LootTable loottable = this.field_145850_b.func_73046_m().func_200249_aQ().func_186521_a(overrideTable != null ? overrideTable : this.savedLootTable);
            if (player instanceof ServerPlayerEntity) {
                CriteriaTriggers.field_232608_N_.func_235478_a_((ServerPlayerEntity)player, overrideTable != null ? overrideTable : this.field_184284_m);
            }
            LootContext.Builder builder = new LootContext.Builder((ServerWorld)this.field_145850_b).func_216015_a(LootParameters.field_237457_g_, (Object)Vector3d.func_237489_a_((Vector3i)this.field_174879_c)).func_216016_a((Boolean)ConfigManager.RANDOMISE_SEED.get() != false ? ThreadLocalRandom.current().nextLong() : (seed == Long.MIN_VALUE ? this.seed : seed));
            if (player != null) {
                builder.func_186469_a(player.func_184817_da()).func_216015_a(LootParameters.field_216281_a, (Object)player);
            }
            loottable.func_216118_a(inventory, builder.func_216022_a(LootParameterSets.field_216261_b));
        }
    }

    @Override
    public ResourceLocation getTable() {
        return this.savedLootTable;
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public Set<UUID> getOpeners() {
        return this.openers;
    }

    public void func_230337_a_(BlockState state, CompoundNBT compound) {
        if (compound.func_150297_b("specialLootChest_table", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("specialLootChest_table"));
        }
        if (compound.func_150297_b("specialLootChest_seed", 4)) {
            this.seed = compound.func_74763_f("specialLootChest_seed");
        }
        if (this.savedLootTable == null && compound.func_150297_b("LootTable", 8)) {
            this.savedLootTable = new ResourceLocation(compound.func_74779_i("LootTable"));
            if (compound.func_150297_b("LootTableSeed", 4)) {
                this.seed = compound.func_74763_f("LootTableSeed");
            }
            this.func_189404_a(this.savedLootTable, this.seed);
        }
        if (compound.func_186855_b("tileId")) {
            this.tileId = compound.func_186857_a("tileId");
        } else if (this.tileId == null) {
            this.getTileId();
        }
        if (compound.func_74764_b("LootrOpeners")) {
            ListNBT openers = compound.func_150295_c("LootrOpeners", 11);
            this.openers.clear();
            for (INBT item : openers) {
                this.openers.add(NBTUtil.func_186860_b((INBT)item));
            }
        }
        this.requestModelDataUpdate();
        super.func_230337_a_(state, compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        if (this.savedLootTable != null) {
            compound.func_74778_a("specialLootBarrel_table", this.savedLootTable.toString());
            compound.func_74778_a("LootTable", this.savedLootTable.toString());
        }
        if (this.seed != -1L) {
            compound.func_74772_a("specialLootBarrel_seed", this.seed);
            compound.func_74772_a("LootTableSeed", this.seed);
        }
        compound.func_186854_a("tileId", this.getTileId());
        ListNBT list = new ListNBT();
        for (UUID opener : this.openers) {
            list.add((Object)NBTUtil.func_240626_a_((UUID)opener));
        }
        compound.func_218657_a("LootrOpeners", (INBT)list);
        return compound;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        return LazyOptional.empty();
    }

    public void func_213962_h() {
        int x = this.field_174879_c.func_177958_n();
        int y = this.field_174879_c.func_177956_o();
        int z = this.field_174879_c.func_177952_p();
        this.specialNumPlayersUsingBarrel = SpecialLootChestTile.calculatePlayersUsing(this.field_145850_b, (LockableTileEntity)this, x, y, z);
        if (this.specialNumPlayersUsingBarrel > 0) {
            this.scheduleTick();
        } else {
            BlockState state = this.func_195044_w();
            if (state.func_177230_c() != ModBlocks.BARREL && state.func_177230_c() != Blocks.field_222422_lK) {
                this.func_145843_s();
                return;
            }
            boolean open = (Boolean)state.func_177229_b((Property)BarrelBlock.field_220093_b);
            if (open) {
                this.playSound(state, SoundEvents.field_219601_N);
                this.setOpenProperty(state, false);
            }
        }
    }

    private void setOpenProperty(BlockState state, boolean open) {
        this.field_145850_b.func_180501_a(this.func_174877_v(), (BlockState)state.func_206870_a((Property)BarrelBlock.field_220093_b, (Comparable)Boolean.valueOf(open)), 3);
    }

    private void playSound(BlockState state, SoundEvent sound) {
        Vector3i dir = ((Direction)state.func_177229_b((Property)BarrelBlock.field_220092_a)).func_176730_m();
        double x = (double)this.field_174879_c.func_177958_n() + 0.5 + (double)dir.func_177958_n() / 2.0;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)dir.func_177956_o() / 2.0;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5 + (double)dir.func_177952_p() / 2.0;
        this.field_145850_b.func_184148_a(null, x, y, z, sound, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
    }

    private void scheduleTick() {
        this.field_145850_b.func_205220_G_().func_205360_a(this.func_174877_v(), (Object)this.func_195044_w().func_177230_c(), 5);
    }

    public void func_174889_b(PlayerEntity player) {
        if (!player.func_175149_v()) {
            if (this.specialNumPlayersUsingBarrel < 0) {
                this.specialNumPlayersUsingBarrel = 0;
            }
            ++this.specialNumPlayersUsingBarrel;
            BlockState state = this.func_195044_w();
            boolean open = (Boolean)state.func_177229_b((Property)BarrelBlock.field_220093_b);
            if (!open) {
                this.playSound(state, SoundEvents.field_219602_O);
                this.setOpenProperty(state, true);
            }
            this.scheduleTick();
        }
    }

    public void func_174886_c(PlayerEntity player) {
        if (!player.func_175149_v()) {
            --this.specialNumPlayersUsingBarrel;
            this.openers.add(player.func_110124_au());
            this.func_70296_d();
            this.updatePacketViaState();
        }
    }

    public void updatePacketViaState() {
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            BlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
            this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 8);
        }
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(@Nonnull NetworkManager net, @Nonnull SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(ModBlocks.CHEST.func_176223_P(), pkt.func_148857_g());
    }
}

