/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.util;

import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ChestBlock;
import net.minecraft.entity.monster.piglin.PiglinTasks;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.LockableLootTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import noobanidus.mods.lootr.Lootr;
import noobanidus.mods.lootr.api.ILootTile;
import noobanidus.mods.lootr.data.NewChestData;
import noobanidus.mods.lootr.data.SpecialChestInventory;
import noobanidus.mods.lootr.entity.LootrChestMinecartEntity;
import noobanidus.mods.lootr.init.ModStats;
import noobanidus.mods.lootr.tiles.SpecialLootInventoryTile;

public class ChestUtil {
    public static Random random = new Random();
    public static Set<Class<?>> tileClasses = new HashSet();

    public static boolean handleLootChest(Block block, World world, BlockPos pos, PlayerEntity player) {
        if (world.func_201670_d()) {
            return false;
        }
        if (player.func_175149_v()) {
            player.func_213829_a(null);
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof ILootTile) {
            if (block instanceof BarrelBlock) {
                Lootr.BARREL_PREDICATE.trigger((ServerPlayerEntity)player, null);
            } else if (block instanceof ChestBlock) {
                Lootr.CHEST_PREDICATE.trigger((ServerPlayerEntity)player, null);
            }
            SpecialChestInventory provider = NewChestData.getInventory(world, ((ILootTile)te).getTileId(), pos, (ServerPlayerEntity)player, (LockableLootTileEntity)te, ((ILootTile)te)::fillWithLoot);
            if (!((ILootTile)te).getOpeners().contains(player.func_110124_au())) {
                player.func_71029_a(ModStats.LOOTED_STAT);
                Lootr.SCORE_PREDICATE.trigger((ServerPlayerEntity)player, null);
            }
            player.func_213829_a((INamedContainerProvider)provider);
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            return true;
        }
        return false;
    }

    public static void handleLootCart(World world, LootrChestMinecartEntity cart, PlayerEntity player) {
        if (!world.func_201670_d()) {
            if (player.func_175149_v()) {
                player.func_213829_a(null);
            }
            Lootr.CART_PREDICATE.trigger((ServerPlayerEntity)player, null);
            if (!cart.getOpeners().contains(player.func_110124_au())) {
                cart.addOpener(player);
                player.func_71029_a(ModStats.LOOTED_STAT);
                Lootr.SCORE_PREDICATE.trigger((ServerPlayerEntity)player, null);
            }
            SpecialChestInventory provider = NewChestData.getInventory(world, cart, (ServerPlayerEntity)player, cart::addLoot);
            player.func_213829_a((INamedContainerProvider)provider);
        }
    }

    public static boolean handleLootInventory(Block block, World world, BlockPos pos, PlayerEntity player) {
        if (world.func_201670_d()) {
            return false;
        }
        if (player.func_175149_v()) {
            player.func_213829_a(null);
            return false;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof SpecialLootInventoryTile) {
            Lootr.CHEST_PREDICATE.trigger((ServerPlayerEntity)player, null);
            SpecialLootInventoryTile tile = (SpecialLootInventoryTile)te;
            NonNullList<ItemStack> stacks = null;
            if (tile.getCustomInventory() != null) {
                stacks = ChestUtil.copyItemList(tile.getCustomInventory());
            }
            SpecialChestInventory provider = NewChestData.getInventory(world, tile.getTileId(), stacks, (ServerPlayerEntity)player, pos, (LockableLootTileEntity)tile);
            if (!((ILootTile)te).getOpeners().contains(player.func_110124_au())) {
                player.func_71029_a(ModStats.LOOTED_STAT);
                Lootr.SCORE_PREDICATE.trigger((ServerPlayerEntity)player, null);
            }
            player.func_213829_a((INamedContainerProvider)provider);
            PiglinTasks.func_234478_a_((PlayerEntity)player, (boolean)true);
            return true;
        }
        return false;
    }

    public static NonNullList<ItemStack> copyItemList(NonNullList<ItemStack> reference) {
        NonNullList contents = NonNullList.func_191197_a((int)reference.size(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < reference.size(); ++i) {
            contents.set(i, (Object)((ItemStack)reference.get(i)).func_77946_l());
        }
        return contents;
    }
}

