/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.world.processor;

import com.mojang.serialization.Codec;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.BarrelBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ChestBlock;
import net.minecraft.state.Property;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.gen.feature.template.IStructureProcessorType;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import noobanidus.mods.lootr.init.ModBlocks;
import noobanidus.mods.lootr.init.ModMisc;

public class LootrChestProcessor
extends StructureProcessor {
    public static final LootrChestProcessor INSTANCE = new LootrChestProcessor();
    public static final Codec<LootrChestProcessor> CODEC = Codec.unit(() -> INSTANCE);
    private static Map<Block, Block> replacements = null;

    protected IStructureProcessorType<?> func_215192_a() {
        return ModMisc.LOOTR_PROCESSOR;
    }

    public static BlockState replacement(BlockState original) {
        Block replacement;
        if (replacements == null) {
            replacements = new HashMap<Block, Block>();
            replacements.put(Blocks.field_150486_ae, (Block)ModBlocks.CHEST);
            replacements.put(Blocks.field_222422_lK, (Block)ModBlocks.BARREL);
            replacements.put(Blocks.field_150447_bR, (Block)ModBlocks.TRAPPED_CHEST);
        }
        if ((replacement = replacements.get(original.func_177230_c())) == null) {
            return null;
        }
        BlockState newState = replacement.func_176223_P();
        if (replacement == ModBlocks.CHEST || replacement == ModBlocks.TRAPPED_CHEST) {
            newState = (BlockState)((BlockState)newState.func_206870_a((Property)ChestBlock.field_176459_a, original.func_177229_b((Property)ChestBlock.field_176459_a))).func_206870_a((Property)ChestBlock.field_204511_c, original.func_177229_b((Property)ChestBlock.field_204511_c));
        } else if (replacement == ModBlocks.BARREL) {
            newState = (BlockState)((BlockState)newState.func_206870_a((Property)BarrelBlock.field_220093_b, original.func_177229_b((Property)BarrelBlock.field_220093_b))).func_206870_a((Property)BarrelBlock.field_220092_a, original.func_177229_b((Property)BarrelBlock.field_220092_a));
        }
        return newState;
    }

    @Nullable
    public Template.BlockInfo process(IWorldReader world, BlockPos pos, BlockPos blockPos, Template.BlockInfo info1, Template.BlockInfo info2, PlacementSettings placement, @Nullable Template template) {
        if (info2.field_186244_c == null || !info2.field_186244_c.func_150297_b("LootTable", 8)) {
            return info2;
        }
        BlockState state = info2.field_186243_b;
        BlockState replacement = LootrChestProcessor.replacement(state);
        if (replacement == null) {
            return info2;
        }
        return new Template.BlockInfo(info2.field_186242_a, replacement, info2.field_186244_c);
    }
}

